/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.resources.ui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.mylyn.context.core.AbstractContextStructureBridge;
import org.eclipse.mylyn.context.core.ContextCorePlugin;
import org.eclipse.mylyn.context.core.IInteractionElement;
import org.eclipse.mylyn.context.ui.AbstractContextUiBridge;
import org.eclipse.mylyn.monitor.core.StatusHandler;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceUiBridge
extends AbstractContextUiBridge {
    public void open(IInteractionElement element) {
        AbstractContextStructureBridge bridge = ContextCorePlugin.getDefault().getStructureBridge(element.getContentType());
        if (bridge == null) {
            return;
        }
        IResource resource = (IResource)bridge.getObjectForHandle(element.getHandleIdentifier());
        if (resource instanceof IFile && resource.exists()) {
            this.internalOpenEditor((IFile)resource, true);
        }
    }

    private void internalOpenEditor(IFile file, boolean activate) {
        try {
            IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            IEditorDescriptor editorDescriptor = IDE.getDefaultEditor((IFile)file);
            if (editorDescriptor != null && editorDescriptor.isInternal() && !editorDescriptor.isOpenInPlace() && !this.isContextIgnoring(editorDescriptor)) {
                IDE.openEditor((IWorkbenchPage)activePage, (IFile)file, (boolean)activate);
            }
        }
        catch (PartInitException e) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.resources.ui", "Failed to open editor for: \"" + file + "\"", (Throwable)e));
        }
    }

    private boolean isContextIgnoring(IEditorDescriptor editorDescriptor) {
        return editorDescriptor.getId() != null && editorDescriptor.getId().endsWith(".contextIgnoring");
    }

    public void close(IInteractionElement element) {
        IWorkbenchPage page;
        AbstractContextStructureBridge bridge = ContextCorePlugin.getDefault().getStructureBridge(element.getContentType());
        Object object = bridge.getObjectForHandle(element.getHandleIdentifier());
        if (object instanceof IFile && (page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage()) != null) {
            ArrayList<IEditorReference> toClose = new ArrayList<IEditorReference>(0);
            IEditorReference[] iEditorReferenceArray = page.getEditorReferences();
            int n = iEditorReferenceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IEditorReference reference = iEditorReferenceArray[n2];
                try {
                    IResource input = (IResource)reference.getEditorInput().getAdapter(IResource.class);
                    if (input instanceof IFile && ((IFile)input).equals(object)) {
                        toClose.add(reference);
                    }
                }
                catch (PartInitException partInitException) {}
                ++n2;
            }
            if (toClose.size() > 0) {
                page.closeEditors(toClose.toArray(new IEditorReference[toClose.size()]), true);
            }
        }
    }

    public boolean acceptsEditor(IEditorPart editorPart) {
        return false;
    }

    public List<TreeViewer> getContentOutlineViewers(IEditorPart editor) {
        return Collections.emptyList();
    }

    public Object getObjectForTextSelection(TextSelection selection, IEditorPart editor) {
        return null;
    }

    public IInteractionElement getElement(IEditorInput input) {
        Object adapter = input.getAdapter(IResource.class);
        if (adapter instanceof IFile) {
            IFile javaElement = (IFile)adapter;
            String handle = ContextCorePlugin.getDefault().getStructureBridge((Object)javaElement).getHandleIdentifier((Object)javaElement);
            return ContextCorePlugin.getContextManager().getElement(handle);
        }
        return null;
    }

    public String getContentType() {
        return "resource";
    }
}

