/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.resources.ui;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.context.core.ContextCorePlugin;
import org.eclipse.mylyn.internal.resources.ui.ResourcesUiPreferenceInitializer;
import org.eclipse.mylyn.monitor.core.InteractionEvent;
import org.eclipse.mylyn.monitor.core.StatusHandler;
import org.eclipse.mylyn.resources.ResourcesUiBridgePlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceChangeMonitor
implements IResourceChangeListener {
    private boolean enabled = true;

    public void resourceChanged(IResourceChangeEvent event) {
        if (!this.enabled || !ContextCorePlugin.getContextManager().isContextActive()) {
            return;
        }
        if (event.getType() != 1) {
            return;
        }
        final HashSet<IResource> addedResources = new HashSet<IResource>();
        final HashSet<IResource> changedResources = new HashSet<IResource>();
        final Set<String> excludedPatterns = ResourcesUiPreferenceInitializer.getExcludedResourcePatterns();
        excludedPatterns.addAll(ResourcesUiPreferenceInitializer.getForcedExcludedResourcePatterns());
        IResourceDelta rootDelta = event.getDelta();
        IResourceDeltaVisitor visitor = new IResourceDeltaVisitor(){

            public boolean visit(IResourceDelta delta) {
                IResourceDelta[] added = delta.getAffectedChildren(1);
                int i = 0;
                while (i < added.length) {
                    IResource resource = added[i].getResource();
                    if ((resource instanceof IFile || resource instanceof IFolder) && !ResourceChangeMonitor.this.isExcluded(resource.getProjectRelativePath(), resource, excludedPatterns)) {
                        addedResources.add(resource);
                    }
                    ++i;
                }
                IResourceDelta[] changed = delta.getAffectedChildren(6);
                int i2 = 0;
                while (i2 < changed.length) {
                    IResource resource = changed[i2].getResource();
                    if (resource instanceof IFile) {
                        changedResources.add(resource);
                    }
                    ++i2;
                }
                return true;
            }
        };
        try {
            rootDelta.accept(visitor);
            ResourcesUiBridgePlugin.getInterestUpdater().addResourceToContext(changedResources, InteractionEvent.Kind.PREDICTION);
            ResourcesUiBridgePlugin.getInterestUpdater().addResourceToContext(addedResources, InteractionEvent.Kind.SELECTION);
        }
        catch (CoreException e) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.resources.ui", "Could not accept marker visitor", (Throwable)e));
        }
    }

    public boolean isExcluded(IPath path, IResource resource, Set<String> excludedPatterns) {
        boolean excluded = false;
        for (String pattern : excludedPatterns) {
            if (resource != null && pattern.startsWith("file:/")) {
                excluded |= this.isUriExcluded(resource.getLocationURI().toString(), pattern);
            } else {
                String[] stringArray = path.segments();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String segment = stringArray[n2];
                    excluded |= segment.matches(pattern.replaceAll("\\.", "\\\\.").replaceAll("\\*", ".*"));
                    ++n2;
                }
            }
            if (excluded) break;
        }
        return excluded;
    }

    public boolean isUriExcluded(String uri, String pattern) {
        return uri != null && uri.startsWith(pattern);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }
}

