/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.resources.ui;

import java.util.ArrayList;
import org.eclipse.compare.internal.CompareEditor;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.mylyn.context.core.AbstractContextStructureBridge;
import org.eclipse.mylyn.context.core.ContextCorePlugin;
import org.eclipse.mylyn.context.core.IInteractionElement;
import org.eclipse.mylyn.context.ui.AbstractContextUiBridge;
import org.eclipse.mylyn.context.ui.ContextUiPlugin;
import org.eclipse.mylyn.internal.resources.ui.IContextAwareEditor;
import org.eclipse.mylyn.monitor.core.InteractionEvent;
import org.eclipse.mylyn.monitor.ui.AbstractEditorTracker;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class EditorInteractionMonitor
extends AbstractEditorTracker {
    public static final String SOURCE_ID = "org.eclipse.mylyn.ide.editor.tracker.interest";

    protected void editorBroughtToTop(IEditorPart part) {
        Object object = part.getEditorInput().getAdapter(IResource.class);
        if (object instanceof IResource) {
            IResource resource = (IResource)object;
            AbstractContextStructureBridge bridge = ContextCorePlugin.getDefault().getStructureBridge((Object)resource);
            InteractionEvent selectionEvent = new InteractionEvent(InteractionEvent.Kind.SELECTION, bridge.getContentType(), bridge.getHandleIdentifier((Object)resource), part.getSite().getId());
            ContextCorePlugin.getContextManager().processInteractionEvent(selectionEvent);
        }
    }

    public void editorOpened(IEditorPart editorPartOpened) {
        IWorkbenchPage page = editorPartOpened.getSite().getPage();
        ArrayList<IEditorReference> toClose = new ArrayList<IEditorReference>();
        IEditorReference[] iEditorReferenceArray = page.getEditorReferences();
        int n = iEditorReferenceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorReference editorReference = iEditorReferenceArray[n2];
            try {
                IInteractionElement element = null;
                Object adapter = editorReference.getEditorInput().getAdapter(IResource.class);
                if (adapter instanceof IFile) {
                    String handle = ContextCorePlugin.getDefault().getStructureBridge(adapter).getHandleIdentifier(adapter);
                    element = ContextCorePlugin.getContextManager().getElement(handle);
                }
                if (!(ContextCorePlugin.getContextManager().isContextCapturePaused() || element == null || element.getInterest().isInteresting() || this.isSameEditor(editorPartOpened, editorReference))) {
                    toClose.add(editorReference);
                }
            }
            catch (PartInitException partInitException) {}
            ++n2;
        }
        if (toClose.size() > 0) {
            page.closeEditors(toClose.toArray(new IEditorReference[toClose.size()]), true);
        }
    }

    private boolean isSameEditor(IEditorPart editorPart1, IEditorReference editorReference2) throws PartInitException {
        if (editorPart1 == null || editorReference2 == null) {
            return false;
        }
        return editorPart1.getEditorInput().equals(editorReference2.getEditorInput());
    }

    public void editorClosed(IEditorPart editorPart) {
        if (PlatformUI.getWorkbench().isClosing()) {
            return;
        }
        if (ContextUiPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.mylyn.context.ui.close.action.manage") && !this.otherEditorsOpenForResource(editorPart) && !(editorPart instanceof CompareEditor) && !(editorPart instanceof IContextAwareEditor)) {
            Object adapter;
            if (ContextCorePlugin.getContextManager().isContextActive() && ContextUiPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.mylyn.context.ui.close.action.manage.warning")) {
                try {
                    MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Mylyn", (String)"Closing a file automatically removes it from the Task Context. This is recommended in order to make the open editors match the focused views. It can be disabled via Preferences -> Mylyn -> Context.\n\nThis dialog will not show again.");
                }
                finally {
                    ContextUiPlugin.getDefault().getPreferenceStore().setValue("org.eclipse.mylyn.context.ui.close.action.manage.warning", false);
                }
            }
            IInteractionElement element = null;
            AbstractContextUiBridge uiBridge = ContextUiPlugin.getDefault().getUiBridgeForEditor(editorPart);
            Object object = uiBridge.getObjectForTextSelection(null, editorPart);
            if (object != null) {
                AbstractContextStructureBridge bridge = ContextCorePlugin.getDefault().getStructureBridge(object);
                element = ContextCorePlugin.getContextManager().getElement(bridge.getHandleIdentifier(object));
            }
            if (element == null && (adapter = editorPart.getEditorInput().getAdapter(IResource.class)) instanceof IResource) {
                IResource resource = (IResource)adapter;
                AbstractContextStructureBridge resourceBridge = ContextCorePlugin.getDefault().getStructureBridge((Object)resource);
                element = ContextCorePlugin.getContextManager().getElement(resourceBridge.getHandleIdentifier((Object)resource));
            }
            if (element != null) {
                ContextCorePlugin.getContextManager().manipulateInterestForElement(element, false, false, false, SOURCE_ID);
            }
        }
    }

    private boolean otherEditorsOpenForResource(IEditorPart editorPart) {
        Object adapter = editorPart.getEditorInput().getAdapter(IResource.class);
        if (adapter instanceof IResource) {
            IResource resource = (IResource)adapter;
            IWorkbenchPage page = editorPart.getSite().getPage();
            IEditorReference[] iEditorReferenceArray = page.getEditorReferences();
            int n = iEditorReferenceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IEditorReference editorReference = iEditorReferenceArray[n2];
                try {
                    Object otherAdapter = editorReference.getEditorInput().getAdapter(IResource.class);
                    if (otherAdapter instanceof IResource && otherAdapter.equals(resource)) {
                        return true;
                    }
                }
                catch (PartInitException partInitException) {}
                ++n2;
            }
        }
        return false;
    }
}

