// Copyright 1999 Macromedia, Inc. All rights reserved.

//*************** GLOBALS  *****************

var NEWLINE = (navigator.platform != "Win32") ? "\x0D" : "\x0D\x0A";

var FILE_configPath = dw.getConfigurationPath();
var FILE_menus = FILE_configPath + "/Menus/menus.xml";
var FILE_menuBackup = FILE_menus + ".preExtensionManager";

var FILE_Manage = FILE_configPath + "/Commands/Manage Extensions.htm";
var FILE_Help = FILE_configPath + "/Commands/Extension Help.htm";

var FILE_Install = FILE_configPath + "/Startup/EM_Install.htm";

//******************* API **********************

function install()
{
	if (DWfile.exists(FILE_Manage))
	{
		if (insertMenus())
		{
			if (DWfile.exists(FILE_Install))
			{	
				DWfile.write(FILE_Install, "<HTML><HEAD></HEAD><BODY></BODY></HTML>");
			}
		}
	}
}

//***************** LOCAL FUNCTIONS  ******************

function insertMenus()
{
	var retVal = true;
	var menuDOM = dw.getDocumentDOM(FILE_menus);
	var menusChanged = false;

	if (!DWfile.exists(FILE_menuBackup))
	{
		DWfile.write(FILE_menuBackup, menuDOM.body.innerHTML); // backup menus.xml
	}
	
	if (DWfile.exists(FILE_Manage))
	{
		if (menuDOM.body.innerHTML.indexOf("DWMenu_Commands_ManageExtensions") == (-1))
		{
			menusChanged |= insertMenu(menuDOM,
										"DWMenu_Commands",
										EM_COMMANDS_MENU,
										"DWMenu_Commands_GetMoreCommands",
										EM_MANAGE);
		}

		if (menuDOM.body.innerHTML.indexOf("DWMenu_Help_ManageExtensions") == (-1))
		{
			if (menuDOM.body.innerHTML.indexOf("DWMenu_UD_Help_ResourceCenter") != (-1))
			{
				menusChanged |= insertMenu(menuDOM,
										"DWMenu_Help",
										EM_HELP_MENU,
										"DWMenu_UD_Help_ResourceCenter",
										EM_HELP_MANAGE);
			}
			else
			{
				menusChanged |= insertMenu(menuDOM,
										"DWMenu_Help",
										EM_HELP_MENU,
										"DWMenu_Help_ResourceCenter",
										EM_HELP_MANAGE);
			}
		}
	}

	if (DWfile.exists(FILE_Help))
	{
		if (menuDOM.body.innerHTML.indexOf("DWMenu_Help_Extensions") == (-1))
		{
			menusChanged |= insertMenu(menuDOM,
										"DWMenu_Help",
										EM_HELP_MENU,
										"DWMenu_Help_UDDWExtending_Mac",
										EM_HELP);
		}
	}
	
	if (menusChanged)
	{
		if (!DWfile.write(FILE_menus, menuDOM.body.innerHTML))
		{
			retVal = false;
			alert(MSG_menuFileUpdateFailed.replace(/%s/, MMNotes.localURLToFilePath(FILE_menus)));
		}
	}

	dw.releaseDocument(menuDOM);

	return retVal;
}

function insertMenu(menuDOM, menuId, menuData, insertAfterId, itemData)
{
	var retVal = false;
	
	do
	{
		var menuBarId = "DWMainWindow";
		var menuBarList = menuDOM.getElementsByTagName("MENUBAR");
		var menuBar = '';

		for (var i = 0; i < menuBarList.length; i++)
		{
			if (menuBarList[i].getAttribute("ID") == menuBarId)
			{
				menuBar = menuBarList[i];
				break;
			}
		}

		if (!menuBar)
			break;

		var menuList = menuBar.getElementsByTagName("MENU");
		var menu = '';
	
		for (i = 0; i < menuList.length; i++)
		{
			if (menuList[i].getAttribute("ID") == menuId)
			{
				menu = menuList[i];
				break;
			}
		}
		
		if (!menu)
		{
			menuBar.innerHTML = menuBar.innerHTML +
								NEWLINE +
								"	<menu " + 
								menuData +
								">" +
								NEWLINE +
								itemData +
								NEWLINE +
								"	</menu>" +
								NEWLINE;

			retVal = true;
			break;
		}
		
		var menuItemList = menu.getElementsByTagName("MENUITEM");
		var insertItem = '';

		for (i = 0; i < menuItemList.length; i++)
		{
			if (menuItemList[i].getAttribute("ID") == insertAfterId)
			{
				insertItem = menuItemList[i];
				break;
			}
		}

		if (!insertItem)
		{
			menuList = menu.getElementsByTagName("MENU");

			for (i = 0; i < menuList.length; i++)
			{
				if (menuList[i].getAttribute("ID") == insertAfterId)
				{
					insertItem = menuList[j];
					break;
				}
			}
		}
					
		if (insertItem)
		{
			insertItem.outerHTML = insertItem.outerHTML + itemData;
		}
		else
		{
			menu.innerHTML = menu.innerHTML + itemData;
		}

		retVal = true;
	}
	while (false);
		
	return retVal;
}

