//SHARE-IN-MEMORY=true
// Copyright 1998,1999,2000 Macromedia, Inc. All rights reserved.
//
// List Control Class
//
//  Include: common.js
//
// !!! IMPORTANT !!! THIS CONTROL ONLY WORKS WITHIN DREAMWEAVER !!!
// 
// This control manages a SELECT control, identified by number.
// 
// To define a new ListControl, create a global variable and define it after onLoad:
//   MYLIST = new ListControl(selectName);
// 
// The layerObj parameter is optional.  If specified, that layer will be searched
//  for the select list named selectName.
// 
// Thereafter, you can call methods and get properties, for example:
//   MYLIST.add("newItem");    MYLIST.get();   length = MYLIST.getLen;
//
// Limitations:
//   Does not manage multiple selections.
// 
// See properties and methods below:

function ListControl(selName, layerObj, loadFromHTML) {
  // properties
  this.selectName  = selName;
  this.object = (layerObj) ? findObject(selName, layerObj) : findObject(selName);
  this.list = new Array();
  this.valueList = new Array();
  this.index = -1;
  
  //  Load existing list names and values if they exist.
  if (loadFromHTML) this.init();
}

// public methods

ListControl.prototype.setAll    = ListControl_SetAll;   //  setAll(list,valueList)  // set the entire list at once
ListControl.prototype.add       = ListControl_Add;      //  add()  // add a new blank line after the selected line.
                                                        //  add('default')  // add text
                                                        //  add('default',value)  //  add text and an associated value
ListControl.prototype.append    = ListControl_Append;   //  append()   // append a new blank line to the end of the list
                                                        //  append('default')  // append default text
                                                        //  append('default',value)  //  append text and an associated value
ListControl.prototype.del       = ListControl_Del;      //  del()  // delete the selected line
ListControl.prototype.set       = ListControl_Set;      //  set('text')  // set the text of the current selection
                                                        //  set('text', n)  // set the text of the nth item
ListControl.prototype.init      = ListControl_Init;     //  init()  // set the entire list to the current HTML text and values
ListControl.prototype.setValue  = ListControl_SetValue; //  setValue(value)  // set the value of the current selection
                                                        //  setValue(value, n)  // set the value of the nth item
ListControl.prototype.get       = ListControl_Get;      //  get()  // return the current selection text
                                                        //  get(n)  // return text item n (starts at zero)
                                                        //  get('all')  // return array of all text items
ListControl.prototype.getValue  = ListControl_GetValue; //  getValue()  // return the current selection value
                                                        //  getValue(n)  // return value item n (starts at zero)
                                                        //  getValue('all')  // return array of all value items
                                                        //  getValue('multiple')  // return array of all selected value items
ListControl.prototype.setIndex  = ListControl_SetIndex; //  setIndex()  // set the selection to the given index
ListControl.prototype.pickValue = ListControl_PickValue;//  pickValue()  // set the selection to the item with the given value
ListControl.prototype.getIndex  = ListControl_GetIndex; //  getIndex()  // pulls out the selected index.
ListControl.prototype.getLen    = ListControl_GetLen;   //  getLen()  // returns the list length
ListControl.prototype.refresh   = ListControl_Refresh;  //  refresh()  // captures the current selection
ListControl.prototype.enable    = ListControl_Enable;   //  enable()  // enables control if not already enabled
ListControl.prototype.disable   = ListControl_Disable;  //  disable()  // disables control if not already disabled

// private methods

ListControl.prototype.updateContents = ListControl_UpdateContents;
ListControl.prototype.escHTMLChars = ListControl_EscHTMLChars;



// Adds a new, blank item after the currently selected item (or end of list).
// If there is no selection, it replaces the first item.

function ListControl_Add(newItemStr, newValueStr){
  var i, retVal = false;
  with (this) {
    if (!newItemStr) newItemStr = "";  // if no newItemStr, make it blank
    if (!newValueStr) newValueStr = "";
    index = object.selectedIndex;
    if (index >= 0 || list.length == 0) {  // if there is a selection or no list
      index++;
      list.splice(index, 0, newItemStr);
      valueList.splice(index, 0, newValueStr);
      updateContents();
      object.selectedIndex =  index;
      retVal = true;
  } }
  return retVal
}


// Append a new, blank item to the end of the list.
// If there is no selection, it replaces the first item.

function ListControl_Append(newItemStr, newValueStr){
  var i, retVal = false;
  with (this) {
    if (!newItemStr) newItemStr = "";  // if no newItemStr, make it blank
    if (!newValueStr) newValueStr = "";
    index = list.length;
    list[index] = newItemStr;
    valueList[index] = newValueStr;
    updateContents();
    object.selectedIndex = index;
    retVal = true;
  }
  return retVal;
}


// Deletes the currently selected item, and selects the one that followed it.

function ListControl_Del(optIndex) {
  var i, retVal = false;
  with (this) {
    index = object.selectedIndex; // get prior selection
    if (optIndex == null) optIndex = index;  // if they don't pass num, use selection
    if (optIndex >= 0 && optIndex < list.length) {  // if there is a selection
      list.splice(optIndex, 1);
      valueList.splice(optIndex, 1);
      updateContents();
      object.selectedIndex = (optIndex < index || index >= list.length)? --index : index; // if del last, move sel up one
      retVal = true;
  } }
  return retVal;
}


// Replaces the list selection with the given value.

function ListControl_Set(newItemStr, itemNum) {
  var retVal = false;
  with (this) {
    index = object.selectedIndex;
    if (itemNum == null) itemNum = index; // if not passed in, use selection
    if (itemNum >= 0 && itemNum < list.length) {  //  if selection in range
      if (list[itemNum] != newItemStr) {  // if text has been changed
        list[itemNum] = newItemStr;  // replace text
        object.options[itemNum].text = newItemStr;
      }
      retVal = true;
  } }
  return retVal;
}


// Replaces the value list selection with the given value.

function ListControl_SetValue(newValueStr, itemNum) {
  var retVal = false;
  with (this) {
    index = object.selectedIndex;
    if (itemNum == null) itemNum = index; // if not passed in, use selection
    if (itemNum >= 0 && itemNum < valueList.length) {  //  if selection in range
      if (valueList[itemNum] != newValueStr) {  // if text has been changed
        valueList[itemNum] = newValueStr;
        object.options[itemNum].value = newValueStr;
      }
      retVal = true;
  } }
  return retVal;
}


// Gets the currently selected item, or optionally the one at the given index

function ListControl_Get(optIndex) {
  var retVal = "";  // return blank if all else fails
  with (this) {
    index = object.selectedIndex; // get prior selection
    if (optIndex == null) optIndex = index;  // if they don't pass num, use selection
    if (optIndex == "all")  retVal = list;
    else if (optIndex > -1) retVal = list[optIndex];
  }
  return retVal;
}


// Gets the currently selected value, or optionally the one at the given index

function ListControl_GetValue(optIndex) {
  var retVal = "";  // return blank if all else fails
  with (this) {
    index = object.selectedIndex; // get prior selection
    if (optIndex == null) optIndex = index;  // if they don't pass num, use selection
    if (optIndex == "all")  retVal = valueList;
    else if (optIndex == "multiple")  {
      retVal = new Array();
      for (var i = 0; i < this.object.options.length; i++) {
        if (this.object.options[i].selected) retVal.push(this.object.options[i].value);
      }
    }
    else if (optIndex > -1) retVal = valueList[optIndex];
  }
  return retVal;
}


// Sets the list selection to the given index

function ListControl_SetIndex(theIndex) {
  var retVal = false;
  with (this) {
    if (theIndex >= 0 && theIndex < list.length) {  // if theIndex between 0 and length
      object.selectedIndex = theIndex;
      index = theIndex;
      retVal = true;
  } }
  return retVal
}


// Sets the list selection to the given index

function ListControl_PickValue(theValue) {
  var retVal = false;
  with (this) {
    for (var i=0; i < valueList.length; i++) {
      if (valueList[i] == theValue) {  //  TO DO: what if value is an object?
        object.selectedIndex = i;
        index = i;
        retVal = true;
        break;
  } } }
  return retVal
}


// Gets the list selection

function ListControl_GetIndex() {
  this.index = this.object.selectedIndex; // get prior selection
  return this.index;
}


// Returns the length of the current list

function ListControl_GetLen() {
  this.index = this.object.selectedIndex; // get prior selection
  return this.list.length
}


// Sets the list to the current values

function ListControl_Init() {
  var retVal = false;
  with (this) {
    index = object.selectedIndex; // set the index value
    
    list = new Array();
    valueList = new Array();
    for (i=0; i < object.options.length; i++) {
      list[i] = object.options[i].text;
      valueList[i] = (object.options[i].value) ? object.options[i].value : '';
    }
    retVal = true;
  }
  return retVal;
}


// Sets the entire list to the contents of newList, expanding the list
//  as necessary

function ListControl_SetAll(newList, newValueList) {
  var retVal = false;
  with (this) {
    index = object.selectedIndex; // get prior selection
    if (index < 0 || newList.length <= index) index = 0; // if outta range
    list = new Array();
    valueList = new Array();
    for (i=0; i < newList.length; i++) {
      list[i] = newList[i]; // dupe array
      valueList[i] = (newValueList && newValueList.length > i) ? newValueList[i] : '';
    }
    updateContents();
    object.selectedIndex = index;
    retVal = true;
  }
  return retVal;
}


function ListControl_Refresh() {
  this.index = this.object.selectedIndex; // get prior selection
}


function ListControl_UpdateContents() {
  var i, optionArr = new Array();
  for (i=0; i < this.list.length; i++) {
//???   optionArr.push("<option" + ((this.valueList[i]) ? ' value="' + this.escHTMLChars(this.valueList[i]) + '"' : '') + ">" + this.escHTMLChars(this.list[i]) + "</option>");
    optionArr.push("<option>" + this.escHTMLChars(this.list[i]) + "</option>");
  }
  this.object.innerHTML = optionArr.join("");
//??? this.object.innerHTML = '<option>' + this.list.join('</option><option>') + '</option>';  // Note does not escapeHTMLChars
}


function ListControl_EscHTMLChars(theStr) {
  theStr = String(theStr);
  theStr = theStr.replace(/\&/g,"&amp;");
  theStr = theStr.replace(/\</g,"&lt;");
  theStr = theStr.replace(/\>/g,"&gt;");
  return theStr;
}

function ListControl_Enable(){
  this.object.removeAttribute("disabled");
}

function ListControl_Disable(){
  this.object.setAttribute("disabled","true");
}

