//
// Copyright 1999 Macromedia, Inc. All rights reserved.
//
//formInsert.js

var PLATFORM = navigator.platform;
// Determine if the form object should be automatically wrapped in form.
function getFormAddPref () {
  var autoAdd, rtnValue = 'ASK';
  var path = dreamweaver.getConfigurationPath() + '/Objects/Forms/formInsert.js';
  var metaFile;
  metaFile = MMNotes.open(path, false);
  if (metaFile) {
    autoAdd = MMNotes.get(metaFile, 'PREF_autoAdd');
    if (autoAdd) rtnValue = autoAdd;
    MMNotes.close(metaFile);
  }
  return rtnValue;
}

function setFormAddPref (setValue) {
  var path = dreamweaver.getConfigurationPath() + '/Objects/Forms/formInsert.js';
  var metaFile;

  metaFile = MMNotes.open(path, true); // Force create the note file.
  if (metaFile) {
    if (setValue) autoAdd = MMNotes.set(metaFile, 'PREF_autoAdd', setValue);
    MMNotes.close(metaFile);
  }
}

// Copyright 1999 Macromedia, Inc. All rights reserved.

function userConfirmAdd() {
  var retVal = false;
  var cmdName = 'ConfirmDS.htm';
  var cmdFile = dreamweaver.getConfigurationPath() + '/Commands/' + cmdName;
  
  var cmdDOM = dreamweaver.getDocumentDOM(cmdFile);
  if (cmdDOM) {
    var cmdWin = cmdDOM.parentWindow;
    // Pass one arg for OK/Cancel, or extra args to define btns
		if (PLATFORM == "Win32")
      cmdWin.render(MSG_AutoFormAdd, BTN_Yes, BTN_No);
		else
		  cmdWin.render(MSG_AutoFormAdd, BTN_No, BTN_Yes);
    dreamweaver.popupCommand(cmdName);
    retVal = (MMNotes.Confirm_RESULT == BTN_Yes); // Reference to confirm global result.
    if (MMNotes.Confirm_DONOTSHOW) {
      if (retVal) setFormAddPref('ADDFORM');
      else setFormAddPref('NOFORM');
    } else {
      // setFormAddPref('ASK'); // Default value.
    }
  }
  return retVal;
}

function stripWhite(inStr) {
  if (!inStr) return inStr;
  var i, j; // Start and ending characters.
  var whiteChar = ' \t\r\n\v\f';
  for (i = 0; i < inStr.length ; i++) 
    {if (whiteChar.indexOf(inStr.charAt(i))== -1) break;}
  for (j = inStr.length; j > 0; j--) 
    {if (whiteChar.indexOf(inStr.charAt(j-1))== -1) break;}
  return inStr.substring(i, j);
}

function returnFormTag(rtnStr) {
  rtnStr = stripWhite(rtnStr);

  // Set variable for use only if input type is file
  var encType = (rtnStr.indexOf('type="file"') != -1)?' enctype="multipart/form-data"':'';

  // If wrap form field preference is set.
  if (!selectionInsideTag('form') && dw.getFocus() != 'textView' && dw.getFocus() != 'html') {
    switch (getFormAddPref()) {
    case 'ADDFORM':
      // Check if there is a form around the current selection and wrap the returned tag.
      rtnStr = '<form name="'+ makeUniqueName('form','form') + '"' + encType +' method="post" action="">' + rtnStr + '\</form>';
      break;

    case 'NOFORM':
      // No form requested, do nothing.
      break;
      
    case 'ASK':
    default:
      // Ask for confirmation before adding.
      if (userConfirmAdd()) {
          rtnStr = '<form name="'+ makeUniqueName('form','form') + '"' + encType +' method="post" action="">' + rtnStr + '\</form>';
      }
      break;
	}
  }
  
  // Return the text field.
  return rtnStr;
}
