// Copyright 1999 Macromedia, Inc. All rights reserved.

//---------------   GLOBAL VARIABLES   ---------------

var gPropList;
var helpDoc = MM.HELP_objGenerator;

//---------------     API FUNCTIONS    ---------------

function isDOMRequired() {
	// Return false, indicating that this object is available in code view.
	return false;
}



//---------------    LOCAL FUNCTIONS   ---------------


// Function: stripWhite
// Description: Removes whitespace at beginning and end of the string.
function stripWhite(theStr) {
  if (!theStr) theStr = '';  //ensure its not null
  theStr = theStr.replace(/^\s*/,''); //strip leading
  theStr = theStr.replace(/\s*$/,''); //strip trailing
  return theStr;
}

// Function: initializeUI
// Description: initialize UI and other associated preferences
function initializeUI() {
  // Create controlling list class.
  gPropList = new ListControl('Parameters');
  document.MainForm.TemplateFile.focus();
  document.MainForm.TemplateFile.select();
}

// Function: cleanup
// Description:
function cleanup() {
  // Exit
  window.close();
}


function genParams() {
  // Return generator parameters in URL format.
  var rtnStr = '';
  if (gPropList) {
    rtnStr = gPropList.get('all').join('&');
  }
  return rtnStr;
}


// Function: objectTag
// Description: Return inserted value for an Object
function objectTag() {
  // Return the html tag that should be inserted

  var rtnStr = '';
  var GeneratorType = document.MainForm.Format.options[document.MainForm.Format.selectedIndex].value;
  var ObjectName = dw.doURLEncoding(document.MainForm.TemplateFile.value) ; // URL Encode Template filename
  var Params = genParams();
  var SrcSpec = ObjectName + '?' + ((Params) ? Params + '&': '') + 'type=' + GeneratorType;
  var SwfSpec = (Params) ? ('?' + Params) : '';


  switch (GeneratorType) {
    case 'gif':
      rtnStr = '<IMG SRC="' + SrcSpec + '" BORDER=0>';
      break;

    case 'jpg':
      rtnStr = '<IMG SRC="' + SrcSpec + '" BORDER=0>';
      break;

    case 'png':
      rtnStr = '<IMG SRC="' + SrcSpec + '" BORDER=0>';
      break;

    case 'mov':
      rtnStr = '<EMBED SRC="' + SrcSpec + '" BORDER="0" PLUGINSPAGE="http://www.apple.com/quicktime/download/"><\/EMBED>';
      break;

    case 'swf':
    default:
      rtnStr = '<OBJECT CLASSID="clsid:D27CDB6E-AE6D-11cf-96B8-444553540000"' +
        ' CODEBASE="http://download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=4,0,2,0"' +
        ' WIDTH="32" HEIGHT="32">\n' +
        '<PARAM NAME=movie VALUE="' + ObjectName + SwfSpec + '"> <PARAM NAME=quality VALUE=high>\n' +
        '<EMBED SRC="' + ObjectName + SwfSpec +
        '" quality=high PLUGINSPAGE="http://www.macromedia.com/shockwave/download/index.cgi?P1_Prod_Version=ShockwaveFlash" ' +
        'TYPE="application/x-shockwave-flash" WIDTH="32" HEIGHT="32">'+
        '<\/EMBED>\n' +
        '<\/OBJECT>';
      break;
  }
  return rtnStr;
}

//------ Interface Support Functions

// Browse for generator template URL, and set form field.
function browseFileAndSet(){
  var fileName;
  fileName = browseForFileURL('select', DLG_PROMPT, false);
  // If selection canceled, empty string returned
  if (fileName) { // Do not erase current field value.
    document.MainForm.TemplateFile.value = fileName;
  }
}

function setParams() {
  if (gPropList.getIndex() == -1) {  // If no selection (or no items)
    if (document.MainForm.ParamName.value + document.MainForm.ParamValue.value)
      gPropList.append(stripWhite(document.MainForm.ParamName.value)
      + '=' + document.MainForm.ParamValue.value);
  } else {
    gPropList.set(stripWhite(document.MainForm.ParamName.value)
    + '=' + document.MainForm.ParamValue.value);
} }

function putParams() {
  var pvArr;
  var tempStr;

  tempStr = gPropList.get();
  pvArr = tempStr.split('=');
  if (pvArr[0])
    document.MainForm.ParamName.value = pvArr[0];
  else
    document.MainForm.ParamName.value = '';

  if (pvArr[1])
    document.MainForm.ParamValue.value = pvArr[1];
  else
    document.MainForm.ParamValue.value = '';
}

function addParam() {
  if (gPropList.getIndex() == -1) {
    gPropList.append('name=value');
  } else {
    gPropList.add('name=value');
  }
  putParams();
  document.MainForm.ParamName.focus();
  document.MainForm.ParamName.select();
}

function delParam() {
  gPropList.del();
  putParams();
}

