// Copyright 1999 Macromedia, Inc. All rights reserved.

   var idPrefix = "DWMenu_Modify_EditableRegion_";
   var noneID = "DWMenu_Modify_EditableRegion_none";

   function indexFromID(itemID)
   {
      // Get the part of the ID which represents the index.
     var prefixLen = idPrefix.length;
	   var number = itemID.substring(prefixLen, itemID.length);

     return number;
   }

   function receiveArguments()
   {
     var index = indexFromID(arguments[0]);
     if (dw.getDocumentDOM() != null){
       var regionList = dw.getDocumentDOM().getEditableRegionList();
       var node = regionList[index];

       dw.getDocumentDOM().setSelectedNode(node, true, true);
     }
   }

   function canAcceptCommand()
   {
      return (dw.getDocumentDOM() != null && !site.windowIsFrontmost() && arguments[0] != noneID);
   }

   function isCommandChecked()
   {
      // See if the index matches the selected editable region.
	  return (dw.getDocumentDOM() != null && indexFromID(arguments[0]) == dw.getDocumentDOM().getSelectedEditableRegion())
   }

   // getDynamicContent returns the contents of a dynamically generated menu.
   // returns an array of strings to be placed in the menu, with a unique
   // identifier for each item separated from the menu string by a semicolon.
   //
   // return null from this routine to indicate that you are not adding any
   // items to the menu
   function getDynamicContent(itemID)
   {
     var regionList = null;
     if (dw.getDocumentDOM() != null){
       regionList = dw.getDocumentDOM().getEditableRegionList();
       if (regionList && regionList.length > 0)
       {
         var i;
         for (i=0; i<regionList.length; i++)
         {
           regionList[i] = unescape(regionList[i].name) + ";id='" + escQuotes(idPrefix + i) + "'";
         }
       }
       else
       {
         regionList[0] = MENU_NoEditableRegions + ";id='" + noneID +"'";
       }
     }
     return regionList;
   }
