// Copyright 1999 Macromedia, Inc. All rights reserved.

var idOpen="DWContext_Text_OpenAttachedTemplate";
var idNew="DWContext_Text_NewEditableRegion";
var idRemove="DWContext_Text_RemoveEditableRegion";

function receiveArguments()
{
  if ( arguments[0] == idOpen ) {
    dw.openDocument(dw.getSiteRoot().substring(0,dw.getSiteRoot().length-1) + dw.getDocumentDOM().getAttachedTemplate());
  }
  else if ( arguments[0] == idNew ) {
    if ( !dw.getDocumentDOM().canMarkSelectionAsEditable() )
      dw.getDocumentDOM().newEditableRegion();
    else
      dw.getDocumentDOM().markSelectionAsEditable();
  }
  else if ( arguments[0] == idRemove ) {
    // need to add a new parameter to removeEditableRegion 
    // and then we can do this right....
    //dw.getDocumentDOM().removeEditableRegion(dw.getDocumentDOM().getSelectedEditableRegion());
    dw.getDocumentDOM().removeEditableRegion();
  }
}

function canAcceptCommand()
{
  if ( dw.getFocus() != 'document' )
    return false;

  if ( arguments[0] == idOpen ) {
    if (dw.getDocumentDOM().getAttachedTemplate())
      return true;
    else
      return false;
  }
  else if ( arguments[0] == idNew )
     return (dw.getDocumentDOM().canMakeNewEditableRegion());
  else if ( arguments[0] == idRemove )
     return (dw.getDocumentDOM().canRemoveEditableRegion());
  else
    return false; // should not happen!!!
}

function isCommandChecked()
{
  return false;
}

// getDynamicContent returns the contents of a dynamically generated menu.
// returns an array of strings to be placed in the menu, with a unique
// identifier for each item separated from the menu string by a semicolon.
//
// return null from this routine to indicate that you are not adding any
// items to the menu
function getDynamicContent(itemID)
{
  var itemList = null;
  if (dw.getDocumentDOM() != null)
  {
    itemList = new Array();
    if ( dw.getDocumentDOM().getIsTemplateDocument() ) {
      itemList[0] = new String(MENU_NewEditableRegion + ";id='"+idNew+"'");
      itemList[1] = new String(MENU_RemoveEditableRegion + ";id='"+idRemove+"'");
    }
    else {
      itemList[0] = new String(MENU_OpenAttachedTemplate + ";id='"+idOpen+"'");
    }
  }
  return itemList;
}
