//Copyright 2000 Macromedia, Inc. All rights reserved.


////////////////////////////////////////////////////////////////////////////////
//
//	Function: docBase
//
//	Returns the base path for the current document.
//
////////////////////////////////////////////////////////////////////////////////
function docBase()
{
	var docURL;
	var docBase;
	var	index	= 0;

	docURL = dreamweaver.getDocumentPath("DOCUMENT");
	if ( "" == docURL )
		return "";

	index = docURL.lastIndexOf('/');
	if ( -1 == index )
		return "";
	
	return docURL.substring(0, index);
} // function docBase()

////////////////////////////////////////////////////////////////////////////////
//
//	Function: findObject
//
//	Returns the named object.
//
////////////////////////////////////////////////////////////////////////////////
function findObject(objName,  parentObj)  
{
	var	curObj	= "";
	var	found	= false;
	var	i		= 0;
	var NS		= (navigator.appName.indexOf("Netscape") != -1);
	var tempObj	= ""
	

	if (!NS && document.all) 
		curObj = document.all[objName]; //IE4
	else 
	{
	    parentObj = (parentObj != null)? parentObj.document : document;

		if (parentObj[objName] != null) 
			curObj = parentObj[objName]; //at top level
		else 
		{ 
    		if (parentObj.forms) for (i=0; i<parentObj.forms.length; i++)
			{  
				//search level for form object
				if (parentObj.forms[i][objName]) 
				{
					curObj = parentObj.forms[i][objName];
					found = true; break;
				} 
			} // if (parentObj.forms) for (i=0; i<parentObj.forms.length; i++)

			if (!found && NS && parentObj.layers && parentObj.layers.length > 0) 
			{
				parentObj = parentObj.layers;
				for (i=0; i<parentObj.length; i++) 
				{ //else search for child layers
					tempObj = findObject(objName,parentObj[i]); //recurse
					if (tempObj) 
					{ 
						curObj = tempObj; break;
					} //if found, done
				} 
			} // if (!found && NS && parentObj.layers && parentObj.layers.length > 0)
		} // if (parentObj[objName] != null)  else 
	} // if (!NS && document.all) else
  
	return curObj;
} // function findObject(objName,  parentObj)


////////////////////////////////////////////////////////////////////////////////
//
//	Function: showHideTranslated
//
//	Returns the selected object.  Note:  This function does not take into
//	account noncontiguous selections, or selections inside a table where there
//	are more than two indices.
//
////////////////////////////////////////////////////////////////////////////////
function getSelectedObj() 
{
  var	selArr	= dreamweaver.getSelection();
  return dreamweaver.offsetsToNode(selArr[0],selArr[1]);
} // function getSelectedObj()

////////////////////////////////////////////////////////////////////////////////
//
//	Function: showHideTranslated
//
//	Shows or hides the translated attribute button layer of a PI according to
//	whether or not the object being inspected has translated attributes.
//
//  In UltraDev, the tool often generates translated attributes without the 
//  user being aware of that fact.  As a result, showing the lightening bolt
//  was causing confusion.  To fix the problem, we always hide the lightening
//  bolt for UltraDev.
//
////////////////////////////////////////////////////////////////////////////////
function showHideTranslated()
{
	var theObj = getSelectedObj();
	if (!theObj.tagName)
		return;
	
	if ( theObj.hasTranslatedAttributes() && dw.appName != "Dreamweaver UltraDev")
	{	
		document.layers['tButtonSpan'].visibility = 'visible';
		// Show the layer
	}
	else
	{
		document.layers['tButtonSpan'].visibility = 'hidden';
		// Hide the layer
	}

} // function showHideTranslated( theObj, theLayer )

////////////////////////////////////////////////////////////////////////////////
//
//	Function: launchQuickTagEditor
//
//	Displays the quick tag editor.  If being called because the translated
//	attributes icon was clicked, then the caller should set forTranslationIcon
//	to true.
//
////////////////////////////////////////////////////////////////////////////////
function launchQuickTagEditor( forTranslationIcon )
{
    // Currently, forTranslationIcon is ignored.
	dw.showQuickTagEditor("near mouse");
} // function launchQuickTagEditor( forTranslationIcon )
