/*
 * Decompiled with CFR 0.152.
 */
package com.macromedia.generator.app;

import com.macromedia.generator.utils.GenUtils;
import java.io.File;

class GenLogFile {
    private File mParent = null;
    private String mName = null;
    private String mExtension = null;
    private int mIndex = 0;

    public GenLogFile(File file) {
        if (file == null) {
            return;
        }
        this.mParent = GenUtils.getParentFile(file);
        if (this.mParent == null) {
            return;
        }
        String string = file.getName();
        int n = string.lastIndexOf(".");
        if (n == -1) {
            return;
        }
        this.mName = string.substring(0, n);
        this.mExtension = string.substring(n, string.length());
        n = this.mName.lastIndexOf("_");
        if (n == -1) {
            return;
        }
        String string2 = this.mName.substring(n + 1, this.mName.length());
        this.mName = this.mName.substring(0, n);
        try {
            this.mIndex = Integer.valueOf(string2);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public File getParentFile() {
        return this.mParent;
    }

    public String getParent() {
        if (this.mParent == null) {
            return null;
        }
        String string = this.mParent.getPath();
        if (string == null) {
            return null;
        }
        if (!string.endsWith("/")) {
            string = string + "/";
        }
        return string;
    }

    public String getName() {
        return this.mName;
    }

    public String getExtension() {
        return this.mExtension;
    }

    public int getIndex() {
        return this.mIndex;
    }

    public void setIndex(int n) {
        this.mIndex = n;
    }

    public boolean verify() {
        return this.mParent != null && this.mName != null && this.mExtension != null;
    }

    public File getFile() {
        String string;
        if (!this.verify()) {
            return null;
        }
        int n = this.getIndex();
        String string2 = "";
        if (n != 0) {
            string2 = "_" + this.getIndex();
        }
        if ((string = this.getParent() + this.getName() + string2 + this.getExtension()) == null) {
            return null;
        }
        File file = new File(string);
        return file;
    }

    public File increment() {
        this.setIndex(this.getIndex() + 1);
        return this.getFile();
    }
}

