/*
 * Decompiled with CFR 0.152.
 */
package com.macromedia.generator.api;

import com.macromedia.generator.api.Color;
import com.macromedia.generator.api.Font;
import com.macromedia.generator.api.GenObject;
import com.macromedia.generator.api.GeneratorApiException;
import com.macromedia.generator.api.Rect;
import com.macromedia.generator.api.peer.TextPeer;

public class Text
extends GenObject {
    public Text() throws GeneratorApiException {
        this.peer = TextPeer.New();
        if (this.peer == 0) {
            throw new GeneratorApiException("unable to create peer");
        }
    }

    protected Text(int n) throws GeneratorApiException {
        this.peer = n;
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
    }

    protected void finalize() throws Throwable {
        if (this.peer != 0) {
            TextPeer.Release(this.peer);
        }
        this.peer = 0;
    }

    public void release() {
        if (this.peer != 0) {
            TextPeer.Release(this.peer);
        }
        this.peer = 0;
    }

    public void setFont(Font font) throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n = TextPeer.SetFont(this.peer, font.peer);
        if (n == 0) {
            throw new GeneratorApiException("error setting font");
        }
    }

    public void setSize(int n) throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n2 = TextPeer.SetSize(this.peer, n);
        if (n2 == 0) {
            throw new GeneratorApiException("error setting text size");
        }
    }

    public void setSpacing(int n) throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n2 = TextPeer.SetSpacing(this.peer, n);
        if (n2 == 0) {
            throw new GeneratorApiException("error setting text spacing");
        }
    }

    public void setPosition(int n) throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n2 = TextPeer.SetPosition(this.peer, n);
        if (n2 == 0) {
            throw new GeneratorApiException("error setting text position");
        }
    }

    public void setRgb(int n) throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n2 = TextPeer.SetRgb(this.peer, n);
        if (n2 == 0) {
            throw new GeneratorApiException("error setting rgb color");
        }
    }

    public void setColor(Color color) throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n = TextPeer.SetColor(this.peer, color.peer);
        if (n == 0) {
            throw new GeneratorApiException("error setting color");
        }
    }

    public void setLineWidth(int n) throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n2 = TextPeer.SetLineWidth(this.peer, n);
        if (n2 == 0) {
            throw new GeneratorApiException("error setting line width");
        }
    }

    public void setAlignment(int n) throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n2 = TextPeer.SetAlignment(this.peer, n);
        if (n2 == 0) {
            throw new GeneratorApiException("error setting text alignment");
        }
    }

    public void setIndent(int n) throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n2 = TextPeer.SetIndent(this.peer, n);
        if (n2 == 0) {
            throw new GeneratorApiException("error setting text indent");
        }
    }

    public void setLeftMargin(int n) throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n2 = TextPeer.SetLeftMargin(this.peer, n);
        if (n2 == 0) {
            throw new GeneratorApiException("error setting text left margin");
        }
    }

    public void setRightMargin(int n) throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n2 = TextPeer.SetRightMargin(this.peer, n);
        if (n2 == 0) {
            throw new GeneratorApiException("error setting text right margin");
        }
    }

    public void setLeading(int n) throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n2 = TextPeer.SetLeading(this.peer, n);
        if (n2 == 0) {
            throw new GeneratorApiException("error setting text leading");
        }
    }

    public void setString(String string) throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        if (string == null) {
            throw new GeneratorApiException("null string");
        }
        int n = TextPeer.SetString(this.peer, string);
        if (n == 0) {
            throw new GeneratorApiException("error setting text string");
        }
    }

    public Rect getBounds() throws GeneratorApiException {
        int[] nArray = new int[]{0};
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n = TextPeer.GetBounds(this.peer, nArray);
        if (n == 0) {
            throw new GeneratorApiException("error getting bounds");
        }
        return new Rect(nArray[0]);
    }

    public void setCenter(int n, int n2) throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n3 = TextPeer.SetCenter(this.peer, n, n2);
        if (n3 == 0) {
            throw new GeneratorApiException("error setting center");
        }
    }
}

