/*
 * Decompiled with CFR 0.152.
 */
package com.macromedia.generator.api;

import com.macromedia.generator.api.Buffer;
import com.macromedia.generator.api.GenObject;
import com.macromedia.generator.api.GeneratorApiException;
import com.macromedia.generator.api.Serial;
import com.macromedia.generator.api.peer.PngBuilderPeer;

public class PngBuilder
extends GenObject {
    public PngBuilder() throws GeneratorApiException {
        this.peer = PngBuilderPeer.New();
        if (this.peer == 0) {
            throw new GeneratorApiException("unable to create peer");
        }
    }

    protected PngBuilder(int n) throws GeneratorApiException {
        this.peer = n;
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
    }

    protected void finalize() throws Throwable {
        if (this.peer != 0) {
            PngBuilderPeer.Release(this.peer);
        }
        this.peer = 0;
    }

    public void release() {
        if (this.peer != 0) {
            PngBuilderPeer.Release(this.peer);
        }
        this.peer = 0;
    }

    public void setSerial(Serial serial) throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n = serial != null ? serial.peer : 0;
        PngBuilderPeer.SetSerial(this.peer, n);
    }

    public void setType(int n) throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n2 = PngBuilderPeer.SetType(this.peer, n);
        if (n2 == 0) {
            throw new GeneratorApiException("error setting PNG type");
        }
    }

    public void setOption(int n) throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n2 = PngBuilderPeer.SetOption(this.peer, n);
        if (n2 == 0) {
            throw new GeneratorApiException("error setting PNG option");
        }
    }

    public void setInterlace(boolean bl) throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n = PngBuilderPeer.SetInterlace(this.peer, bl);
        if (n == 0) {
            throw new GeneratorApiException("error setting PNG interlace");
        }
    }

    public void setSmooth(boolean bl) throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n = PngBuilderPeer.SetSmooth(this.peer, bl);
        if (n == 0) {
            throw new GeneratorApiException("error setting PNG smooth");
        }
    }

    public void setDither(boolean bl) throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n = PngBuilderPeer.SetDither(this.peer, bl);
        if (n == 0) {
            throw new GeneratorApiException("error setting PNG dither");
        }
    }

    public void setDitherType(int n) throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n2 = PngBuilderPeer.SetDitherType(this.peer, n);
        if (n2 == 0) {
            throw new GeneratorApiException("error setting dither type flag");
        }
    }

    public void setDimensions(int n, int n2) throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n3 = PngBuilderPeer.SetDimensions(this.peer, n, n2);
        if (n3 == 0) {
            throw new GeneratorApiException("error setting dimensions for png");
        }
    }

    public void build(Buffer buffer, Buffer buffer2) throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        if (buffer.peer == 0 || buffer2.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n = PngBuilderPeer.Build(this.peer, buffer.peer, buffer2.peer);
        if (n == 0) {
            throw new GeneratorApiException("error building the PNG buffer");
        }
    }

    public void setColorOptimization(boolean bl) throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n = PngBuilderPeer.SetColorOptimization(this.peer, bl);
        if (n == 0) {
            throw new GeneratorApiException("error setting color optimization flag");
        }
    }

    public void setPaletteType(int n) throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n2 = PngBuilderPeer.SetPaletteType(this.peer, n);
        if (n2 == 0) {
            throw new GeneratorApiException("error setting palette type");
        }
    }

    public void setMaxColors(int n) throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n2 = PngBuilderPeer.SetMaxColors(this.peer, n);
        if (n2 == 0) {
            throw new GeneratorApiException("error setting max number of colors");
        }
    }

    public void setFilePalette(String string) throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n = PngBuilderPeer.SetFilePalette(this.peer, string);
        if (n == 0) {
            throw new GeneratorApiException("error setting the custom palette");
        }
    }

    public void setGradient(boolean bl) throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n = PngBuilderPeer.SetGradient(this.peer, bl);
        if (n == 0) {
            throw new GeneratorApiException("error setting gradient flag");
        }
    }

    public void setExactFit(boolean bl) throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n = PngBuilderPeer.SetExactFit(this.peer, bl);
        if (n == 0) {
            throw new GeneratorApiException("error setting exact fit flag");
        }
    }

    public void setBackgroundColor(String string) throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n = PngBuilderPeer.SetBackgroundColor(this.peer, string);
        if (n == 0) {
            throw new GeneratorApiException("error setting background color");
        }
    }
}

