/*
 * Decompiled with CFR 0.152.
 */
package com.macromedia.generator.api;

import com.macromedia.generator.api.Color;
import com.macromedia.generator.api.GenObject;
import com.macromedia.generator.api.GeneratorApiException;
import com.macromedia.generator.api.peer.MatrixPeer;

public class Matrix
extends GenObject {
    public Matrix() throws GeneratorApiException {
        this.peer = MatrixPeer.New();
        if (this.peer == 0) {
            throw new GeneratorApiException("unable to create peer");
        }
    }

    protected Matrix(int n) throws GeneratorApiException {
        this.peer = n;
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
    }

    protected void finalize() throws Throwable {
        if (this.peer != 0) {
            MatrixPeer.Release(this.peer);
        }
        this.peer = 0;
    }

    public void release() {
        if (this.peer != 0) {
            MatrixPeer.Release(this.peer);
        }
        this.peer = 0;
    }

    public void setAngle(float f) throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n = MatrixPeer.SetAngle(this.peer, f);
        if (n == 0) {
            throw new GeneratorApiException("error setting angle");
        }
    }

    public float getAngle() throws GeneratorApiException {
        float[] fArray = new float[]{0.0f};
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n = MatrixPeer.GetAngle(this.peer, fArray);
        if (n == 0) {
            throw new GeneratorApiException("error getting angle");
        }
        return fArray[0];
    }

    public void setXScale(float f) throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n = MatrixPeer.SetXScale(this.peer, f);
        if (n == 0) {
            throw new GeneratorApiException("error setting x scale");
        }
    }

    public float getXScale() throws GeneratorApiException {
        float[] fArray = new float[]{0.0f};
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n = MatrixPeer.GetXScale(this.peer, fArray);
        if (n == 0) {
            throw new GeneratorApiException("error getting x scale");
        }
        return fArray[0];
    }

    public void setYScale(float f) throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n = MatrixPeer.SetYScale(this.peer, f);
        if (n == 0) {
            throw new GeneratorApiException("error setting y scale");
        }
    }

    public float getYScale() throws GeneratorApiException {
        float[] fArray = new float[]{0.0f};
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n = MatrixPeer.GetYScale(this.peer, fArray);
        if (n == 0) {
            throw new GeneratorApiException("error getting y scale");
        }
        return fArray[0];
    }

    public void setXOffset(int n) throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n2 = MatrixPeer.SetXOffset(this.peer, n);
        if (n2 == 0) {
            throw new GeneratorApiException("error setting x offset");
        }
    }

    public int getXOffset() throws GeneratorApiException {
        int[] nArray = new int[]{0};
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n = MatrixPeer.GetXOffset(this.peer, nArray);
        if (n == 0) {
            throw new GeneratorApiException("error getting x offset");
        }
        return nArray[0];
    }

    public void setYOffset(int n) throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n2 = MatrixPeer.SetYOffset(this.peer, n);
        if (n2 == 0) {
            throw new GeneratorApiException("error setting y offset");
        }
    }

    public int getYOffset() throws GeneratorApiException {
        int[] nArray = new int[]{0};
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n = MatrixPeer.GetYOffset(this.peer, nArray);
        if (n == 0) {
            throw new GeneratorApiException("error getting y offset");
        }
        return nArray[0];
    }

    public void setRedScale(float f) throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n = MatrixPeer.SetRedScale(this.peer, f);
        if (n == 0) {
            throw new GeneratorApiException("error setting red scale");
        }
    }

    public float getRedScale() throws GeneratorApiException {
        float[] fArray = new float[]{0.0f};
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n = MatrixPeer.GetRedScale(this.peer, fArray);
        if (n == 0) {
            throw new GeneratorApiException("error getting red scale");
        }
        return fArray[0];
    }

    public void setGreenScale(float f) throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n = MatrixPeer.SetGreenScale(this.peer, f);
        if (n == 0) {
            throw new GeneratorApiException("error setting green scale");
        }
    }

    public float getGreenScale() throws GeneratorApiException {
        float[] fArray = new float[]{0.0f};
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n = MatrixPeer.GetGreenScale(this.peer, fArray);
        if (n == 0) {
            throw new GeneratorApiException("error getting green scale");
        }
        return fArray[0];
    }

    public void setBlueScale(float f) throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n = MatrixPeer.SetBlueScale(this.peer, f);
        if (n == 0) {
            throw new GeneratorApiException("error setting blue scale");
        }
    }

    public float getBlueScale() throws GeneratorApiException {
        float[] fArray = new float[]{0.0f};
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n = MatrixPeer.GetBlueScale(this.peer, fArray);
        if (n == 0) {
            throw new GeneratorApiException("error getting blue scale");
        }
        return fArray[0];
    }

    public void setRedOffset(int n) throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n2 = MatrixPeer.SetRedOffset(this.peer, n);
        if (n2 == 0) {
            throw new GeneratorApiException("error setting red offset");
        }
    }

    public int getRedOffset() throws GeneratorApiException {
        int[] nArray = new int[]{0};
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n = MatrixPeer.GetRedOffset(this.peer, nArray);
        if (n == 0) {
            throw new GeneratorApiException("error getting red offset");
        }
        return nArray[0];
    }

    public void setGreenOffset(int n) throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n2 = MatrixPeer.SetGreenOffset(this.peer, n);
        if (n2 == 0) {
            throw new GeneratorApiException("error setting green offset");
        }
    }

    public int getGreenOffset() throws GeneratorApiException {
        int[] nArray = new int[]{0};
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n = MatrixPeer.GetGreenOffset(this.peer, nArray);
        if (n == 0) {
            throw new GeneratorApiException("error getting green offset");
        }
        return nArray[0];
    }

    public void setBlueOffset(int n) throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n2 = MatrixPeer.SetBlueOffset(this.peer, n);
        if (n2 == 0) {
            throw new GeneratorApiException("error setting blue offset");
        }
    }

    public int getBlueOffset() throws GeneratorApiException {
        int[] nArray = new int[]{0};
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n = MatrixPeer.GetBlueOffset(this.peer, nArray);
        if (n == 0) {
            throw new GeneratorApiException("error getting blue offset");
        }
        return nArray[0];
    }

    public void setBrightness(float f) throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n = MatrixPeer.SetBrightness(this.peer, f);
        if (n == 0) {
            throw new GeneratorApiException("error setting brightness");
        }
    }

    public void setRgbTint(int n, float f) throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n2 = MatrixPeer.SetRgbTint(this.peer, n, f);
        if (n2 == 0) {
            throw new GeneratorApiException("error setting rgb tint");
        }
    }

    public void setColorTint(Color color, float f) throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n = MatrixPeer.SetColorTint(this.peer, color.peer, f);
        if (n == 0) {
            throw new GeneratorApiException("error setting color tint");
        }
    }
}

