#ifndef DW_decls_h___
#define DW_decls_h___

// DREAMWEAVER

// snewman 3/22/01: This file contains declarations which must be
// visible from every .c file in the JavaScript interpreter, but not
// visible from Dreamweaver code that #includes JS header files.
// 
// In the old JS 1.2 days, we put these declarations in one of the
// existing JS header files, and did some #ifdef magic to prevent
// them from being active for Dreamweaver code.  When moving to JS1.5rc3,
// I found it easier to just use a separate file and insert a #include
// of that file into every JS implementation file.

#ifndef _INC_STDLIB
	#include <stdlib.h>
#endif // _INC_STDLIB

#ifndef _UTILITY_MEMORYSWITCHES_H
	#include "utility/MemorySwitches.h"
#endif // _UTILITY_MEMORYSWITCHES_H

#ifdef OVERRIDE_JS_ALLOCATOR
	// snewman 3/28/01: turning this off because it clutters up the build messages
	// #pragma message( " Overriding js allocator " __FILE__ )
	extern void *glue_malloc(size_t nbytes);
	extern void *glue_realloc(void *p, size_t nbytes);
	extern void glue_free(void *p);

	#define malloc glue_malloc
	#define realloc glue_realloc
	#define free glue_free
#else
	#pragma message( " NOT overriding js allocator " __FILE__ )
#endif // OVERRIDE_JS_ALLOCATOR

#endif /* DW_decls_h___ */
