/*
 * Decompiled with CFR 0.152.
 */
package com.techtrader.modules.tools.bytecode;

import com.techtrader.modules.tools.bytecode.Code;
import com.techtrader.modules.tools.bytecode.Instruction;
import com.techtrader.modules.tools.bytecode.TypedLocalVariableInstruction;
import com.techtrader.modules.tools.bytecode.visitor.BCVisitor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class LoadInstruction
extends TypedLocalVariableInstruction {
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof LoadInstruction)) {
            return false;
        }
        return super.equals(object);
    }

    public int getLength() {
        switch (this._opcode) {
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                return super.getLength() + 1;
            }
        }
        return super.getLength();
    }

    public int getStackChange() {
        if (this._type.equals(Long.TYPE) || this._type.equals(Double.TYPE)) {
            return 2;
        }
        return 1;
    }

    protected void readData(DataInput dataInput) throws IOException {
        switch (this._opcode) {
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                this._index = dataInput.readUnsignedByte();
            }
        }
    }

    protected void writeData(DataOutput dataOutput) throws IOException {
        switch (this._opcode) {
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                dataOutput.writeByte(this._index);
            }
        }
    }

    protected void calculateOpCode() {
        int n = Instruction._opcodeTypes.indexOf(this._type);
        this._opcode = this._index < 4 ? 26 + 4 * n + this._index : 21 + n;
    }

    public void acceptVisit(BCVisitor bCVisitor) {
        bCVisitor.enterLoadInstruction(this);
        bCVisitor.exitLoadInstruction(this);
    }

    protected LoadInstruction(Code code) {
        super(code);
    }

    protected LoadInstruction(Code code, int n, Class clazz, int n2) {
        super(code);
        this._opcode = n;
        this._type = clazz;
        this._index = n2;
    }
}

