/* 
 * The contents of this file are subject to the Mozilla Public
 * License Version 1.1 (the "License"); you may not use this file
 * except in compliance with the License. You may obtain a copy of
 * the License at http://www.mozilla.org/MPL/
 * 
 * Software distributed under the License is distributed on an "AS
 * IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * rights and limitations under the License.
 * 
 * The Original Code is the Sablotron XSLT Processor.
 * 
 * The Initial Developer of the Original Code is Ginger Alliance Ltd.
 * Portions created by Ginger Alliance are Copyright (C) 2000 Ginger
 * Alliance Ltd. All Rights Reserved.
 * 
 * Contributor(s):
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL"), in which case the provisions of the GPL are applicable 
 * instead of those above.  If you wish to allow use of your 
 * version of this file only under the terms of the GPL and not to
 * allow others to use your version of this file under the MPL,
 * indicate your decision by deleting the provisions above and
 * replace them with the notice and other provisions required by
 * the GPL.  If you do not delete the provisions above, a recipient
 * may use your version of this file under either the MPL or the
 * GPL.
 */

#ifndef DomProviderHIncl
#define DomProviderHIncl

#include "base.h"
#include "sxpath.h"

class DOMProvider
{
public:
    virtual SXP_NodeType getNodeType(SXP_Node n) = 0;
    virtual const SXP_char* getNodeName(SXP_Node n) = 0;
    virtual const SXP_char* getNodeNameURI(SXP_Node n) = 0;
    virtual const SXP_char* getNodeNameLocal(SXP_Node n) = 0;
    virtual const SXP_char* getNodeValue(SXP_Node n) = 0;
    virtual SXP_Node     getNextSibling(SXP_Node n) = 0;
    virtual SXP_Node     getPreviousSibling(SXP_Node n) = 0;
    virtual SXP_Node     getNextAttrNS(SXP_Node n) = 0;
    virtual SXP_Node     getPreviousAttrNS(SXP_Node n) = 0;
    virtual int          getChildCount(SXP_Node n) = 0;
    virtual int          getAttributeCount(SXP_Node n) = 0;
    virtual int          getNamespaceCount(SXP_Node n) = 0;
    virtual SXP_Node     getChildNo(SXP_Node n, int ndx) = 0;
    virtual SXP_Node     getAttributeNo(SXP_Node n, int ndx) = 0;
    virtual SXP_Node     getNamespaceNo(SXP_Node n, int ndx) = 0;
    virtual SXP_Node     getParent(SXP_Node n) = 0;
    virtual SXP_Document getOwnerDocument(SXP_Node n) = 0;    
    virtual int          compareNodes(SXP_Node n1, SXP_Node n2) = 0;
	virtual SXP_Document retrieveDocument(const SXP_char* uri) = 0;    
    void                 constructStringValue(SXP_Node n, DStr &result);
    SXP_Node             getFirstChild(SXP_Node n);
};

class DOMProviderStandard : public DOMProvider
{
public:
    virtual SXP_NodeType getNodeType(SXP_Node n);
    virtual const SXP_char* getNodeName(SXP_Node n);
    virtual const SXP_char* getNodeNameURI(SXP_Node n);
    virtual const SXP_char* getNodeNameLocal(SXP_Node n);
    virtual const SXP_char* getNodeValue(SXP_Node n);
    virtual SXP_Node     getNextSibling(SXP_Node n);
    virtual SXP_Node     getPreviousSibling(SXP_Node n);
    virtual SXP_Node     getNextAttrNS(SXP_Node n);
    virtual SXP_Node     getPreviousAttrNS(SXP_Node n);
    virtual int          getChildCount(SXP_Node n);
    virtual int          getAttributeCount(SXP_Node n);
    virtual int          getNamespaceCount(SXP_Node n);
    virtual SXP_Node     getChildNo(SXP_Node n, int ndx);
    virtual SXP_Node     getAttributeNo(SXP_Node n, int ndx);
    virtual SXP_Node     getNamespaceNo(SXP_Node n, int ndx);
    virtual SXP_Node     getParent(SXP_Node n);
    virtual SXP_Document getOwnerDocument(SXP_Node n);    
    virtual int          compareNodes(SXP_Node n1, SXP_Node n2);
	virtual SXP_Document retrieveDocument(const SXP_char* uri);    
};

class DOMProviderExternal : public DOMProvider
{
public:
    DOMProviderExternal(DOMHandler *domh_) : domh(domh_) {};
    virtual SXP_NodeType getNodeType(SXP_Node n)
        { return domh -> getNodeType(n); }
    virtual const SXP_char* getNodeName(SXP_Node n)
        { return domh -> getNodeName(n); }
    virtual const SXP_char* getNodeNameURI(SXP_Node n)
        { return domh -> getNodeNameURI(n); }
    virtual const SXP_char* getNodeNameLocal(SXP_Node n)
        { return domh -> getNodeNameLocal(n); }
    virtual const SXP_char* getNodeValue(SXP_Node n)
        { return domh -> getNodeValue(n); }
    virtual SXP_Node     getNextSibling(SXP_Node n)
        { return domh -> getNextSibling(n); }
    virtual SXP_Node     getPreviousSibling(SXP_Node n)
        { return domh -> getPreviousSibling(n); }
    virtual SXP_Node     getNextAttrNS(SXP_Node n)
        { return domh -> getNextAttrNS(n); }
    virtual SXP_Node     getPreviousAttrNS(SXP_Node n)
        { return domh -> getPreviousAttrNS(n); }
    virtual int          getChildCount(SXP_Node n)
        { return domh -> getChildCount(n); }
    virtual int          getAttributeCount(SXP_Node n)
        { return domh -> getAttributeCount(n); }
    virtual int          getNamespaceCount(SXP_Node n)
        { return domh -> getNamespaceCount(n); }
    virtual SXP_Node     getChildNo(SXP_Node n, int ndx)
        { return domh -> getChildNo(n, ndx); }
    virtual SXP_Node     getAttributeNo(SXP_Node n, int ndx)
        { return domh -> getAttributeNo(n, ndx); }
    virtual SXP_Node     getNamespaceNo(SXP_Node n, int ndx)
        { return domh -> getNamespaceNo(n, ndx); }
    virtual SXP_Node     getParent(SXP_Node n)
        { return domh -> getParent(n); }
    virtual SXP_Document getOwnerDocument(SXP_Node n)
        { return domh -> getOwnerDocument(n); }
    virtual int          compareNodes(SXP_Node n1, SXP_Node n2)
        { return domh -> compareNodes(n1, n2); }
	virtual SXP_Document retrieveDocument(const SXP_char* uri)
	    { return domh -> retrieveDocument(uri); }
private:
    DOMHandler *domh;
};

class Context;
class Number;
class Str;
class Element;
class Tree;
class Processor;

class QueryContextClass
{
public:
    QueryContextClass(Sit S);
    ~QueryContextClass();
    eFlag query(const SXP_char* queryText,
        SXP_Node n,
	    int contextPosition,
	    int contextSize);
    eFlag addVariableExpr(const SXP_char* name, Expression *value);	    
    eFlag addVariableBinding(const SXP_char* name, QueryContextClass &source);
    eFlag addNamespaceDeclaration(const SXP_char* prefix, 
        const SXP_char* uri);
	SXP_ExpressionType getType();
	const Number *getNumber();
	const Str *getString();
	Bool getBoolean();
	const Context *getNodeset();	
    Expression *getNewExpr();
private:
    Tree *baseTree;
    Element *baseElement;
    Expression *queryExpression, *resultExpression;
    Str* stringValue;
    Number *numberValue;
    Situation *theSituation;
    Expression *getExpression_() const;
    Processor *proc;
};

#endif // DomProviderHIncl
