/****************************************************************************
/                                                                           
/                     Copyright 2002 Macromedia, Inc.                       
/                                                                          
/      This material is the confidential trade secret and proprietary       
/      information of Macromedia, Inc.  It may not be reproduced, used,     
/      sold or transferred to any third party without the prior written     
/      consent of Macromedia, Inc.  All rights reserved.                    
/                                                                          
/ Filename
/   jsprofiler.h
/
/ Purpose
/   When we're running a profiler, such as Rational Quantify or the one
/	included with CodeWarrior, it's difficult to account for time spent
/	in JavaScript.  The profiler simply shows that we're spending a lot
/	of time in js_Interpret, which isn't very helpful.  It would be nice
/	to know which JavaScript functions took the longest to execute.
/
/	The code in this file isn't a profiler per se.  Rather, it is a hack
/	that will allow you to see your JavaScript functions using the profiler
/	that you already use.
/
/	First, the mechanics.  In order to enable this code, do the following:
/	1) Enable the #define for MACROMEDIA_JAVASCRIPT_PROFILING, below.
/	2) Identify the code that you want to profile.  Just before that code
/      begins executing, call jsprofiler_Start().
/   3) Just after that code finishes executing, call jsprofiler_Stop().
/	4) Before the application shuts down, call jsprofiler_Dump(fileName)
/	   Pass the path to a log file, such as "c:\ProfilerDump.txt".
/	5) Add jsprofiler.c to the Javascript project, if it's not already
/	   included.
/
/	In order to use this tool, you need to understand the implementation.
/
/	Roughly speaking, every call to a JavaScript function is implemented
/	internally by a call to the js_Interpret function.  The code in the
/	jsprofiler module inserts itself into the stack frame between the caller
/	of js_Interpret and the implementation of js_Interpret, so that you can
/	see which JavaScript function is being called.
/
/	When JavaScirpt profiling is enabled, the implementation of js_Interpret
/	is changed to be the following:
/
/		extern JSBool js_Interpret(JSContext *cx, jsval *result)
/		{
/			return jsprofiler_Interpret(cx, result);
/		}
/
/		extern JSBool js_InterpretInternal(JSContext *cx, jsval *result)
/		{
/			original contents of js_Interpret
/		}
/
/	The implementation of jsprofiler_Interpret is ultimately going to
/	call js_InterpretInternal.  But if it called that function directly,
/	we'd be no better off than before.
/
/	Instead, jsprofiler.cpp contains implementations for 1000 dummy
/	functions of the form:
/
/		extern JSBool jsprofiler_XXXX(JSContext, *cx, jsval *result)
/		{
/			return js_InterpretInternal(cx, result);
/		}
/
/	XXXX is replaced by a 4 digit number, currently ranging from
/	0000 to 0999.
/
/	The implementation of jsprofiler_Interpret looks at the name of
/	the JavaScript function that's being called.  Each unique 
/	JavaScript function is assigned a number in the range from 
/	0 to 999.  When the that JavaScript function is called, the call
/	is routed to the appropriate jsprofiler_XXXX function.
/
/   Example: suppose that Dreamweaver calls a JavaScript function called
/	applyServerBehavior, which in turn calls a JS function called doApply.
/	The stack frame might look like this (read from bottom to top):
/
/		js_InterpretInternal()
/		jsprofiler_0456()        <-- corresponds to doApply
/		jsprofiler_Interpret()
/		js_Interpret()
/		js_Invoke()
/		js_InterpretInternal()
/		jsprofiler_0123()        <-- corresponds to applyServerBehavior
/		jsprofiler_Interpret()
/		js_Interpret()
/		JS_CallFunction()
/
/	Later, when you look at the report generated by Quantify or the
/	CodeWarrior profiler, you'll be able to see how much time was spent
/	in jsprofiler_0123 or jsprofiler_0456.  The log file, generated
/	by jsprofiler_Dump(), will tell you which jsprofiler_XXXX function
/   corresponds to which JavaScript function.
/
/	If you see calls to jsprofiler_Overflow(), then the code that
/	you're profiling includes calls to more than 1000 unique JavaScript
/	functions.  You'll need to increase the number of functions that are
/	defined in jsprofiler.cpp.
/
****************************************************************************/
#ifndef jsprofiler_h___
#define jsprofiler_h___

// #define MACR_JAVASCRIPT_PROFILING

#ifdef WINPROFILE
	#define MACR_JAVASCRIPT_PROFILING
#endif

#ifdef MACR_JAVASCRIPT_PROFILING

#include "jsprvtd.h"
#include "jspubtd.h"

JS_BEGIN_EXTERN_C

extern JSBool
jsprofiler_Interpret(JSContext *cx, jsval *result);

extern void
jsprofiler_Start();

extern void
jsprofiler_Stop();

extern void
jsprofiler_Dump(JSContext *cx, char *logFile);

JS_END_EXTERN_C

#endif /* MACR_JAVASCRIPT_PROFILING */
#endif /* jsprofiler_h___ */
