/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.doclets.standard;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.PackageDoc;
import com.sun.tools.doclets.DirectoryManager;
import com.sun.tools.doclets.DocletAbortException;
import com.sun.tools.doclets.standard.ClassUseMapper;
import com.sun.tools.doclets.standard.ConfigurationStandard;
import com.sun.tools.doclets.standard.Standard;
import com.sun.tools.doclets.standard.SubWriterHolderWriter;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;

public class PackageUseWriter
extends SubWriterHolderWriter {
    final PackageDoc pkgdoc;
    final SortedMap usingPackageToUsedClasses = new TreeMap();

    public PackageUseWriter(ClassUseMapper classUseMapper, String string, PackageDoc packageDoc) throws IOException, DocletAbortException {
        super(DirectoryManager.getDirectoryPath(packageDoc), string, DirectoryManager.getRelativePath(packageDoc.name()));
        this.pkgdoc = packageDoc;
        ClassDoc[] classDocArray = packageDoc.allClasses();
        int n = 0;
        while (n < classDocArray.length) {
            ClassDoc classDoc = classDocArray[n];
            Set set = (Set)classUseMapper.classToClass.get(classDoc);
            if (set != null) {
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    ClassDoc classDoc2 = (ClassDoc)iterator.next();
                    PackageDoc packageDoc2 = classDoc2.containingPackage();
                    TreeSet<ClassDoc> treeSet = (TreeSet<ClassDoc>)this.usingPackageToUsedClasses.get(packageDoc2);
                    if (treeSet == null) {
                        treeSet = new TreeSet<ClassDoc>();
                        this.usingPackageToUsedClasses.put(packageDoc2, treeSet);
                    }
                    treeSet.add(classDoc);
                }
            }
            ++n;
        }
    }

    public static void generate(ClassUseMapper classUseMapper, PackageDoc packageDoc) throws DocletAbortException {
        String string = "package-use.html";
        try {
            PackageUseWriter packageUseWriter = new PackageUseWriter(classUseMapper, string, packageDoc);
            packageUseWriter.generatePackageUseFile();
            packageUseWriter.close();
        }
        catch (IOException iOException) {
            Standard.configuration();
            ConfigurationStandard.standardmessage.error("doclet.exception_encountered", iOException.toString(), string);
            throw new DocletAbortException();
        }
    }

    protected void generatePackageUseFile() throws IOException {
        this.printPackageUseHeader();
        if (this.usingPackageToUsedClasses.isEmpty()) {
            this.printText("doclet.ClassUse_No.usage.of.0", this.pkgdoc.name());
            this.p();
        } else {
            this.generatePackageUse();
        }
        this.printPackageUseFooter();
    }

    protected void generatePackageUse() throws IOException {
        if (Standard.configuration().packages.length > 1) {
            this.generatePackageList();
        }
        this.generateClassList();
    }

    protected void generatePackageList() throws IOException {
        this.tableIndexSummary();
        this.tableHeaderStart("#CCCCFF");
        this.printText("doclet.ClassUse_Packages.that.use.0", this.getPackageLink(this.pkgdoc));
        this.tableHeaderEnd();
        Iterator iterator = this.usingPackageToUsedClasses.keySet().iterator();
        while (iterator.hasNext()) {
            PackageDoc packageDoc = (PackageDoc)iterator.next();
            this.generatePackageUse(packageDoc);
        }
        this.tableEnd();
        this.space();
        this.p();
    }

    protected void generateClassList() throws IOException {
        Iterator iterator = this.usingPackageToUsedClasses.keySet().iterator();
        while (iterator.hasNext()) {
            PackageDoc packageDoc = (PackageDoc)iterator.next();
            this.anchor(packageDoc.name());
            this.tableIndexSummary();
            this.tableHeaderStart("#CCCCFF");
            this.printText("doclet.ClassUse_Classes.in.0.used.by.1", this.getPackageLink(this.pkgdoc), this.getPackageLink(packageDoc));
            Iterator iterator2 = ((Collection)this.usingPackageToUsedClasses.get(packageDoc)).iterator();
            while (iterator2.hasNext()) {
                this.printClassRow((ClassDoc)iterator2.next(), packageDoc);
            }
            this.tableHeaderEnd();
            this.tableEnd();
            this.space();
            this.p();
        }
    }

    protected void printClassRow(ClassDoc classDoc, PackageDoc packageDoc) {
        String string = this.pathString(classDoc, "class-use/" + classDoc.name() + ".html");
        this.trBgcolorStyle("white", "TableRowColor");
        this.summaryRow(0);
        this.bold();
        this.printHyperLink(string, packageDoc.name(), classDoc.name(), true);
        this.boldEnd();
        this.println();
        this.br();
        this.printNbsps();
        this.printIndexComment(classDoc);
        this.summaryRowEnd();
        this.trEnd();
    }

    protected void generatePackageUse(PackageDoc packageDoc) throws IOException {
        this.trBgcolorStyle("white", "TableRowColor");
        this.summaryRow(0);
        this.printHyperLink("", packageDoc.name(), packageDoc.name(), true);
        this.summaryRowEnd();
        this.summaryRow(0);
        this.printSummaryComment(packageDoc);
        this.space();
        this.summaryRowEnd();
        this.trEnd();
    }

    protected void printPackageUseHeader() {
        String string = this.getText("doclet.Package");
        String string2 = this.pkgdoc.name();
        this.printHeader(this.getText("doclet.Window_ClassUse_Header", Standard.configuration().windowtitle, string, string2));
        this.navLinks(true);
        this.hr();
        this.center();
        this.h2();
        this.boldText("doclet.ClassUse_Title", string, string2);
        this.h2End();
        this.centerEnd();
    }

    protected void printPackageUseFooter() {
        this.hr();
        this.navLinks(false);
        this.printBottom();
        this.printBodyHtmlEnd();
    }

    protected void navLinkPackage() {
        this.navCellStart();
        this.printHyperLink("package-summary.html", "", this.getText("doclet.Package"), true, "NavBarFont1");
        this.navCellEnd();
    }

    protected void navLinkClassUse() {
        this.navCellRevStart();
        this.fontStyle("NavBarFont1Rev");
        this.boldText("doclet.navClassUse");
        this.fontEnd();
        this.navCellEnd();
    }

    protected void navLinkTree() {
        this.navCellStart();
        this.printHyperLink("package-tree.html", "", this.getText("doclet.Tree"), true, "NavBarFont1");
        this.navCellEnd();
    }
}

