/*
 * Decompiled with CFR 0.152.
 */
package com.techtrader.modules.tools.bytecode;

import com.techtrader.modules.tools.bytecode.Code;
import com.techtrader.modules.tools.bytecode.Instruction;
import com.techtrader.modules.tools.bytecode.JumpInstruction;
import com.techtrader.modules.tools.bytecode.visitor.BCVisitor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class TableSwitchInstruction
extends JumpInstruction {
    private int _low = 0;
    private int _high = 0;
    private List _offsets = new LinkedList();
    private List _targets = new LinkedList();

    public Instruction getDefaultTarget() {
        return this.getTarget();
    }

    public void setDefaultTarget(Instruction instruction) {
        this.setTarget(instruction);
    }

    public int getDefaultOffset() {
        return this.getOffset();
    }

    public void setDefaultOffset(int n) {
        this.setOffset(n);
    }

    public int getLow() {
        return this._low;
    }

    public void setLow(int n) {
        this._low = n;
    }

    public int getHigh() {
        return this._high;
    }

    public void setHigh(int n) {
        this._high = n;
    }

    public void setTargets(Instruction[] instructionArray) {
        this._targets.clear();
        this._offsets.clear();
        if (instructionArray != null) {
            int n = 0;
            while (n < instructionArray.length) {
                this._targets.add(instructionArray[n]);
                ++n;
            }
        }
    }

    public void setOffsets(int[] nArray) {
        this._targets.clear();
        this._offsets.clear();
        if (nArray != null) {
            int n = 0;
            while (n < nArray.length) {
                this._offsets.add(new Integer(nArray[n]));
                ++n;
            }
        }
    }

    public Instruction[] getTargets() {
        return this._targets.toArray(new Instruction[this._targets.size()]);
    }

    public int[] getOffsets() {
        Object object;
        if (this._targets.size() > 0) {
            this._offsets.clear();
            object = this._targets.iterator();
            while (object.hasNext()) {
                this._offsets.add(new Integer(((Instruction)object.next()).getByteIndex() - this.getByteIndex()));
            }
        }
        object = new int[this._offsets.size()];
        Iterator iterator = this._offsets.iterator();
        int n = 0;
        while (n < ((Object)object).length) {
            object[n] = (Integer)iterator.next();
            ++n;
        }
        return object;
    }

    public void addTarget(Instruction instruction) {
        this._targets.add(instruction);
    }

    public int getLength() {
        int n = 1;
        int n2 = this.getByteIndex() + 1;
        while (n2 % 4 != 0) {
            ++n2;
            ++n;
        }
        n += 12;
        n = this._targets.size() > 0 ? (n += 4 * this._targets.size()) : (n += 4 * this._offsets.size());
        return n;
    }

    public int getStackChange() {
        return -1;
    }

    public void readData(DataInput dataInput) throws IOException {
        int n = this.getByteIndex() + 1;
        while (n % 4 != 0) {
            dataInput.readByte();
            ++n;
        }
        this.setOffset(dataInput.readInt());
        this.setLow(dataInput.readInt());
        this.setHigh(dataInput.readInt());
        this._offsets.clear();
        this._targets.clear();
        n = 0;
        while (n < this._high - this._low + 1) {
            this._offsets.add(new Integer(dataInput.readInt()));
            ++n;
        }
    }

    public void writeData(DataOutput dataOutput) throws IOException {
        int n = this.getByteIndex() + 1;
        while (n % 4 != 0) {
            dataOutput.writeByte(0);
            ++n;
        }
        dataOutput.writeInt(this.getOffset());
        dataOutput.writeInt(this.getLow());
        dataOutput.writeInt(this.getHigh());
        int[] nArray = this.getOffsets();
        int n2 = 0;
        while (n2 < nArray.length) {
            dataOutput.writeInt(nArray[n2]);
            ++n2;
        }
    }

    private Instruction findTarget(int n, List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Instruction instruction = (Instruction)iterator.next();
            if (instruction.getByteIndex() != n) continue;
            return instruction;
        }
        return null;
    }

    public void setMarkers(List list) {
        super.setMarkers(list);
        this._targets.clear();
        int n = this.getByteIndex();
        Iterator iterator = this._offsets.iterator();
        while (iterator.hasNext()) {
            int n2 = n + ((Number)iterator.next()).intValue();
            this._targets.add(this.findTarget(n2, list));
        }
    }

    public void acceptVisit(BCVisitor bCVisitor) {
        bCVisitor.enterTableSwitchInstruction(this);
        bCVisitor.exitTableSwitchInstruction(this);
    }

    protected TableSwitchInstruction(Code code) {
        super(code, 170);
    }
}

