/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.windows;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.dnd.DropTarget;
import java.awt.dnd.peer.DropTargetPeer;
import java.awt.event.PaintEvent;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.awt.peer.ComponentPeer;
import java.awt.peer.LightweightPeer;
import java.security.AccessController;
import sun.awt.DebugHelper;
import sun.awt.RepaintArea;
import sun.awt.ScreenUpdater;
import sun.awt.SunToolkit;
import sun.awt.UpdateClient;
import sun.awt.Win32GraphicsConfig;
import sun.awt.image.OffScreenImage;
import sun.awt.windows.WFontMetrics;
import sun.awt.windows.WGraphics;
import sun.awt.windows.WImage;
import sun.awt.windows.WObjectPeer;
import sun.awt.windows.WPrintGraphicsWrapper;
import sun.awt.windows.WToolkit;
import sun.awt.windows.WWindowPeer;
import sun.security.action.GetPropertyAction;

abstract class WComponentPeer
extends WObjectPeer
implements ComponentPeer,
UpdateClient,
DropTargetPeer {
    private static final DebugHelper dbg = DebugHelper.create(class$sun$awt$windows$WComponentPeer == null ? (class$sun$awt$windows$WComponentPeer = WComponentPeer.class$("sun.awt.windows.WComponentPeer")) : class$sun$awt$windows$WComponentPeer);
    private boolean repaintPending;
    private Rectangle repaintRect;
    private RepaintArea paintArea;
    private RepaintArea updateArea;
    protected Win32GraphicsConfig winGraphicsConfig;
    int nDropTargets;
    int nativeDropTargetContext;
    public int serialNum = 0;
    private static final double BANDING_DIVISOR = 4.0;
    private int updateX1;
    private int updateY1;
    private int updateX2;
    private int updateY2;
    private static final boolean isFocusFixEnabled = AccessController.doPrivileged(new GetPropertyAction("sun.awt.activationFocusFix", "")).equals("true");
    private static final boolean isConsumeWM_HELPEnabled = AccessController.doPrivileged(new GetPropertyAction("sun.awt.activationF1Fix", "")).equals("true");
    static /* synthetic */ Class class$sun$awt$windows$WComponentPeer;

    native GraphicsConfiguration getTargetGC();

    public synchronized native void show();

    public synchronized native void hide();

    public synchronized native void enable();

    public synchronized native void disable();

    public native Point getLocationOnScreen();

    public void setVisible(boolean bl) {
        if (bl) {
            this.show();
        } else {
            this.hide();
        }
    }

    public void setEnabled(boolean bl) {
        if (bl) {
            this.enable();
        } else {
            this.disable();
        }
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        this.reshape(n, n2, n3, n4);
        ++this.serialNum;
    }

    void paintDamagedAreaImmediately() {
        this.updateWindow();
        WToolkit.getWToolkit().flushPendingEvents();
        this.paintArea.paint(this.target, this.shouldClearRectBeforePaint());
    }

    synchronized native void updateWindow();

    public void paint(Graphics graphics) {
        ((Component)this.target).paint(graphics);
    }

    public void repaint(long l, int n, int n2, int n3, int n4) {
        this.addRepaintArea(n, n2, n3, n4);
        ScreenUpdater.updater.notify(this, l);
    }

    private native int[] createPrintedPixels(int var1, int var2, int var3, int var4);

    public void print(Graphics graphics) {
        Component component = (Component)this.target;
        if (graphics instanceof WGraphics) {
            ((WGraphics)graphics).print(this);
        } else if (graphics instanceof WPrintGraphicsWrapper) {
            ((WGraphics)((WPrintGraphicsWrapper)graphics).getTarget()).print(this);
        } else {
            int n = component.getWidth();
            int n2 = component.getHeight();
            int n3 = (int)((double)n2 / 4.0);
            int n4 = 0;
            while (n4 < n2) {
                int n5;
                int[] nArray;
                int n6 = n4 + n3 - 1;
                if (n6 >= n2) {
                    n6 = n2 - 1;
                }
                if ((nArray = this.createPrintedPixels(0, n4, n, n5 = n6 - n4 + 1)) != null) {
                    BufferedImage bufferedImage = new BufferedImage(n, n5, 1);
                    bufferedImage.setRGB(0, 0, n, n5, nArray, 0, n);
                    graphics.drawImage(bufferedImage, 0, n4, null);
                    bufferedImage.flush();
                }
                n4 += n3;
            }
        }
        component.print(graphics);
    }

    public void coalescePaintEvent(PaintEvent paintEvent) {
        Rectangle rectangle = paintEvent.getUpdateRect();
        int n = paintEvent.getID();
        switch (n) {
            case 800: {
                this.paintArea.add(rectangle);
                return;
            }
            case 801: {
                this.updateArea.add(rectangle);
                return;
            }
        }
    }

    public synchronized native void reshape(int var1, int var2, int var3, int var4);

    native void nativeHandleEvent(AWTEvent var1);

    public void handleEvent(AWTEvent aWTEvent) {
        int n = aWTEvent.getID();
        switch (n) {
            case 800: {
                this.paintArea.paint(this.target, this.shouldClearRectBeforePaint());
                return;
            }
            case 801: {
                this.updateArea.update(this.target);
                return;
            }
        }
        this.nativeHandleEvent(aWTEvent);
    }

    public boolean shouldClearRectBeforePaint() {
        return true;
    }

    public Dimension getMinimumSize() {
        return ((Component)this.target).getSize();
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public boolean isFocusTraversable() {
        return false;
    }

    public GraphicsConfiguration getGraphicsConfiguration() {
        if (this.winGraphicsConfig != null) {
            return this.winGraphicsConfig;
        }
        Object object = ((Component)this.target).getTreeLock();
        synchronized (object) {
            GraphicsConfiguration graphicsConfiguration = ((Component)this.target).getGraphicsConfiguration();
            return graphicsConfiguration;
        }
    }

    protected void initNonDefaultGC() {
    }

    void resetLocalGC() {
        Object object = ((Component)this.target).getTreeLock();
        synchronized (object) {
            this.winGraphicsConfig = null;
        }
    }

    public ColorModel getColorModel() {
        GraphicsConfiguration graphicsConfiguration = this.getGraphicsConfiguration();
        if (graphicsConfiguration != null) {
            return graphicsConfiguration.getColorModel();
        }
        return null;
    }

    public ColorModel getColorModel(int n) {
        GraphicsConfiguration graphicsConfiguration = this.getGraphicsConfiguration();
        if (graphicsConfiguration != null) {
            return graphicsConfiguration.getColorModel(n);
        }
        return null;
    }

    public Toolkit getToolkit() {
        return Toolkit.getDefaultToolkit();
    }

    public synchronized Graphics getGraphics() {
        if (!this.isDisposed()) {
            WGraphics wGraphics = new WGraphics(this);
            ((Graphics)wGraphics).setColor(((Component)this.target).getForeground());
            ((Graphics)wGraphics).setFont(((Component)this.target).getFont());
            return wGraphics;
        }
        return null;
    }

    public FontMetrics getFontMetrics(Font font) {
        return WFontMetrics.getFontMetrics(font);
    }

    private synchronized native void _dispose();

    protected void disposeImpl() {
        ScreenUpdater.updater.removeClient(this);
        WToolkit.targetDisposedPeer(this.target, this);
        this._dispose();
    }

    public synchronized void setForeground(Color color) {
        this._setForeground(color.getRGB());
    }

    public synchronized void setBackground(Color color) {
        this._setBackground(color.getRGB());
    }

    public native void _setForeground(int var1);

    public native void _setBackground(int var1);

    public synchronized native void setFont(Font var1);

    public synchronized native void pRequestFocus();

    public synchronized void requestFocus() {
        WWindowPeer.cancelFocusOnActivate((Component)this.target);
        this.pRequestFocus();
    }

    public final void setCursor(Cursor cursor) {
    }

    public Image createImage(ImageProducer imageProducer) {
        return new WImage(imageProducer);
    }

    public Image createImage(int n, int n2) {
        ColorModel colorModel = this.getColorModel(1);
        return new OffScreenImage((Component)this.target, colorModel, colorModel.createCompatibleWritableRaster(n, n2), colorModel.isAlphaPremultiplied());
    }

    public boolean prepareImage(Image image, int n, int n2, ImageObserver imageObserver) {
        return WToolkit.prepareScrImage(image, n, n2, imageObserver);
    }

    public int checkImage(Image image, int n, int n2, ImageObserver imageObserver) {
        return WToolkit.checkScrImage(image, n, n2, imageObserver);
    }

    public void updateClient(Object object) {
        Rectangle rectangle = null;
        WComponentPeer wComponentPeer = this;
        synchronized (wComponentPeer) {
            if (this.repaintPending) {
                rectangle = this.repaintRect;
                this.repaintPending = false;
            }
        }
        if (rectangle != null) {
            this.postEvent(new PaintEvent((Component)this.target, 801, rectangle));
        }
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.target + "]";
    }

    WComponentPeer(Component component) {
        this.target = component;
        this.repaintRect = new Rectangle();
        this.repaintPending = false;
        this.paintArea = new RepaintArea();
        this.updateArea = new RepaintArea();
        Container container = SunToolkit.getNativeContainer(component);
        WComponentPeer wComponentPeer = (WComponentPeer)WToolkit.targetToPeer(container);
        this.create(wComponentPeer);
        this.initialize();
        this.start();
        this.initNonDefaultGC();
    }

    abstract void create(WComponentPeer var1);

    synchronized native void start();

    void initialize() {
        Font font;
        Color color;
        this.initZOrderPosition();
        if (((Component)this.target).isVisible()) {
            this.show();
        }
        if ((color = ((Component)this.target).getForeground()) != null) {
            this.setForeground(color);
        }
        if ((font = ((Component)this.target).getFont()) != null) {
            this.setFont(font);
        }
        if (!((Component)this.target).isEnabled()) {
            this.disable();
        }
        Rectangle rectangle = ((Component)this.target).getBounds();
        this.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    private synchronized void addRepaintArea(int n, int n2, int n3, int n4) {
        if (!this.repaintPending) {
            this.repaintPending = true;
            this.repaintRect = new Rectangle(n, n2, n3, n4);
        } else {
            this.repaintRect = this.repaintRect.union(new Rectangle(n, n2, n3, n4));
        }
    }

    void handleRepaint(int n, int n2, int n3, int n4) {
    }

    void handleExpose(int n, int n2, int n3, int n4) {
        this.postEvent(new PaintEvent((Component)this.target, 800, new Rectangle(n, n2, n3, n4)));
    }

    void handlePaint(int n, int n2, int n3, int n4) {
        this.postEvent(new PaintEvent((Component)this.target, 800, new Rectangle(n, n2, n3, n4)));
    }

    void postEvent(AWTEvent aWTEvent) {
        SunToolkit.postEvent(SunToolkit.targetToAppContext(this.target), aWTEvent);
    }

    public void beginValidate() {
        this._beginValidate();
    }

    public native void _beginValidate();

    public native void endValidate();

    public void initZOrderPosition() {
        Container container = ((Component)this.target).getParent();
        WComponentPeer wComponentPeer = null;
        if (container != null) {
            Component[] componentArray = container.getComponents();
            int n = 0;
            while (n < componentArray.length) {
                if (componentArray[n] == this.target) break;
                Object object = WToolkit.targetToPeer(componentArray[n]);
                if (object != null && !(object instanceof LightweightPeer)) {
                    wComponentPeer = (WComponentPeer)object;
                }
                ++n;
            }
        }
        this.setZOrderPosition(wComponentPeer);
    }

    native void setZOrderPosition(WComponentPeer var1);

    public Dimension minimumSize() {
        return this.getMinimumSize();
    }

    public Dimension preferredSize() {
        return this.getPreferredSize();
    }

    public synchronized void addDropTarget(DropTarget dropTarget) {
        if (this.nDropTargets == 0) {
            this.nativeDropTargetContext = this.addNativeDropTarget();
        }
        ++this.nDropTargets;
    }

    public synchronized void removeDropTarget(DropTarget dropTarget) {
        --this.nDropTargets;
        if (this.nDropTargets == 0) {
            this.removeNativeDropTarget();
            this.nativeDropTargetContext = 0;
        }
    }

    native int addNativeDropTarget();

    native void removeNativeDropTarget();

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

