DROP TABLE IF EXISTS `{$db_pre}article`;
CREATE TABLE `{$db_pre}article` (
  `article_id` mediumint(8) unsigned NOT NULL auto_increment,
  `cat_id` smallint(5) NOT NULL default '0',
  `rel_software_id` varchar(255) NOT NULL default '',
  `title` varchar(150) NOT NULL,
  `content` longtext NOT NULL,
  `last_update` int(10) unsigned NOT NULL default '0',
  `sort_order` smallint(4) unsigned NOT NULL default '0',
  `seo_title` varchar(150) NOT NULL default '',
  `seo_keywords` varchar(255) NOT NULL default '',
  `seo_desc` varchar(255) NOT NULL default '',
  `is_article` tinyint(1) unsigned NOT NULL default '1',
  `is_support` tinyint(1) unsigned NOT NULL default '0',
  `is_news` tinyint(1) unsigned NOT NULL default '0',
  PRIMARY KEY  (`article_id`),
  UNIQUE KEY `title` (`title`),
  KEY `cat_id` (`cat_id`),
  KEY `rel_software_id` (`rel_software_id`),
  KEY `sort_order` (`sort_order`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

LOCK TABLES `{$db_pre}article` WRITE;
/*!40000 ALTER TABLE `{$db_pre}article` DISABLE KEYS */;
/*!40000 ALTER TABLE `{$db_pre}article` ENABLE KEYS */;
UNLOCK TABLES;




DROP TABLE IF EXISTS `{$db_pre}blocks`;
CREATE TABLE `{$db_pre}blocks` (
  `block_id` smallint(5) unsigned NOT NULL auto_increment,
  `block_name` varchar(120) NOT NULL default '',
  `display_name` varchar(120) NOT NULL default '',
  `block_icon` varchar(255) NOT NULL default '',
  `lib_file` varchar(120) NOT NULL default '',
  `block_type` varchar(16) NOT NULL default '',
  `block_setting` text NOT NULL,
  `block_custom_data` text,
  `update_time` int(10) NOT NULL default '0',
  PRIMARY KEY  (`block_id`),
  UNIQUE KEY `block_name` (`block_name`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

LOCK TABLES `{$db_pre}blocks` WRITE;
/*!40000 ALTER TABLE `{$db_pre}blocks` DISABLE KEYS */;
/*!40000 ALTER TABLE `{$db_pre}blocks` ENABLE KEYS */;
UNLOCK TABLES;


DROP TABLE IF EXISTS `{$db_pre}tpls`;
CREATE TABLE `{$db_pre}tpls` (
  `seat_block_id` smallint(5) unsigned NOT NULL auto_increment,
  `tpl` 		varchar(64) NOT NULL default '',
  `file` 	varchar(64) NOT NULL default '',
  `seat` 	 varchar(32) NOT NULL default '',
  `block_id` smallint(5) unsigned NOT NULL ,
  `sort_order` smallint(4) unsigned NOT NULL default '0',
  `is_open` tinyint(1) unsigned NOT NULL default '1',
  `update_time` int(10) NOT NULL default '0',
  PRIMARY KEY  (`seat_block_id`),
  KEY `sort_order` (`sort_order`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

LOCK TABLES `{$db_pre}tpls` WRITE;
/*!40000 ALTER TABLE `{$db_pre}tpls` DISABLE KEYS */;
/*!40000 ALTER TABLE `{$db_pre}tpls` ENABLE KEYS */;
UNLOCK TABLES;

DROP TABLE IF EXISTS `{$db_pre}category`;
CREATE TABLE `{$db_pre}category` (
  `cat_id` smallint(5) unsigned NOT NULL auto_increment,
  `parent_id` smallint(5) unsigned NOT NULL default '0',
  `cat_name` varchar(90) NOT NULL,
  `seo_keywords` varchar(255) NOT NULL,
  `seo_desc` varchar(255) NOT NULL,
  `sort_order` smallint(4) unsigned NOT NULL default '0',
  `is_open` tinyint(1) unsigned NOT NULL default '1',
  `cat_type` varchar(16) NOT NULL default '',
  PRIMARY KEY  (`cat_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

LOCK TABLES `{$db_pre}category` WRITE;
/*!40000 ALTER TABLE `{$db_pre}category` DISABLE KEYS */;
INSERT INTO `{$db_pre}category` VALUES (1,0,'未分类','','',0,1,'software'),(2,0,'未分类','','',0,1,'article');
/*!40000 ALTER TABLE `{$db_pre}category` ENABLE KEYS */;
UNLOCK TABLES;




DROP TABLE IF EXISTS `{$db_pre}channel`;
CREATE TABLE `{$db_pre}channel` (
  `channel_id` smallint(5) unsigned NOT NULL auto_increment,
  `channel_name` varchar(255) NOT NULL,
  `menu` text NOT NULL,
  `sort_order` smallint(4) unsigned NOT NULL default '0',
  `go_to_link` varchar(255) NOT NULL default '',
  `is_open` tinyint(1) unsigned NOT NULL default '1',
  `seo_title` varchar(255) NOT NULL default '',
  `seo_keywords` varchar(255) NOT NULL default '',
  `seo_desc` varchar(255) default NULL,
  `type` varchar(16) NOT NULL default '',
  `content` text,
  PRIMARY KEY  (`channel_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

LOCK TABLES `{$db_pre}channel` WRITE;
/*!40000 ALTER TABLE `{$db_pre}channel` DISABLE KEYS */;
INSERT INTO `{$db_pre}channel` VALUES (1,'Product','s:0:\"\";',0,'product.php',1,'','','','system',''),(2,'Download','s:0:\"\";',0,'download.php',1,'','','','system',''),(3,'Purchase','s:0:\"\";',0,'purchase.php',1,'','','','system',''),(4,'Article','s:0:\"\";',0,'article_list.php',1,'','','','system',''),(5,'Support','s:0:\"\";',0,'support.php',1,'','','','system',''),(6,'About','s:0:\"\";',0,'about.php',1,'','','','system','');
/*!40000 ALTER TABLE `{$db_pre}channel` ENABLE KEYS */;
UNLOCK TABLES;





DROP TABLE IF EXISTS `{$db_pre}images`;
CREATE TABLE `{$db_pre}images` (
  `image_id` mediumint(8) unsigned NOT NULL auto_increment,
  `software_id` mediumint(8) unsigned NOT NULL,
  `image_path` varchar(255) NOT NULL default '',
  `image_thumb_path` varchar(255) NOT NULL default '',
  `image_bewrite` varchar(512) default NULL,
  `sort_order` smallint(4) unsigned NOT NULL default '0',
  PRIMARY KEY  (`image_id`),
  KEY `software_id` (`software_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

LOCK TABLES `{$db_pre}images` WRITE;
/*!40000 ALTER TABLE `{$db_pre}images` DISABLE KEYS */;
/*!40000 ALTER TABLE `{$db_pre}images` ENABLE KEYS */;
UNLOCK TABLES;





DROP TABLE IF EXISTS `{$db_pre}keywords`;
CREATE TABLE `{$db_pre}keywords` (
  `keyword_id` smallint(5) unsigned NOT NULL auto_increment,
  `date` date NOT NULL default '0000-00-00',
  `searchengine` varchar(20) NOT NULL default '',
  `keyword` varchar(90) NOT NULL default '',
  `count` mediumint(8) unsigned NOT NULL default '0',
  PRIMARY KEY  (`keyword_id`),
  UNIQUE KEY `date` (`date`,`searchengine`,`keyword`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

LOCK TABLES `{$db_pre}keywords` WRITE;
/*!40000 ALTER TABLE `{$db_pre}keywords` DISABLE KEYS */;
/*!40000 ALTER TABLE `{$db_pre}keywords` ENABLE KEYS */;
UNLOCK TABLES;





DROP TABLE IF EXISTS `{$db_pre}online`;
CREATE TABLE `{$db_pre}online` (
  `sesskey` char(32) character set utf8 collate utf8_bin NOT NULL default '',
  `access_time` int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (`sesskey`)
) ENGINE=MEMORY DEFAULT CHARSET=utf8;

LOCK TABLES `{$db_pre}online` WRITE;
/*!40000 ALTER TABLE `{$db_pre}online` DISABLE KEYS */;
/*!40000 ALTER TABLE `{$db_pre}online` ENABLE KEYS */;
UNLOCK TABLES;





DROP TABLE IF EXISTS `{$db_pre}site_config`;
CREATE TABLE `{$db_pre}site_config` (
	  `name` varchar(120) NOT NULL default '',
	  `value` text NOT NULL,
	  `image_size` varchar(16) NOT NULL default '',
	  `update_time` int(10) NOT NULL default '0',
	  UNIQUE KEY `name` (`name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

LOCK TABLES `{$db_pre}site_config` WRITE;
/*!40000 ALTER TABLE `{$db_pre}site_config` DISABLE KEYS */;
INSERT INTO `{$db_pre}site_config` VALUES ('admin_left_tree','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','',''),('site_type','','',''),('site_title','刀客建站系统','',''),('site_name','刀客建站系统','',''),('site_keywords','刀客建站系统','',''),('site_is_close',0,'',''),('site_logo','','',''),('now_template','default','',''),('img_thumb','','',''),('list_thumb','','',''),('site_desc','刀客建站系统','',''),('email_setting','','',''),('get_pass_tmp_password','','',''),('get_pass_link_code','','',''),('admin_name','admin','',''),('admin_pass','','',''),('admin_email','','',''),('url_rewrite',0,'',''),('site_external_link','','',''),('site_copyright','','',''),('leave_word_setting','YTozOntzOjEzOiJtYWlsX3RvX2FkbWluIjtpOjE7czoxMzoiaXNfYXR0YWNobWVudCI7aToxO3M6NDoidHlwZSI7YToyOntpOjE7YToyOntzOjQ6Im5hbWUiO3M6MTY6IkN1c3RvbWVyIFNlcnZpY2UiO3M6MTA6InJldHVybl90cGwiO3M6MTIwOiJJbmZvcm1hdGlvbiBTdWJtaXR0ZWQgU3VjY2Vzc2Z1bGx5LgpZb3UgaW5mb3JtYXRpb24gaGFzIGJlZW4gc3VjY2Vzc2Z1bGx5IHN1Ym1pdHRlZC4gVGhhbmtzIHZlcnkgbXVjaCBmb3IgeW91ciBmZWVkYmFjay4iO31pOjI7YToyOntzOjQ6Im5hbWUiO3M6MTc6IlRlY2huaWNhbCBTdXBwb3J0IjtzOjEwOiJyZXR1cm5fdHBsIjtzOjEyMDoiSW5mb3JtYXRpb24gU3VibWl0dGVkIFN1Y2Nlc3NmdWxseS4KWW91IGluZm9ybWF0aW9uIGhhcyBiZWVuIHN1Y2Nlc3NmdWxseSBzdWJtaXR0ZWQuIFRoYW5rcyB2ZXJ5IG11Y2ggZm9yIHlvdXIgZmVlZGJhY2suIjt9fX0=','',''),('glo_proscenium_lang','','',''),('is_checkcode','1','',''),('default_icon','','',''),('book_mark','','','');
/*!40000 ALTER TABLE `{$db_pre}site_config` ENABLE KEYS */;
UNLOCK TABLES;





DROP TABLE IF EXISTS `{$db_pre}software`;
CREATE TABLE `{$db_pre}software` (
  `software_id` mediumint(8) unsigned NOT NULL auto_increment,
  `cat_id` smallint(5) unsigned NOT NULL default '0',
  `software_name` varchar(120) NOT NULL default '',
  `software_version` varchar(32) NOT NULL default '',
  `rel_software_id` varchar(255) NOT NULL default '',
  `click_count` int(10) unsigned NOT NULL default '0',
  `download_num` int(5) NOT NULL default '0',
  `seo_title` varchar(255) NOT NULL default '',
  `seo_keywords` varchar(255) NOT NULL default '',
  `seo_desc` varchar(255) NOT NULL default '',
  `software_brief` varchar(255) NOT NULL default '',
  `software_desc` text,
  `software_icon` varchar(255) NOT NULL default '',
  `software_list_image` varchar(255) NOT NULL default '',
  `os` varchar(256) NOT NULL default '',
  `size` varchar(32) NOT NULL default '',
  `price` varchar(32) NOT NULL default '',
  `requirements` varchar(255) NOT NULL default '',
  `license` varchar(64) NOT NULL default '',
  `limitations` varchar(64) NOT NULL default '',
  `developer` varchar(256) NOT NULL default '',
  `home_page` varchar(256) NOT NULL default '0',
  `add_time` int(10) unsigned NOT NULL default '0',
  `is_index_commend` tinyint(1) unsigned NOT NULL default '0',
  `is_cat_commend` tinyint(1) unsigned NOT NULL default '0',
  `is_channel_commend` tinyint(1) unsigned NOT NULL default '0',
  `is_elite_commend` tinyint(1) unsigned NOT NULL default '0',
  `last_update` int(10) unsigned NOT NULL default '0',
  `new_features` text,
  `downlink` varchar(512) NOT NULL default '',
  `buylink` varchar(512) NOT NULL default '',
  `is_stop` tinyint(1) NOT NULL default '0',
  `padlink` varchar(255) NOT NULL default '',
  `software_faq` text,
  PRIMARY KEY  (`software_id`),
  UNIQUE KEY `software_name_version` (`software_name`,`software_version`),
  KEY `cat_id` (`cat_id`),
  KEY `last_update` (`last_update`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

LOCK TABLES `{$db_pre}software` WRITE;
/*!40000 ALTER TABLE `{$db_pre}software` DISABLE KEYS */;
/*!40000 ALTER TABLE `{$db_pre}software` ENABLE KEYS */;
UNLOCK TABLES;


DROP TABLE IF EXISTS `{$db_pre}stats_software`;
CREATE TABLE `{$db_pre}stats_software` (
  `stats_soft_id` int(10) unsigned NOT NULL auto_increment,
  `software_id` mediumint(8) unsigned NOT NULL default '0',
  `visit_type` varchar(16) not null default '',
  `time_type`		varchar(16) not null default '',
  `time`		date not null default '0000-00-00',	
  `count` int(10) NOT NULL,
  PRIMARY KEY  (`stats_soft_id`),
  KEY `software_id` (`software_id`),
  UNIQUE KEY `unique_stats` (`software_id`,`visit_type`,`time_type`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

LOCK TABLES `{$db_pre}stats_software` WRITE;
/*!40000 ALTER TABLE `{$db_pre}stats_software` DISABLE KEYS */;
/*!40000 ALTER TABLE `{$db_pre}stats_software` ENABLE KEYS */;
UNLOCK TABLES;




DROP TABLE IF EXISTS `{$db_pre}stats`;
CREATE TABLE `{$db_pre}stats` (
  `access_time` int(10) unsigned NOT NULL default '0',
  `ip_address` varchar(15) NOT NULL,
  `visit_times` smallint(5) unsigned NOT NULL default '1',
  `browser` varchar(60) NOT NULL,
  `system` varchar(20) NOT NULL,
  `language` varchar(20) NOT NULL,
  `area` char(2) NOT NULL default '',
  `referer_domain` varchar(100) NOT NULL,
  `referer_path` varchar(200) NOT NULL,
  `keyword_id` smallint(5) unsigned NOT NULL default '0',
  `access_url` varchar(255) NOT NULL,
  `visit_software_id` mediumint(8) unsigned NOT NULL default '0',
  `visit_article_id` mediumint(8) unsigned NOT NULL default '0',
  KEY `access_time` (`access_time`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

LOCK TABLES `{$db_pre}stats` WRITE;
/*!40000 ALTER TABLE `{$db_pre}stats` DISABLE KEYS */;
/*!40000 ALTER TABLE `{$db_pre}stats` ENABLE KEYS */;
UNLOCK TABLES;





DROP TABLE IF EXISTS `{$db_pre}leave_word`;
CREATE TABLE `{$db_pre}leave_word` (
	`leave_word_id` mediumint(8) unsigned NOT NULL auto_increment,
	`name` varchar(128) NOT NULL default '',
	`email` varchar(128) NOT NULL default '',
	`type` tinyint(1) unsigned NOT NULL default '0',
	`content` text NOT NULL,
	`attachment` varchar(512) NOT NULL default '',
	`state` tinyint(1) unsigned NOT NULL default '0',
	`time` int(11) NOT NULL default '0',
	PRIMARY KEY  (`leave_word_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

LOCK TABLES `{$db_pre}leave_word` WRITE;
/*!40000 ALTER TABLE `{$db_pre}leave_word` DISABLE KEYS */;
/*!40000 ALTER TABLE `{$db_pre}leave_word` ENABLE KEYS */;
UNLOCK TABLES;

