<?
function to_tpl_variable($tpl_obj)
{

	$tpl_value_key	=		array(
		'site_name','site_desc','site_logo','site_keywords','site_title','site_external_link','site_book_mark','site_copyright','glo_this_is_here','glo_channel_res','glo_rss_xml','glo_this_channel','glo_channel_home_focus',
		'index_soft_res','soft_detail_res','art_detail_res','soft_img_arr','rel_article_res','soft_list_res','page_arr','support_article_res','art_detail_res','article_list_res',
		'list_type_url','is_attachment','leave_word_type',
		'glo_domain_name','glo_domain_directory',
	);
	foreach($tpl_value_key as 	$val){
		if($GLOBALS[$val]){
			$tpl_obj->out[$val]		=		$GLOBALS[$val];
			unset($GLOBALS[$val]);
		}
	}
	return $tpl_obj;
}


function parse_template($file)
{
	global $tpl_ex;

	meta_seo($file);
	format_this_here();

	require_once(ROOT_PATH.'includes/glo_template.php');
	$tpl_obj		=		new template;
	$tpl_obj->tpl->left_delimiter			=	'<!--{';
	$tpl_obj->tpl->right_delimiter 		=  '}-->';
	
	$seat_block_res	=	$tpl_ex->get_tpl_seat_block($file);
	if($seat_block_res){
		foreach($seat_block_res as $seat_key=>$seat_val){
			if(!$seat_val['block']){
				continue;
			}
			$tpl_variable	=	'TPL_'.strtoupper($seat_key);
			$tpl_string		=	'';
			foreach($seat_val['block'] as $block_key =>$block_val){
				$block_string		=	$block_val['is_open']?parse_system_block($block_val,$tpl_ex,$tpl_obj):'';
				if($tpl_ex->preview_seat_block_id==$block_val['seat_block_id']){
					$block_string		=		$tpl_ex->preview_block($block_string);
				}
				$tpl_string			.=	$block_string;
			}
			$tpl_obj->out[$tpl_variable]	=	$tpl_string;
		}
	}
	$tpl_obj		=		to_tpl_variable($tpl_obj);
	$tpl_obj->display($file);
}

function parse_system_block($block_val,$tpl_ex,$tpl_obj)
{
	$block_type		=		$block_val['block_type'];
	$block_setting	=		$block_val['block_setting'];
	$lib_file_dir	=		$tpl_ex->tpl_file_dir.'/lib/'.$block_val['lib_file'];
	if($block_val['block_type']=='custom'){
		return  parse_custom_block($block_val,$tpl_ex,$tpl_obj);
	}

	if(!is_file($lib_file_dir)){
		return false;
	}
	$is_export	=	false;
	switch($block_type){
		case 'soft_box':
				$soft_box		=		get_soft_box($block_setting['soft_box'],$block_val);
				if($soft_box){
					$is_export	=	true;
					$tpl_obj->out['soft_box']	=	$soft_box;
				}	
			break;

		case 'art_box':
				$art_box		=		get_art_box($block_setting['art_box'],$block_val);
				if($art_box){
					$is_export	=	true;
					$tpl_obj->out['art_box']	=	$art_box;
				}		
			break;			
	
		case 'soft_cat_box':
				$soft_cat_box	=	get_soft_cat_box($block_setting['soft_cat_box'],$block_val);
				if($soft_cat_box){
					$is_export	=	true;
					$tpl_obj->out['soft_cat_box']   =  $soft_cat_box;
				}
			break;		
	
		case 'art_cat_box':
				$art_cat_box	=	get_art_cat_box($block_setting['art_cat_box'],$block_val);
				if($art_cat_box){
					$is_export	=	true;
					$tpl_obj->out['art_cat_box']   =  $art_cat_box;
				}
			break;			
		
		case 'soft_faq':
				$soft_faq	=	get_soft_faq($block_setting['soft_faq'],$block_val);
				if($soft_faq){
					$is_export	=	true;
					$tpl_obj->out['soft_faq']   =  $soft_faq;
				}
			break;

		case 'soft_img_play':
				$soft_img_play	=	get_soft_img_play($block_setting['soft_faq'],$block_val);
				if($soft_img_play){
					$is_export	=	true;
					$tpl_obj->out['soft_img_play']   =  $soft_img_play;
				}
			break;

		case 'soft_desc':
				$soft_desc		=	get_soft_desc($block_setting['soft_desc'],$block_val);
				if($soft_desc){
					$is_export	=	true;
					$tpl_obj->out['soft_desc']   =  $soft_desc;
				}
			break;
	
		case 'soft_attr_info':
				$soft_attr_info		=	get_soft_attr_info($block_setting['soft_attr_info'],$block_val);
				if($soft_attr_info){
					$is_export	=	true;
					$tpl_obj->out['soft_attr_info']   =  $soft_attr_info;
				}
			break;	

		case 'related_soft':
				$related_soft		=	get_related_soft($block_setting['related_soft'],$block_val);
				if($related_soft){
					$is_export	=	true;
					$tpl_obj->out['related_soft']   =  $related_soft;
				}
			break;

		case	'released_history':
				$released_history	=	get_released_history($block_setting['released_history'],$block_val);
				if($released_history){
					$is_export	=	true;
					$tpl_obj->out['released_history']	=	$released_history;
				}
			break;
		
		case 'soft_features':
				$soft_features		=		get_soft_features($block_setting['soft_features'],$block_val);
				if($soft_features){
					$is_export	=	true;
					$tpl_obj->out['soft_features']	=	$soft_features;
				}
			break;
	}
	if($is_export){
		$tpl_obj->out['display_name']		=		htmlspecialchars($block_val['display_name'],ENT_QUOTES);
		$tpl_obj->out['block_icon']		=		dir_to_url($block_val['block_icon']);
		return $tpl_obj->fetch('lib/'.$block_val['lib_file']);
	}else{
		return '';
	}
}

function parse_custom_block($block_val,$tpl_ex,$tpl_obj)
{
		
		$lib_file_dir						=		$tpl_ex->tpl_file_dir.'/lib/'.$block_val['lib_file'];
		$tpl_obj->out['block_icon']	=		dir_to_url($block_val['block_icon']);
		if(is_file($lib_file_dir)){
			$tpl_obj->out['block_custom_data']	=	$block_val['block_custom_data'];
			$tpl_obj->out['display_name']		=		htmlspecialchars($block_val['display_name'],ENT_QUOTES);
			return $tpl_obj->fetch('lib/'.$block_val['lib_file']); 
		}else{
			return $block_val['block_custom_data'];
		}
}

function meta_seo($this_page)
{
	global $site_title,$site_keywords,$site_title,$site_name,$glo_category_obj;	
	
	$this_cat		=		$glo_category_obj->this_cat;
	
	switch($this_page){
		case 'index.html':
			break;
		case 'product.html':
		case 'download.html':
		case 'purchase.html':
				global $glo_this_channel,$soft_list_res;		
				
				$site_keywords	=  $glo_this_channel['seo_keywords']?$glo_this_channel['seo_keywords']:$site_keywords;
				$site_desc		=	$glo_this_channel['seo_desc']?$glo_this_channel['seo_desc']:$site_desc;
				$site_title		=	$glo_this_channel['seo_title']?$glo_this_channel['seo_title']:$site_title;
		
				if($this_cat){
					$site_keywords	.=	$this_cat['seo_keywords']?' '.$this_cat['seo_keywords']:'';
					$site_title		.=	$this_cat['cat_name']?' '.$this_cat['cat_name']:'';
					$site_desc		.=	$this_cat['seo_desc']?' '.$this_cat['seo_desc']:'';
				}

				if($soft_list_res){
					foreach($soft_list_res as $key=>$val){
						if($key<3){
							$site_title		.=	','.$val['software_name'];
						}
						if($key<4){
							$site_keywords	.=	','.$val['software_name'];
						}
						if($key<5){
							$site_desc		.=	','.$val['software_name'];
						}
					}	
				}
			break;
		case 'software.html':
			global $soft_detail_res;
				$site_keywords	=	$soft_detail_res['seo_keywords']?$soft_detail_res['seo_keywords']:$soft_detail_res['software_name'].' '.$soft_detail_res['software_version'];
				$site_desc		=	$soft_detail_res['seo_desc']?$soft_detail_res['seo_desc']:$soft_detail_res['software_brief'];
				$site_title		=	$soft_detail_res['seo_title']?$soft_detail_res['seo_title']:$soft_detail_res['software_name'].' '.$soft_detail_res['software_version'];
			break;

		case 'article.html':
				global $art_detail_res;	
				$site_keywords	=	$art_detail_res['seo_keywords']?$soft_detail_res['seo_keywords']:$art_detail_res['title'];
				$site_desc		=	$art_detail_res['seo_desc']?$art_detail_res['seo_desc']:$art_detail_res['title'];
				$site_title		=	$art_detail_res['seo_title']?$art_detail_res['seo_title']:$art_detail_res['title'];	
			break;

		case 'article_list.html':
		case 'about.html':
		case 'support.html':
		case 'channel.html':
				$site_keywords =  $glo_this_channel['seo_keywords']?$glo_this_channel['seo_keywords']:$site_keywords;
				$site_desc		=	$glo_this_channel['seo_desc']?$glo_this_channel['seo_desc']:$site_desc;
				$site_title		=	$glo_this_channel['seo_title']?$glo_this_channel['seo_title']:$site_title;
				if($this_cat){
					$site_keywords	=	$this_cat['seo_keywords']?' '.$this_cat['seo_keywords']:'';
					$site_title		=	$this_cat['cat_name']?' '.$this_cat['cat_name']:'';
					$site_desc		=	$this_cat['seo_desc']?' '.$this_cat['seo_desc']:'';
				}	
			break;
	}
	$site_title		.=	' - '.htmlspecialchars($site_name,ENT_QUOTES);
}

function format_this_here()
{
	global $glo_this_is_here;	
	foreach($glo_this_is_here as $key=>$val){
		$glo_this_is_here[$key]['name']		=	htmlspecialchars($val['name'],ENT_QUOTES);	
	}
}
