<?
function get_only_software_all_data($software_id)
{
	global $db_obj,$soft_detail_res,$glo_rss_xml,$soft_img_arr,$glo_only_software_id,$glo_config_arr;
	if($soft_detail_res&&$glo_only_software_id==$software_id){
		return $soft_detail_res;
	}

	$software_res			=		$db_obj->getRecords("SELECT a.*,b.image_id,b.image_path,b.image_path,b.image_thumb_path,b.image_thumb_path,b.image_bewrite,b.sort_order FROM {$db_obj->db_pre}software a LEFT JOIN {$db_obj->db_pre}images b ON a.software_id =b.software_id WHERE a.software_id=$software_id  AND a.is_stop=0 ORDER BY b.sort_order DESC");
	if(!$software_res){
		return false;
	}
	$software_res			=		format_software_list($software_res);

	$soft_detail_res		=		$software_res[0];
	$glo_rss_xml			=		'<link rel="alternate" type="application/rss+xml" title="'.$glo_config_arr['site_name']['value'].'" href="/rss.php?software_name='.rawurlencode($software_res[0]['software_name']).'">';
	
	if($software_res[0]['image_url']){
		$soft_img_arr				=		$software_res;
		foreach($soft_img_arr as $key=>$val){
			$soft_img_arr[$key]['bewrite']		=	htmlspecialchars($val['bewrite'],ENT_QUOTES);
		}	
	}	
	unset($software_res);	
	return $soft_detail_res;
}

function format_software_list($res,$is_version='auto',$name_length=100)
{
	if(!$res){
		return false;
	}
	foreach($res as $key=>$val){
		$res[$key]	=	format_software($val);
	}
	if($is_version=='auto'){
		$auto_version_arr	=	array();
		foreach($res as $key=> $val){
			if(!$auto_version_arr[$val['software_name']]){
						$auto_version_arr[$val['software_name']]	=	1;
			}else{
						$auto_version_arr[$val['software_name']]++;
			}
		}
	}
	foreach($res as $key=>$val){
		if($is_version=='auto'){
			if($auto_version_arr[$val['software_name']]>1){
				$val['display_name']	=	$val['software_name'].' '.$val['software_version'];
			}else{
				$val['display_name']	=	$val['software_name'];
			}
		}elseif($is_version=='no'){
			$val['display_name']		=	$val['software_name'];
		}else{
			$val['display_name']		=	$val['software_name'].' '.$val['software_version'];
		}
		$res[$key]['display_name']			=	htmlspecialchars(sub_str($val['display_name'],$name_length),ENT_QUOTES);
	}	
	
	return $res;	
}
function format_software($row)
{
	global $glo_config_arr,$_LANG;
	if($row['software_id']&&$row['software_name']&&$row['software_version']){

		$row['soft_url']						=		get_url('soft.php?software_id='.$row['software_id'],$row['software_name'].' '.$row['software_version']);
		$row['down_url']						=		"download_soft.php?download_url=".rawurlencode($row['downlink'])."&software_id=".$row['software_id'];
		$row['software_name']				=		htmlspecialchars($row['software_name'],ENT_QUOTES);
		$row['software_version']			=		htmlspecialchars($row['software_version'],ENT_QUOTES);
		$row['software_icon']				=		$row['software_icon']?dir_to_url($row['software_icon']):dir_to_url($glo_config_arr['default_icon']['value']);
		$row['software_list_image']		=		$row['software_list_image']?dir_to_url($row['software_list_image']):dir_to_url($glo_config_arr['list_thumb']['value']);
		$row['image_url']						=		dir_to_url($row['image_path']);
		$row['software_brief']				=		$row['software_brief']?nl2br(htmlspecialchars($row['software_brief'],ENT_QUOTES)):'';
		$row['license']						=		$row['license']?htmlspecialchars($row['license'],ENT_QUOTES):'';
		$row['size']							=		$row['size']?htmlspecialchars($row['size'],ENT_QUOTES):'';
		$row['os']								=		$row['os']?htmlspecialchars($row['os'],ENT_QUOTES):'';
		$row['requirements']					=		$row['requirements']?htmlspecialchars($row['requirements'],ENT_QUOTES):'';
		$row['limitations']					=		$row['limitations']?htmlspecialchars($row['limitations'],ENT_QUOTES):'';
		$row['developer']						=		$row['developer']?htmlspecialchars($row['developer'],ENT_QUOTES):'';
		$row['home_page']						=		$row['home_page']?htmlspecialchars($row['home_page'],ENT_QUOTES):'';
		$row['image_thumb_url']				=		$row['image_thumb_path']?dir_to_url($row['image_thumb_path']):dir_to_url($glo_config_arr['img_thumb']['value']);
		$row['new_features']					=		unserialize($row['new_features']);
		if($row['new_features']){
			foreach($row['new_features'] as $key=>$val){
				$row['new_features'][$key]		=	htmlspecialchars($val,ENT_QUOTES);
			}
		}
		
		$row['software_faq']					=		unserialize($row['software_faq']);
		if($row['software_faq']){
			foreach($row['software_faq'] as $key=>$val){
				$row[$key]['question']	=	nl2br(htmlspecialchars($val['question'],ENT_QUOTES));
				$row[$key]['answer']		=	nl2br(htmlspecialchars($val['answer'],ENT_QUOTES));
			}	
		}

		if(!$row['price']){
			$row['price']						=		$_LANG['free'];	
		}
		$row['display_name']					=		htmlspecialchars($row['software_name'].'  '.$row['software_version'],ENT_QUOTES);
	}
	return $row;	
}

function get_soft_box($setting,&$block_val)
{
	global $db_obj;
		$order_type		=	in_array($setting['order_type'],array('click_count','download_num','add_time','last_update'))?$setting['order_type']:'click_count';
		$order_time		=	in_array($setting['order_time'],array('all','month','week','day'))?$setting['order_time']:'all';
		$order_sort		=	in_array($setting['order_sort'],array('DESC','ASC'))?$setting['order_sort']:'DESC';
		$num				=	(int)$setting['num']?(int)$setting['num']:10;
		$name_length	=	(int)$setting['name_length']?(int)$setting['name_length']:50;
		$is_version		=	in_array($setting['is_version'],array('yes','no','auto'))?$setting['is_version']:'auto';
		$cat_id			=	(int)$setting['cat_id']?(int)$setting['cat_id']:($setting['cat_id']=='this_cat'?'this_cat':0);

		$sql			=		" SELECT a.software_name,a.software_version,a.software_id,a.click_count,a.download_num ";
		switch($order_type){
			case 'click_count':
			case 'download_num':
				if($order_time=='all'){
					$order_type_sql		=		" ORDER BY a.$order_type $order_sort";
				}else{
					$left_join_sql			=	" ,b.* FROM {$db_obj->db_pre}software LEFT JOIN {$db_obj->db_pre}stats_software ON a.software_id =b.softwrae_id AND b.visit_type='$order_type' AND time_type='$order_time'  WHERE a.is_stop=0 ";
					$order_type_sql		=		" ORDER BY b.count $order_sort";
				}				
				break;
			case 'add_time':
			case 'last_update':
					$order_type_sql		=		" ORDER BY a.$order_type $order_sort ";
				break;
		}
		if($left_join_sql){
			$sql	.= $left_join_sql;
		}else{
			$sql	.=	" FROM {$db_obj->db_pre}software a WHERE is_stop=0 ";
		}

		if($cat_id=='this_cat'){
				global $soft_detail_res;
				$cat_id	=	(int)$soft_detail_res['cat_id']?(int)$soft_detail_res['cat_id']:0;
		}	
		if($cat_id){
			global $glo_category_obj;
			if((int)$setting['is_catname']){
				$cat_arr		=	$glo_category_obj->recursion_category('software',$cat_id,true);
				$cat_id_str	=	$cat_arr['cat_id_str'];
				$block_val['display_name']	=	$cat_arr['cat_name'];
			}else{
				$cat_id_str	=	$glo_category_obj->recursion_category('software',$cat_id,false);
			}
			$sql	.=	" AND a.cat_id in ($cat_id_str) ";
		}
		
		if($type			=	$setting['type']){
			$sql	.=	" AND ( 1!=1  ";		
			if(in_array('is_index_commend',$type)){
				$sql.=" OR a.is_index_commend=1";
			}
			if(in_array('is_cat_commend',$type)){
				$sql	.=	" OR a.is_cat_commend=1 ";
			}
			if(in_array('is_channel_commend',$type)){
				$sql	.=	" OR a.is_channel_commend=1 ";
			}
			if(in_array('is_elite_commend',$type)){
				$sql	.=	" OR a.is_elite_commend=1 ";
			}
			if(in_array('is_common',$type)){
				$sql	.=	" OR (is_cat_commend=0  AND is_elite_commend=0 AND is_cat_commend=0 )";
			}
			$sql	.=	" ) ";		
		}

		$sql	.=	" $order_type_sql  LIMIT $num";
		
		$res	=		$db_obj->getRecords($sql);
		if($res){
			$res				=		format_software_list($res,$is_version,$name_length);
			return $res;
		}else{
			return false;
		}
}


function get_only_software_id()
{
	global $glo_config_arr,$db_obj;
	if(is_string($glo_config_arr['site_type']['value'])&&$glo_config_arr['site_type']['value']){
		if((int)$_GET['software_id']){
			$glo_only_software_id		=	(int)$_GET['software_id'];
		}else{
			$glo_only_software_id		=	$db_obj->getNumber("SELECT software_id FROM {$db_obj->db_pre}software WHERE software_name ='".$db_obj->escape($glo_config_arr['site_type']['value'])."' AND is_stop=0  ORDER BY software_version DESC LIMIT 1");	
		}
		if(!$glo_only_software_id){
			$res						=	$db_obj->getRecord("SELECT software_id,software_name FROM {$db_obj->db_pre}software WHERE is_stop=0  LIMIT 1");
			if($res){
				$glo_only_software_id	=	$res['software_id'];
				$db_obj->updateRecord("{$db_obj->db_pre}site_config"," name='site_type' ",array('value'=>$res['software_name']));
			}else{
				$glo_only_software_id	=	0;
			}
		}
	}else{
		$glo_only_software_id	=	0;
	}
	return $glo_only_software_id;
}

function get_soft_faq($setting,&$block_val)
{
	global $soft_detail_res;
	if(!$soft_detail_res){
		return false;
	}	
	$soft_faq		=	$soft_detail_res['software_faq'];	
	return $soft_faq;
}

function get_soft_img_play($setting,&$block_val)
{
	global 	$soft_img_arr;
	if($soft_img_arr){
		return $soft_img_arr;
	}else{
		return false;
	}

}

function get_soft_desc($setting,&$block_val)
{
	global $soft_detail_res;	
	$soft_desc		=		$soft_detail_res['software_desc'];
	return $soft_desc;
}

function get_soft_attr_info($setting,&$block_val)
{
	global $soft_detail_res;	
	if(!$soft_detail_res){
		return false;
	}
	$soft_attr_info	=	$soft_detail_res;
	return $soft_attr_info;
}

function get_related_soft($setting,&$block_val)
{
	global $db_obj,$soft_detail_res,$art_detail_res;
	$name_length		=		(int)$setting['name_length']?(int)$setting['name_length']:50;
	$is_version			=	in_array($setting['is_version'],array('yes','no','auto'))?$setting['is_version']:'auto';

	$rel_software_id		=		$soft_detail_res['rel_software_id']?$soft_detail_res['rel_software_id']:$art_detail_res['rel_software_id'];
	if($rel_software_id){
		$rel_soft_res			=		$db_obj->getRecords("SELECT software_brief,software_name,software_version,software_id FROM {$db_obj->db_pre}software WHERE software_id IN ({$soft_detail_res['rel_software_id']}) AND is_stop=0 AND software_id != {$soft_detail_res['software_id']}");	
		if($rel_soft_res){
			$rel_soft_res		=	format_software_list($rel_soft_res,$is_version,$name_length);	
			return $rel_soft_res;
		}else{
			return false;
		}
	}
}


function get_released_history($setting,&$block_val)
{
	global $soft_detail_res,$db_obj;
	$num			=		(int)$setting['num']?(int)$setting['num']:10;
	$released_history		=		$db_obj->getRecords("SELECT software_name,software_version,new_features,software_id,add_time,size FROM {$db_obj->db_pre}software WHERE software_name='".$db_obj->escape($soft_detail_res['software_name'])."'   AND is_stop=0  ORDER BY software_version DESC,add_time DESC  limit $num ");
	$released_history		=		format_software_list($released_history);
	return $released_history;	
}

function get_soft_features($setting,&$block_val)
{
		global $soft_detail_res;
		if($soft_detail_res){
			return $soft_detail_res['new_features'];
		}else{
			return false;
		}
}
