<?
require_once(ROOT_PATH.'includes/glo_template_extension.php');
class template_set extends action
{
	function select()
	{
		$tpl_ex				=		new template_ex($this->db);
		$list_tpl_arr		=		$tpl_ex->list_tpl();
		$this->init_tpl();
		$this->tpl->out['now_tpl']			=	$list_tpl_arr['now'];
		$this->tpl->out['other_tpl']		=	$list_tpl_arr['other'];
		
		$this->tpl->display("template_set.select.html");
	}

	function save_select()
	{
		global $_ADMIN_LANG;
		$tpl_dir		=	$_GET['tpl_dir'];
		$tpl_ex		=	new template_ex($this->db,$tpl_dir);
		if($_GET['reset']){
			$tpl_ex->uninstall_tpl();							
		}
			
		//install template
		if($tpl_ex->install_tpl()){
			$this->system_message($_ADMIN_LANG['template_installation_success'],'succeed',array($_ADMIN_LANG['preview']=>$this->domain_directory,$_ADMIN_LANG['enter_the_interface_of_template_settings']=>'index.php?act=template_set.settemplate'));
		}else{
			$this->system_message($_ADMIN_LANG['template_installation_failure'],'error',array($_ADMIN_LANG['return']=>'javascript:history.go(-1);'));
		}
	}

	function blockdlist()
	{
		$this->init_tpl();
		$block_res			=		$this->db->getRecords("SELECT block_name,block_type,update_time,block_id,lib_file FROM {$this->db->db_pre}blocks");
		$tpl_ex				=		new template_ex($this->db);
		$block_type_arr	=		$tpl_ex->get_block_type_arr();
		$block_type_res	=		array();
		if($block_res){
			foreach($block_res as $key=>$val){
				$block_type_res[$val['block_type']][]	=	$val;
			}
		}
		$this->tpl->out['block_type_arr']		=	$block_type_arr;	
		$this->tpl->out['block_type_res']		=	$block_type_res;
		$this->tpl->display("template_set.blockdlist.html");
	}


	function settemplate()
	{
		$this->init_tpl();
		global $_ADMIN_LANG;
		$tpl_ex				=		new template_ex($this->db);
		$tpl_config			=		$tpl_ex->tpl_config;
		$this->tpl->out['tpl_config']		=	$tpl_config;
		if(!($file=$_GET['file'])){
			$file	=	key($tpl_config['tpl_file_name']);	
			$_GET['file']	=	$file;
		}
		$seat_res		=	$tpl_ex->get_tpl_seat_block($file);

		$this->tpl->out['seat_res']				=	$seat_res;
		$this->tpl->out['block_type_arr']		=	$tpl_ex->get_block_type_arr();
		$this->tpl->out['tpl_to_url']				=			$tpl_ex->tpl_to_url($file);
		$this->tpl->out['default_block_res']	= 	$this->db->getRecords("SELECT block_name,block_id FROM {$this->db->db_pre}blocks WHERE block_type='".$this->db->escape(key($this->tpl->out['block_type_arr']))."'");	
		$this->tpl->display("template_set.settemplate.html");
	}

	function check_submit_block()
	{
		$tpl_ex				=		new template_ex($this->db);
		$block_type_arr	=		$tpl_ex->get_block_type_arr();
		if($soft_box	=	$_POST['soft_box']){
			$block_name			=	$soft_box['block_name'];
			$block_setting['soft_box']		=	array(
				'cat_id'			=>		$soft_box['cat_id'],
				'order_type'	=>		$soft_box['order_type'],
				'is_catname'	=>		(int)$soft_box['is_catname'],
				'order_sort'	=>		$soft_box['order_sort'],
				'order_time'	=>		$soft_box['order_time'],
				'type'			=>		$soft_box['type']?$soft_box['type']:array(),
				'is_version'	=>		$soft_box['is_version'],
				'num'				=>		$soft_box['num'],
				'name_length'	=>		$soft_box['name_length'],
			);	
			$block_type			=	'soft_box';
		}elseif($art_box	=	$_POST['art_box']){
			$block_name			=	$art_box['block_name'];
			$block_setting['art_box']		=	array(
				'cat_id'			=>		$art_box['cat_id'],
				'order_type'	=>		$art_box['order_type'],
				'is_catname'	=>		(int)$art_box['is_catname'],
				'type'			=>		$art_box['type']?$art_box['type']:array(),
				'num'				=>		$art_box['num'],
				'order_sort'	=>		$art_box['order_sort'],
				'name_length'	=>		$art_box['name_length'],
			);	
			$block_type			=	'art_box';
		}elseif($soft_cat_box =	$_POST['soft_cat_box']){
			$block_name			=	$soft_cat_box['block_name'];
			$block_setting['soft_cat_box']	=	array(
				'c_num'			=>		(int)$soft_cat_box['c_num'],
				'p_num'			=>		(int)$soft_cat_box['p_num'],
				'order_type'	=>		$soft_cat_box['order_type'],
				'order_sort'	=>		$soft_cat_box['order_sort'],
				'name_length'	=>		$soft_cat_box['name_length'],
				'is_softnum'	=>		(int)$soft_cat_box['is_softnum'],
			);
			$block_type			=	'soft_cat_box';
		}elseif($art_cat_box = $_POST['art_cat_box']){
			$block_name			=	$art_cat_box['block_name'];
			$block_setting['art_cat_box']	=	array(
				'c_num'			=>		(int)$art_cat_box['c_num'],
				'p_num'			=>		(int)$art_cat_box['p_num'],
				'order_type'	=>		$art_cat_box['order_type'],
				'order_sort'	=>		$art_cat_box['order_sort'],
				'name_length'	=>		$art_cat_box['name_length'],
				'is_artnum'		=>		(int)$art_cat_box['is_artnum'],
			);						
			$block_type			=	'art_cat_box';
		}elseif($soft_faq = $_POST['soft_faq']){
			$block_name			=	$soft_faq['block_name'];
			$block_setting['soft_faq']	=	array(
			);						
			$block_type			=	'soft_faq';
		}elseif($soft_img_play = $_POST['soft_img_play']){
			$block_name			=	$soft_img_play['block_name'];
			$block_setting['soft_img_play']	=	array(
			);						
			$block_type			=	'soft_img_play';
		}elseif($soft_desc = $_POST['soft_desc']){
			$block_name			=	$soft_desc['block_name'];
			$block_setting['soft_desc']	=	array(
			);						
			$block_type			=	'soft_desc';
		}elseif($soft_attr_info = $_POST['soft_attr_info']){
			$block_name			=	$soft_attr_info['block_name'];
			$block_setting['soft_attr_info']	=	array(
			);						
			$block_type			=	'soft_attr_info';
		}elseif($related_soft = $_POST['related_soft']){
			$block_name			=	$related_soft['block_name'];
			$block_setting['related_soft']	=	array(
				'is_version'	=>	$related_soft['is_version'],
				'name_length'	=>	$related_soft['name_length'],
			);						
			$block_type			=	'related_soft';
		}elseif($released_history 		= $_POST['released_history']){
			$block_name			=	$released_history['block_name'];
			$block_setting['released_history']	=	array(
				'num'		=>		(int)$released_history['num'],
			);						
			$block_type			=	'released_history';
		}elseif($soft_features 			= $_POST['soft_features']){
			$block_name			=	$soft_features['block_name'];
			$block_setting['soft_features']	=	array(
			);						
			$block_type			=	'soft_features';
		}elseif($custom 		= $_POST['custom']){
			$block_name			=	$custom['block_name'];
			$block_setting['soft_attr_info']	=	array(
			);						
			$block_type			=	'custom';
		}


		if(!$block_name){return false;}
			

		$lib_file			=		$_POST['lib_file']?$_POST['lib_file']:$block_type_arr[$block_type]['lib_file'];
		$display_name		=		$_POST['display_name'];
		$sql_data	=	array(
			'block_name'			=>	$block_name,
			'block_setting'		=>	storage_encode($block_setting),
			'update_time'			=>	time(),
			'block_type'			=>	$block_type,
			'lib_file'				=>	$lib_file,
			'block_custom_data'	=>	$_POST['block_custom_data'],
			'display_name'			=>	$display_name,
		);
		if($_FILES['block_icon']){
			require_once(ROOT_PATH.'includes/glo_images.php');
			$images_obj		=		 new glo_images;
			$file_arr	=	$_FILES['block_icon'];		
			$sql_data['block_icon']	=	$images_obj->upload_img($file_arr,'block_icon');
		}	
		return $sql_data;
	}
	
	function check_submit_settemplate()
	{
		$block_id	=	(int)$_POST['block_id'];
		$seat			=	$_POST['seat'];
		$file			=	$_POST['file'];
		if(!$block_id||!$seat||!$file){
			return false;
		}
		$tpl_ex				=		new template_ex($this->db);
		$sql_data	=	array(
			'block_id'	=>	$block_id,
			'is_open'	=>	(int)$_POST['is_open']?(int)$_POST['is_open']:1,
			'sort_order'=>	(int)$_POST['sort_order']?(int)$_POST['sort_order']:1,
			'tpl'			=>	$tpl_ex->now_tpl,	
			'file'		=>	$file,
			'seat'		=>	$seat,
			'update_time'	=>	time(),
		);
		return $sql_data;
	}

	function add_block_to_seat()
	{
		if(!$this->is_ajax){
			return false;
		}
		if(!$insert_arr	=	$this->check_submit_settemplate()){
			echo json_return('no');
			exit;
		}
		if($seat_block_id	=	$this->db->addRecord("{$this->db->db_pre}tpls",$insert_arr)){
			echo json_return(
					array(
						'time'			=>	date('Y-m-d H:i:s',time()),
						'seat_block_id'=>	$seat_block_id,
					)
			);
		}else{
			echo json_return('no');
		}
		exit;
	}


	function addblock()
	{
		global $_ADMIN_LANG;
		$this->init_tpl();
		$block_type			=		$_GET['block_type']?$_GET['block_type']:'soft_box';
		if($block_type=='custom'){
			create_html_editor('block_custom_data','',$this->tpl->tpl);
		}	
		$this->tpl->out['block_type']		=		$block_type;
		
		$tpl_ex				=		new template_ex($this->db);
		$block_type_arr	=		$tpl_ex->get_block_type_arr();
		$this->tpl->out['block_type_arr']		=	$block_type_arr;
		require_once(ROOT_PATH.'admin/includes/category.class.php');
		$category_obj		=		new category;	
		$this->tpl->out['soft_category_res']		=	$category_obj->get_category('software');	
		$this->tpl->out['art_category_res']		=	$category_obj->get_category('article');	
		
		$this->tpl->out['lib_file']	=		$block_type_arr[$block_type]['lib_file'];
		$this->tpl->out['lib_arr']		=		$tpl_ex->get_lib_file($block_type);

		$this->tpl->display("template_set.addblock.html");	
	}

	function save_addblock()
	{
		global $_ADMIN_LANG;
		if($_SERVER['REQUEST_METHOD']!='POST'){
			$this->addblock();
			return ;
		}	
		
		if(!($insert_arr=$this->check_submit_block())){
			$this->system_message($_ADMIN_LANG['adding_block_failure'],'error',array($_ADMIN_LANG['return']=>'javascript:history.go(-1);'));
			return;	
		}	
		$result	=	$this->db->addRecord("{$this->db->db_pre}blocks",$insert_arr);
		if($result){
			$this->system_message($_ADMIN_LANG['adding_block_success'],'succeed',array(
				$_ADMIN_LANG['templates_settings']=>'index.php?act=template_set.settemplate&file='.rawurlencode($_GET['file']),
				$_ADMIN_LANG['continue_adding']=>'index.php?act=template_set.addblock&file='.rawurlencode($_GET['file']))
			);
		}else{
			$this->system_message($_ADMIN_LANG['adding_block_failure'],'error',array($_ADMIN_LANG['return']=>'javascript:history.go(-1);'));
			return;
		}	
	}

	function del_block($block_id='')
	{
		if($this->is_ajax){
			$block_id	=	(int)$_GET['block_id'];
		}
		if(!$block_id){
			return false;
		}
		$result	=	$this->db->deleteRecord("{$this->db->db_pre}blocks "," block_id=$block_id ");
		if($result){
			$this->db->deleteRecord("{$this->db->db_pre}tpls","block_id=$block_id");
			if($this->is_ajax){
				echo json_return("ok"); 
				exit;
			}
		}else{
			return false;	
		}

	}
	function handle_seat_block($handle=array(),$seat_block_id='')
	{
		if($this->is_ajax){
			$seat_block_id	=	(int)$_GET['seat_block_id'];
			$handle			=	$_POST['handle'];
		}
		if(!$handle||!$seat_block_id){
			return false;
		}
		$handle_sql_data	=	array();
		foreach($handle as $key=>$val){
			if($key=='delete'){
				if($this->db->deleteRecord("{$this->db->db_pre}tpls", "seat_block_id = $seat_block_id ")){
					if($this->is_ajax){
						echo json_return('ok');exit;
					}
				}else{
					if($this->is_ajax){
						echo json_return('no');exit;
					}
				}
			}else{
				$handle_sql_data[str_replace('`','',$key)]	=	$val;
			}
		}
		$result	=	$this->db->updateRecord("{$this->db->db_pre}tpls"," seat_block_id =$seat_block_id ",$handle_sql_data);
		if($this->is_ajax){
			if($result){
				echo json_return('ok');exit;
			}else{
				echo json_return('no');exit;
			}
		}	
		return $result;
	}

	function edit_block()
	{
		$this->init_tpl();
		global $_ADMIN_LANG;
		$tpl_ex						=	new template_ex($this->db);
		$block_id					=		(int)$_GET['block_id'];
		$block_data					=		$this->db->getRecord("SELECT a.*  FROM {$this->db->db_pre}blocks a LEFT JOIN {$this->db->db_pre}tpls b ON a.block_id=b.block_id   WHERE a.block_id=$block_id  limit 1");
		$block_data['block_icon']		=	dir_to_url($block_data['block_icon']);

		$block_data['block_setting']	=	storage_dencode($block_data['block_setting']);
		if($block_data['block_type']=='custom'){
			create_html_editor('block_custom_data',$block_data['block_custom_data'],$this->tpl->tpl);
		}
		require_once(ROOT_PATH.'admin/includes/category.class.php');
		$category_obj		=		new category;	
		$this->tpl->out['soft_category_res']		=	$category_obj->get_category('software');	
		$this->tpl->out['art_category_res']		=	$category_obj->get_category('article');	
		
		$this->tpl->out['block_type']				=	$block_data['block_type'];
		$this->tpl->out['block_data']				=	$block_data;
		$this->tpl->out['lib_file']				=	$block_data['lib_file'];
		$this->tpl->out['lib_arr']					=	$tpl_ex->get_lib_file($block_data['block_type']);
		$this->tpl->display("template_set.edit_block.html");
	}

	function lib_file_content()
	{
		if(!$this->is_ajax||!$lib_file=$_GET['lib_file']){
			return false;	
		}
		$tpl_ex				=		new template_ex($this->db);
		$lib_file_dir									=	$tpl_ex->tpl_file_dir.'/lib/'.$lib_file;
		$lib_file_content		=	is_file($lib_file_dir)?file_get_contents($lib_file_dir):'';
		$can_edit				=	file_mode_info($lib_file_dir)==1111;
		echo json_return(
			array(
				'lib_file_content'	=>$lib_file_content,
				'can_edit'				=>	$can_edit,	
				'lib_file_dir'			=>	$lib_file_dir,
			)		
		);
	}
	
	function save_add_lib_file_content()
	{
		$lib_file_name				=	get_basename($_POST['lib_file_name']);
		$add_lib_file_content	=	$_POST['add_lib_file_content'];
		$block_type					=	get_basename($_GET['block_type']);	
		if($this->is_ajax&&$lib_file_name&&$add_lib_file_content&&$block_type){
			$tpl_ex				=	new template_ex($this->db);
			$lib_dir				=	$tpl_ex->tpl_file_dir.'/lib/'.$block_type;
			if(!is_dir($lib_dir)){
				return false;
			}
			$can_edit			=	file_mode_info($lib_dir)==1111;
			if(!$can_edit){
				echo json_return(array(
					'can_edit'	=>	$can_edit,
					'lib_dir'	=>	 $lib_dir,
					'result'		=>	'no',
				));
				exit;
			}
			$file					=	substr(md5($lib_file_name),0,5).'.html';
			$lib_file_dir		=	$lib_dir.'/'.$file;
			if(is_file($lib_file_dir)){
				echo json_return(array(
					'can_edit'	=>	1,
					'result'		=>	'no',
					'exist'		=>	1,
				));
				exit;	
			}
			
			$add_lib_file_content		=		"<!--{*'.$lib_file_name.'*}-->\n".$add_lib_file_content;
			if(file_put_contents($lib_file_dir,$add_lib_file_content)){
				@chmod($lib_file_dir, 0777);	
				echo json_return(array(
					'can_edit'		=>	$can_edit,
					'lib_file'		=>	 $block_type.'/'.$file,
					'result'		=>	'yes',
				));
				exit;
			}		
		}else{
			return false;
		}
	}


	function save_lib_file_content()
	{
		if(!$this->is_ajax||!$lib_file=$_GET['lib_file']){
			return false;	
		}	
		$tpl_ex				=	new template_ex($this->db);
		$lib_file_dir		=	$tpl_ex->tpl_file_dir.'/lib/'.$lib_file;
		if(!is_file($lib_file_dir)){
			echo json_return('no');exit;
		}
		$can_edit			=	file_mode_info($lib_file_dir)==1111;
		if(!$can_edit){
			echo json_return('no');exit;
		}
		$lib_file_content	=	$_POST['lib_file_content'];
		if(file_put_contents($lib_file_dir,$lib_file_content)){
			echo json_return('ok');
		}else{
			echo json_return('no');
		}
	}

	function save_edit_block()
	{
		global $_ADMIN_LANG;
		$block_id	=	(int)$_GET['block_id'];
		if($_SERVER['REQUEST_METHOD']!='POST'&&!$block_id){
			$this->addblock();
			return ;
		}	
		if(!$update_arr	=	$this->check_submit_block()){
			$this->system_message($_ADMIN_LANG['edit_block_failure'],'error',array(
				$_ADMIN_LANG['continue_modification']=>'index.php?act=template_set.edit_block&block_id='.$block_id));	
		}
		$cond	=	" block_id = $block_id";
		if($this->db->updateRecord("{$this->db->db_pre}blocks",$cond,$update_arr)){
			$this->system_message($_ADMIN_LANG['edit_block_success'],'succeed',array(
				$_ADMIN_LANG['continue_modification']=>'index.php?act=template_set.edit_block&block_id='.$block_id));
		}else{
			$this->system_message($_ADMIN_LANG['edit_block_failure'],'error',array(
				$_ADMIN_LANG['return']=>'index.php?act=template_set.edit_block&block_id='.$block_id));	
		}

	}

	function get_type_block()
	{
		if((!$block_type		=		$_GET['block_type'])||!$this->is_ajax){
			return false;
		}
		$res	=	$this->db->getRecords("SELECT block_name,block_id FROM {$this->db->db_pre}blocks WHERE block_type='".$this->db->escape($block_type)."'");
		if($res){
			echo json_return($res);
		}else{
			echo json_return(array());
		}
		exit;
	}

	function dump_install_file()
	{
		global $glo_domain_name,$glo_domain_directory;
		$tpl_ex				=		new template_ex($this->db);
		$data			=		$this->db->getRecords("SELECT * FROM {$this->db->db_pre}blocks a LEFT JOIN {$this->db->db_pre}tpls b ON a.block_id=b.block_id WHERE b.tpl='".$this->db->escape($tpl_ex->now_tpl)."'");
		foreach($data as $key=>$val){
			$dump_data['tpl_block'][$key]['tpls']	=	array(
				'file'	=>	$val['file'],
				'seat'	=>	$val['seat'],
				'sort_order'	=>	$val['sort_order'],
				'is_open'	=>	$val['is_open'],
			);
			$dump_data['tpl_block'][$key]['blocks']	=	array(
				'block_name'		=>		$val['block_name'],
				'display_name'		=>		$val['display_name'],
				'block_icon'		=>		dir_to_url($val['block_icon']),
				'lib_file'			=>		$val['lib_file'],
				'block_type'		=>		$val['block_type'],
				'block_setting'	=>		$val['block_setting'],
				'block_custom_data'=>	$val['block_custom_data'],
			);
		}
		$list_thumb			=		$this->db->getRecord(" SELECT * FROM {$this->db->db_pre}site_config WHERE name='list_thumb' ");	
		$site_logo			=		$this->db->getRecord(" SELECT * FROM {$this->db->db_pre}site_config WHERE name='site_logo' ");
		$img_thumb			=		$this->db->getRecord("SELECT * FROM {$this->db->db_pre}site_config WHERE name='img_thumb' ");
		$glo_proscenium_lang		=	$this->db->getRecord("SELECT * FROM {$this->db->db_pre}site_config WHERE name='glo_proscenium_lang'");
		$default_icon		=		$this->db->getRecord(" SELECT * FROM {$this->db->db_pre}site_config WHERE name='default_icon' ");

		$dump_data['site_config'][]	=	array(
			'name'		=>	'list_thumb',
			'data'		=>	array(
					'image_size'	=>	$list_thumb['image_size'],
					'value'			=>	dir_to_url($list_thumb['value']),
				)
		);
		$dump_data['site_config'][]	=	array(
			'name'		=>	'img_thumb'	,
			'data'		=>	array(
				'image_size'	=>	$img_thumb['image_size'],
				'value'			=>	dir_to_url($img_thumb['value']),
			),
		);
		$dump_data['site_config'][]	=	array(
			'name'		=>	'glo_proscenium_lang',
			'data'		=>	array(
					'value'	=>	$glo_proscenium_lang['value'],
			),		
		);
		$dump_data['site_config'][]	=	array(
			'name'		=>	'default_icon',
			'data'		=>	array(
				'value'	=>	dir_to_url($default_icon['value']),
			),		
		);
		$dump_data['site_config'][]	=	array(
			'name'		=>	'site_logo',
			'data'		=>	array(
				'image_size'	=>	$site_logo['image_size'],
				'value'			=>	dir_to_url($site_logo['value']),
			),		
		);

		$channel_data	=	$this->db->getRecords("SELECT * FROM {$this->db->db_pre}channel");
		foreach($channel_data as $key=>$val){
			$dump_data['channel_data'][$key]	=	array(
				'cond'	=>	' channel_id = '.$val['channel_id'],	
				'data'	=>	array(
						'channel_name'	=>	$val['channel_name'],
						'is_open'		=>	$val['is_open'],
					)		
			);
		}			
		$filename			=		'install_data';	
		header("Content-Type: application/force-download");
		header("Content-Disposition: attachment; filename=".basename($filename));  
		echo storage_encode($dump_data);exit;		
	}

	function del_block_icon()
	{
		$block_id		=	(int)$_GET['block_id'];
		if(!$block_id&&!$this->is_ajax){
			return false;
		}
		$block_icon		=	$this->db->getString("SELECT block_icon FROM {$this->db->db_pre}blocks WHERE block_id=$block_id");
		if($block_icon){
			$block_icon_dir		=		UPLOAD_DIR.$block_icon_dir;	
			@unlink($block_icon_dir);	
			$this->db->updateRecord("{$this->db->db_pre}blocks"," block_id=$block_id ",array('block_icon'=>''));
		}
		echo json_return('ok');
	}

}
