Base 系列编码
================

## Base16

使用16个ASCII可打印字符（数字0-9和字母A-F），对任意字节数据进行编码。

先获取输入字符串每个字节的二进制值（不足8比特在高位补0），然后将其串联进来，再按照4比特一组进行切分，将每组二进制数分别转换成十进制。
    　 
Base16编码后的数据量是原数据的两倍：1000比特数据需要250个字符（即 250*8=2000 比特）。


## Base32
 
Base32编码是使用32个可打印字符（字母A-Z和数字2-7）对任意字节数据进行编码的方案，编码后的字符串不用区分大小写并排除了容易混淆的字符，可以方便地由人类使用并由计算机处理。

Base32主要用于编码二进制数据，但是Base32也能够编码诸如ASCII之类的二进制文本。
       
       
Base32将任意字符串按照字节进行切分，并将每个字节对应的二进制值（不足8比特高位补0）串联起来，按照5比特一组进行切分，并将每组二进制值转换成十进制来对应32个可打印字符中的一个。


## Base64

Base64是一种基于64个可打印字符来表示二进制数据的表示方法。由于，所以每6个比特为一个单元，对应某个可打印字符。3个字节有24个比特，对应于4个Base64单元，即3个字节可由4个可打印字符来表示。
       
在Base64中的可打印字符包括字母A-Z、a-z、数字0-9，这样共有62个字符，此外两个可打印符号在不同的系统中而不同。一些如uuencode的其他编码方法。
       
它可用来作为电子邮件的传输编码。
        
Base64常用于在通常处理文本数据的场合，表示、传输、存储一些二进制数据，包括MIME的电子邮件及XML的一些复杂数据。

## Base36
 
 
Base36是一个二进制到文本编码表示方案的二进制数据以ASCII通过将其转化为一个字符串格式基数 -36表示。选择36十分方便，因为可以使用阿拉伯数字 0–9和拉丁字母 A–Z（ISO基本拉丁字母）表示数字。

每个base36位需要少于6位的信息来表示。

## Base85
Base85 也称为Ascii85，是Paul E. Rutter为btoa实用程序开发的一种二进制文本编码形式。通过使用五个ASCII字符来表示四个字节的二进制数据（使编码量1 / 4比原来大，假设每ASCII字符8个比特），它比更有效UUENCODE或Base64的，它使用四个字符来表示三个字节的数据（1 / 3的增加，假设每ASCII字符8个比特）。

用途是Adobe的PostScript和Portable Document Format文件格式，以及Git使用的二进制文件的补丁编码。
            
与Base64一样，Base85编码的目标是对二进制数据可打印的ASCII字符进行编码。但是它使用了更大的字符集，因此效率更高一些。具体来说，它可以用5个字符编码4个字节（32位）。



## Base58
 
Base58是用于Bitcoin中使用的一种独特的编码方式，主要用于产生Bitcoin的钱包地址。
            
相比Base64，Base58不使用数字"0"，字母大写"O"，字母大写"I"，和字母小写"l"，以及"+"和"/"符号。
　　
设计Base58主要的目的是：
 * 避免混淆。在某些字体下，数字0和字母大写O，以及字母大写I和字母小写l会非常相似。
 * 不使用"+"和"/"的原因是非字母或数字的字符串作为帐号较难被接受。
 * 没有标点符号，通常不会被从中间分行。
 * 大部分的软件支持双击选择整个字符串。


## Base91
 
顾名思义，Base91需要91个字符来表示ASCII编码的二进制数据。 从94个可打印ASCII字符（0x21-0x7E）中，以下三个字符被省略以构建basE91字母： 
 * -（破折号，0x2D）
 * \（反斜杠，0x5C）
 * '（撇号，0x27）

Base91是将二进制数据编码为ASCII字符的高级方法。 它类似于UUencode或base64，但效率更高。 basE91产生的开销取决于输入数据。 它的数量最多为23％（而base64为33％），范围可以降低到14％，通常发生在0字节块上。这使得basE91对于通过二进制不安全连接（例如电子邮件或终端线）传输较大的文件非常有用。


## Base62

Base62编码将数字转换为ASCII字符串（0-9，az和AZ），反之亦然，这通常会导致字符串较短。

26个小写字母+26个大写字母+10个数字=62
