/*
https://sourceforge.net/projects/azureus/files/vuze/Vuze_5750/Vuze_5750_Installer32.exe/download
https://sourceforge.net/projects/azureus/files/vuze/Vuze_5750/Vuze_5750_Installer64.exe/download

Run packAzureus.bat before compiling
*/
!define DLVER	"5.7.5.0"
!define APPVER 	"0.0.0.0"
!define APPSIZE	"22200" # kB
!define APPNAME "Azureus"
!define APP 	"Azureus"
!define DLNAME	"Azureus"
!define APPLANG	"32-64-bit_Multilingual"
!define FOLDER	"AzureusPortable"
!define FINISHRUN
!define SOURCES
; !define DESCRIPTION	"Bittorrent Client"

SetCompressor /SOLID lzma
SetCompressorDictSize 32

!include "..\_Include\Installer.nsh"

!insertmacro MUI_LANGUAGE "English"
!insertmacro MUI_LANGUAGE "French"

Section "${APPNAME} Portable" main
SectionIn RO
	SetOutPath "$INSTDIR"
		File "..\..\..\${FOLDER}\${APP}Portable.exe"
	SetOutPath "$INSTDIR\App\${APP}"
		File /r  /x Azureus2.jar  /x swt.jar  /x swt_64.jar "..\..\..\${FOLDER}\App\${APP}\*.*"
		File "Azureus2.gz"
		File "swt.gz"
		File "swt_64.gz"
		File "..\..\..\CommonFiles\Java\bin\unpack200.exe"
		File "..\..\..\CommonFiles\Java\bin\unpack.dll"
		File "..\..\..\CommonFiles\Java\bin\msvcr100.dll"
	ExecDOS::exec '"$INSTDIR\App\${APP}\unpack200.exe" -r -q "$INSTDIR\App\${APP}\Azureus2.gz" "$INSTDIR\App\${APP}\Azureus2.jar"' "" ""
	Pop $R0
	ExecDOS::exec '"$INSTDIR\App\${APP}\unpack200.exe" -r -q "$INSTDIR\App\${APP}\swt.gz" "$INSTDIR\App\${APP}\swt.jar"' "" ""
	Pop $R0
	ExecDOS::exec '"$INSTDIR\App\${APP}\unpack200.exe" -r -q "$INSTDIR\App\${APP}\swt_64.gz" "$INSTDIR\App\${APP}\swt_64.jar"' "" ""
	Pop $R0
	Delete "$INSTDIR\App\${APP}\unpack200.exe"
	Delete "$INSTDIR\App\${APP}\unpack.dll"
	Delete "$INSTDIR\App\${APP}\msvcr100.dll"

!ifdef DESCRIPTION
Call AppInfo
!endif
!ifdef SOURCES
Call Sources
	SetOutPath "$INSTDIR\Other\Source"
	File "packAzureus.bat"
	File "azureus.config"

!endif
!ifdef SOURCES & DESCRIPTION
Call SourceInfo
!endif

SectionEnd
