/*
https://wiki.vuze.com/w/Configuration_directory
*/
; **************************************************************************
; === Define constants ===
; **************************************************************************
!define VER 		"0.0.0.0"	; version of launcher
!define APPNAME 	"Azureus"	; complete name of program
!define APP 		"Azureus"	; short name of program without space and accent  this one is used for the final executable an in the directory structure
!define APPEXE 		"Azureus.exe"	; main exe name
!define APPDIR 		"App\Azureus"	; main exe relative path
!define APPSWITCH 	``	; some default Parameters

; --- Define RegKeys ---
	!define REGKEY1 "HKEY_LOCAL_MACHINE\SOFTWARE\ej-technologies"
	!define REGKEY2 "HKEY_LOCAL_MACHINE\SOFTWARE\Azureus"
	!define REGKEY3 "HKEY_LOCAL_MACHINE\SOFTWARE\Classes\.bctpuri"
	!define REGKEY4 "HKEY_LOCAL_MACHINE\SOFTWARE\Classes\.bcuri"
	!define REGKEY5 "HKEY_LOCAL_MACHINE\SOFTWARE\Classes\.dht"
	!define REGKEY6 "HKEY_LOCAL_MACHINE\SOFTWARE\Classes\.magnet"
	!define REGKEY7 "HKEY_LOCAL_MACHINE\SOFTWARE\Classes\.torrent"
	!define REGKEY8 "HKEY_LOCAL_MACHINE\SOFTWARE\Classes\.vuze"
	!define REGKEY9 "HKEY_LOCAL_MACHINE\SOFTWARE\Classes\Azureus"
	!define REGKEY10 "HKEY_LOCAL_MACHINE\SOFTWARE\Classes\BCTP"
	!define REGKEY11 "HKEY_LOCAL_MACHINE\SOFTWARE\Classes\BC"
	!define REGKEY12 "HKEY_LOCAL_MACHINE\SOFTWARE\Classes\DHT"
	!define REGKEY13 "HKEY_LOCAL_MACHINE\SOFTWARE\Classes\MIME\Database\Content Type\application/x-bc-uri"
	!define REGKEY14 "HKEY_LOCAL_MACHINE\SOFTWARE\Classes\MIME\Database\Content Type\application/x-bctp-uri"
	!define REGKEY15 "HKEY_LOCAL_MACHINE\SOFTWARE\Classes\MIME\Database\Content Type\application/x-bittorrent"
	!define REGKEY16 "HKEY_LOCAL_MACHINE\SOFTWARE\Classes\MIME\Database\Content Type\application/x-dht"
	!define REGKEY17 "HKEY_LOCAL_MACHINE\SOFTWARE\Classes\MIME\Database\Content Type\application/x-magnet"
	!define REGKEY18 "HKEY_LOCAL_MACHINE\SOFTWARE\Classes\MIME\Database\Content Type\application/x-vuze"
	!define REGKEY19 "HKEY_LOCAL_MACHINE\SOFTWARE\Classes\Magnet"
	!define REGKEY20 "HKEY_LOCAL_MACHINE\SOFTWARE\Classes\Vuze"
	!define REGKEY21 "HKEY_LOCAL_MACHINE\SOFTWARE\magnet\Handlers"
	!define REGKEY22 "HKEY_LOCAL_MACHINE\SOFTWARE\magnet"
	!define REGKEY23 "HKEY_CURRENT_USER\Software\Azureus"
	!define REGKEY24 "HKEY_CURRENT_USER\Software\Classes\.bctpuri"
	!define REGKEY25 "HKEY_CURRENT_USER\Software\Classes\.bcuri"
	!define REGKEY26 "HKEY_CURRENT_USER\Software\Classes\.dht"
	!define REGKEY27 "HKEY_CURRENT_USER\Software\Classes\.magnet"
	!define REGKEY28 "HKEY_CURRENT_USER\Software\Classes\.vuze"
	!define REGKEY29 "HKEY_CURRENT_USER\Software\Classes\BCTP"
	!define REGKEY30 "HKEY_CURRENT_USER\Software\Classes\BC"
	!define REGKEY31 "HKEY_CURRENT_USER\Software\Classes\DHT"
	!define REGKEY32 "HKEY_CURRENT_USER\Software\Classes\MIME\Database\Content Type\application/x-bc-uri"
	!define REGKEY33 "HKEY_CURRENT_USER\Software\Classes\MIME\Database\Content Type\application/x-bctp-uri"
	!define REGKEY34 "HKEY_CURRENT_USER\Software\Classes\MIME\Database\Content Type\application/x-dht"
	!define REGKEY35 "HKEY_CURRENT_USER\Software\Classes\MIME\Database\Content Type\application/x-magnet"
	!define REGKEY36 "HKEY_CURRENT_USER\Software\Classes\MIME\Database\Content Type\application/x-vuze"
	!define REGKEY37 "HKEY_CURRENT_USER\Software\Classes\Magnet"
	!define REGKEY38 "HKEY_CURRENT_USER\Software\Classes\Vuze"
	!define REGKEY39 "HKEY_CURRENT_USER\Software\ej-technologies"
	!define REGKEY40 "HKEY_CURRENT_USER\Software\Classes\.torrent"
	!define REGKEY41 "HKEY_CURRENT_USER\Software\Classes\Azureus"
	!define REGKEY42 "HKEY_CURRENT_USER\Software\Classes\MIME\Database\Content Type"

; ---Define Local Dirs, SubDirs (if any) beginnig with back-slash and Portable Dirs ---
	!define LOCALDIR1 "$PROFILE\.swt"
	!define SUBDIR1 ""

; **************************************************************************
; === Best Compression ===
; **************************************************************************
SetCompressor /SOLID lzma
SetCompressorDictSize 32

; **************************************************************************
; === Includes ===
; **************************************************************************
!include "..\_Include\Launcher.nsh" 
!include "TextReplace.nsh"
!include "LogicLib.nsh"
!include "x64.nsh"

; **************************************************************************
; === Set basic information ===
; **************************************************************************
Name "${APPNAME} Portable"
OutFile "..\..\..\${APP}Portable\${APP}Portable.exe"
Icon "${APP}.ico"

; **************************************************************************
; === Other Actions ===
; **************************************************************************
Var PARENTDIR
Var JAVAHOME
Function Java
${GetParent} $EXEDIR $PARENTDIR
${If} ${RunningX64}
${AndIf} ${FileExists} "$PARENTDIR\CommonFiles\Java_64\bin\javaw.exe"
StrCpy $JAVAHOME "$PARENTDIR\CommonFiles\Java_64"
Goto JavaFound
${ElseIf} ${RunningX64}
${AndIf} ${FileExists} "$PARENTDIR\CommonFiles\Java64\bin\javaw.exe"
StrCpy $JAVAHOME "$PARENTDIR\CommonFiles\Java64"
Goto JavaFound
${ElseIf} ${FileExists} "$PARENTDIR\CommonFiles\Java\bin\javaw.exe"
StrCpy $JAVAHOME "$PARENTDIR\CommonFiles\Java"
Goto JavaFound
${EndIf}
SetRegView 64
ReadRegStr $0 HKEY_LOCAL_MACHINE "SOFTWARE\JavaSoft\Java Runtime Environment" "CurrentVersion"
ReadRegStr $1 HKEY_LOCAL_MACHINE "SOFTWARE\JavaSoft\Java Runtime Environment\$0" "JavaHome"
StrCpy $JAVAHOME $1
IfFileExists "$JAVAHOME\bin\javaw.exe" JavaFound
MessageBox MB_ICONSTOP "Java Runtime Environment Portable or Installed not found!"
Abort
JavaFound:
System::Call 'Kernel32::SetEnvironmentVariableA(t, t) i("EXE4J_JAVA_HOME", "$JAVAHOME").r0'

${If} ${RunningX64}
Rename "$EXEDIR\${APPDIR}\Azureus.exe" "$EXEDIR\${APPDIR}\Azureus_32.exe"
Rename "$EXEDIR\${APPDIR}\AzureusUpdater.exe" "$EXEDIR\${APPDIR}\AzureusUpdater_32.exe"
Rename "$EXEDIR\${APPDIR}\swt.jar" "$EXEDIR\${APPDIR}\swt_32.jar"
Rename "$EXEDIR\${APPDIR}\Azureus_64.exe" "$EXEDIR\${APPDIR}\Azureus.exe"
Rename "$EXEDIR\${APPDIR}\AzureusUpdater_64.exe" "$EXEDIR\${APPDIR}\AzureusUpdater.exe"
Rename "$EXEDIR\${APPDIR}\swt_64.jar" "$EXEDIR\${APPDIR}\swt.jar"
${Else}
${EndIf}

FunctionEnd

Var DOWNLOADSPATH
Var TORRENTSPATH
Var DOWNLOADSPATHLENGTH
Var TORRENTSPATHLENGTH
Function Init

nsisFirewall::AddAuthorizedApplication "$EXEDIR\${APPDIR}\${APPEXE}" "${APPNAME} Portable"

${If} ${FileExists} "$EXEDIR\Data\${APP}\azureus.config"
ReadINIStr $0 "$EXEDIR\Data\${APP}Portable.ini" "${APP}Portable" "LastDirectory"
StrCpy $1 $0 3
StrCpy $2 $EXEDIR 3
StrCmp $1 $2 +3
	${textreplace::ReplaceInFile} "$EXEDIR\Data\${APP}\azureus.config" "$EXEDIR\Data\${APP}\azureus.config" "$1" "$2" "" $0
	${textreplace::Unload}
${Else}
	SetOutPath "$EXEDIR\Data\${APP}"
	File "azureus.config"

	StrCpy $DOWNLOADSPATH "$EXEDIR\Downloads"
	StrCpy $TORRENTSPATH "$EXEDIR\Torrents"
	StrLen $DOWNLOADSPATHLENGTH "$DOWNLOADSPATH"
	StrLen $TORRENTSPATHLENGTH "$TORRENTSPATH"

	CreateDirectory "$DOWNLOADSPATH"
	CreateDirectory "$TORRENTSPATH"

	${textreplace::ReplaceInFile} "$EXEDIR\Data\${APP}\azureus.config" "$EXEDIR\Data\${APP}\azureus.config" "DownloadsPath" "$DOWNLOADSPATH" "" $0
	${textreplace::ReplaceInFile} "$EXEDIR\Data\${APP}\azureus.config" "$EXEDIR\Data\${APP}\azureus.config" "TorrentsPath" "$TORRENTSPATH" "" $0
	${textreplace::ReplaceInFile} "$EXEDIR\Data\${APP}\azureus.config" "$EXEDIR\Data\${APP}\azureus.config" "Default save path13" "Default save path$DOWNLOADSPATHLENGTH" "" $0
	${textreplace::ReplaceInFile} "$EXEDIR\Data\${APP}\azureus.config" "$EXEDIR\Data\${APP}\azureus.config" "General_sDefaultTorrent_Directory12" "General_sDefaultTorrent_Directory$TORRENTSPATHLENGTH" "" $0
	${textreplace::Unload}

${EndIf}

FunctionEnd

Function Close
IfFileExists "$EXEDIR\${APPDIR}\Azureus_32.exe" 0 +3
Rename "$EXEDIR\${APPDIR}\Azureus.exe" "$EXEDIR\${APPDIR}\Azureus_64.exe"
Rename "$EXEDIR\${APPDIR}\Azureus_32.exe" "$EXEDIR\${APPDIR}\Azureus.exe"
IfFileExists "$EXEDIR\${APPDIR}\AzureusUpdater_32.exe" 0 +3
Rename "$EXEDIR\${APPDIR}\AzureusUpdater.exe" "$EXEDIR\${APPDIR}\AzureusUpdater_64.exe"
Rename "$EXEDIR\${APPDIR}\AzureusUpdater_32.exe" "$EXEDIR\${APPDIR}\AzureusUpdater.exe"
IfFileExists "$EXEDIR\${APPDIR}\swt_32.jar" 0 +3
Rename "$EXEDIR\${APPDIR}\swt.jar" "$EXEDIR\${APPDIR}\swt_64.jar"
Rename "$EXEDIR\${APPDIR}\swt_32.jar" "$EXEDIR\${APPDIR}\swt.jar"
nsisFirewall::RemoveAuthorizedApplication "$EXEDIR\${APPDIR}\${APPEXE}"
FunctionEnd

; **************************************************************************
; ==== Running ====
; **************************************************************************

Section "Main"

	Call Java
	Call CheckStart

	Call BackupLocalKeys

	Call BackupLocalDirs

	Call Init

		Call SplashLogo
		Call Launch

	Call Restore

SectionEnd

Function Restore

	Call Close

	Call RestoreLocalDirs

	Call RestoreLocalKeys

FunctionEnd

; **************************************************************************
; === Run Application ===
; **************************************************************************
Function Launch
SetOutPath "$EXEDIR\${APPDIR}"
${GetParameters} $0
ExecWait `"$EXEDIR\${APPDIR}\${APPEXE}" -J-Dazureus.config.path="$EXEDIR\Data\${APP}"${APPSWITCH} $0`
WriteINIStr "$EXEDIR\Data\${APP}Portable.ini" "${APP}Portable" "GoodExit" "true"
newadvsplash::stop
FunctionEnd

; **************************************************************************
; ==== Actions on Registry Keys =====
; **************************************************************************
Function BackupLocalKeys
	${registry::BackupKey} "${REGKEY1}"
	${registry::BackupKey} "${REGKEY2}"
	${registry::BackupKey} "${REGKEY3}"
	${registry::BackupKey} "${REGKEY4}"
	${registry::BackupKey} "${REGKEY5}"
	${registry::BackupKey} "${REGKEY6}"
	${registry::BackupKey} "${REGKEY7}"
	${registry::BackupKey} "${REGKEY8}"
	${registry::BackupKey} "${REGKEY9}"
	${registry::BackupKey} "${REGKEY10}"
	${registry::BackupKey} "${REGKEY11}"
	${registry::BackupKey} "${REGKEY12}"
	${registry::BackupKey} "${REGKEY13}"
	${registry::BackupKey} "${REGKEY14}"
	${registry::BackupKey} "${REGKEY15}"
	${registry::BackupKey} "${REGKEY16}"
	${registry::BackupKey} "${REGKEY17}"
	${registry::BackupKey} "${REGKEY18}"
	${registry::BackupKey} "${REGKEY19}"
	${registry::BackupKey} "${REGKEY20}"
	${registry::BackupKey} "${REGKEY21}"
	${registry::BackupKey} "${REGKEY22}"
	${registry::BackupKey} "${REGKEY23}"
	${registry::BackupKey} "${REGKEY24}"
	${registry::BackupKey} "${REGKEY25}"
	${registry::BackupKey} "${REGKEY26}"
	${registry::BackupKey} "${REGKEY27}"
	${registry::BackupKey} "${REGKEY28}"
	${registry::BackupKey} "${REGKEY29}"
	${registry::BackupKey} "${REGKEY30}"
	${registry::BackupKey} "${REGKEY31}"
	${registry::BackupKey} "${REGKEY32}"
	${registry::BackupKey} "${REGKEY33}"
	${registry::BackupKey} "${REGKEY34}"
	${registry::BackupKey} "${REGKEY35}"
	${registry::BackupKey} "${REGKEY36}"
	${registry::BackupKey} "${REGKEY37}"
	${registry::BackupKey} "${REGKEY38}"
	${registry::BackupKey} "${REGKEY39}"
	${registry::BackupKey} "${REGKEY40}"
	${registry::BackupKey} "${REGKEY41}"
	${registry::BackupKey} "${REGKEY42}"
FunctionEnd

Function RestoreLocalKeys
	${registry::RestoreBackupKey} "${REGKEY1}"
	${registry::RestoreBackupKey} "${REGKEY2}"
	${registry::RestoreBackupKey} "${REGKEY3}"
	${registry::RestoreBackupKey} "${REGKEY4}"
	${registry::RestoreBackupKey} "${REGKEY5}"
	${registry::RestoreBackupKey} "${REGKEY6}"
	${registry::RestoreBackupKey} "${REGKEY7}"
	${registry::RestoreBackupKey} "${REGKEY8}"
	${registry::RestoreBackupKey} "${REGKEY9}"
	${registry::RestoreBackupKey} "${REGKEY10}"
	${registry::RestoreBackupKey} "${REGKEY11}"
	${registry::RestoreBackupKey} "${REGKEY12}"
	${registry::RestoreBackupKey} "${REGKEY13}"
	${registry::RestoreBackupKey} "${REGKEY14}"
	${registry::RestoreBackupKey} "${REGKEY15}"
	${registry::RestoreBackupKey} "${REGKEY16}"
	${registry::RestoreBackupKey} "${REGKEY17}"
	${registry::RestoreBackupKey} "${REGKEY18}"
	${registry::RestoreBackupKey} "${REGKEY19}"
	${registry::RestoreBackupKey} "${REGKEY20}"
	${registry::RestoreBackupKey} "${REGKEY21}"
	${registry::RestoreBackupKey} "${REGKEY22}"
	${registry::RestoreBackupKey} "${REGKEY23}"
	${registry::RestoreBackupKey} "${REGKEY24}"
	${registry::RestoreBackupKey} "${REGKEY25}"
	${registry::RestoreBackupKey} "${REGKEY26}"
	${registry::RestoreBackupKey} "${REGKEY27}"
	${registry::RestoreBackupKey} "${REGKEY28}"
	${registry::RestoreBackupKey} "${REGKEY29}"
	${registry::RestoreBackupKey} "${REGKEY30}"
	${registry::RestoreBackupKey} "${REGKEY31}"
	${registry::RestoreBackupKey} "${REGKEY32}"
	${registry::RestoreBackupKey} "${REGKEY33}"
	${registry::RestoreBackupKey} "${REGKEY34}"
	${registry::RestoreBackupKey} "${REGKEY35}"
	${registry::RestoreBackupKey} "${REGKEY36}"
	${registry::RestoreBackupKey} "${REGKEY37}"
	${registry::RestoreBackupKey} "${REGKEY38}"
	${registry::RestoreBackupKey} "${REGKEY39}"
	${registry::RestoreBackupKey} "${REGKEY40}"
	${registry::RestoreBackupKey} "${REGKEY41}"
	${registry::RestoreBackupKey} "${REGKEY42}"
${registry::Unload}
FunctionEnd

; **************************************************************************
; ==== Actions on Folders =====
; **************************************************************************
Function BackupLocalDirs
	${directory::BackupLocal} "${LOCALDIR1}" "${SUBDIR1}"
FunctionEnd

Function RestoreLocalDirs
	${directory::RestoreLocal} "${LOCALDIR1}" "${SUBDIR1}"
FunctionEnd
