/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.win32.BITMAP;
import org.eclipse.swt.internal.win32.ICONINFO;
import org.eclipse.swt.internal.win32.OS;

public final class Cursor
extends Resource {
    public long handle;
    boolean isIcon;
    static final byte[] HAND_SOURCE = new byte[]{-7, -1, -1, -1, -16, -1, -1, -1, -16, -1, -1, -1, -16, -1, -1, -1, -16, 63, -1, -1, -16, 7, -1, -1, -16, 3, -1, -1, -16, 0, -1, -1, 16, 0, 127, -1, 0, 0, 127, -1, -128, 0, 127, -1, -64, 0, 127, -1, -32, 0, 127, -1, -16, 0, 127, -1, -8, 0, -1, -1, -4, 1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
    static final byte[] HAND_MASK = new byte[]{0, 0, 0, 0, 6, 0, 0, 0, 6, 0, 0, 0, 6, 0, 0, 0, 6, 0, 0, 0, 6, -64, 0, 0, 6, -40, 0, 0, 6, -40, 0, 0, 7, -37, 0, 0, 103, -5, 0, 0, 63, -1, 0, 0, 31, -1, 0, 0, 15, -1, 0, 0, 7, -1, 0, 0, 3, -2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

    Cursor(Device device) {
        super(device);
    }

    public Cursor(Device device, int style) {
        super(device);
        long lpCursorName = 0L;
        switch (style) {
            case 21: {
                lpCursorName = 32649L;
                break;
            }
            case 0: {
                lpCursorName = 32512L;
                break;
            }
            case 1: {
                lpCursorName = 32514L;
                break;
            }
            case 2: {
                lpCursorName = 32515L;
                break;
            }
            case 3: {
                lpCursorName = 32650L;
                break;
            }
            case 4: {
                lpCursorName = 32651L;
                break;
            }
            case 5: {
                lpCursorName = 32646L;
                break;
            }
            case 6: {
                lpCursorName = 32643L;
                break;
            }
            case 7: {
                lpCursorName = 32645L;
                break;
            }
            case 8: {
                lpCursorName = 32642L;
                break;
            }
            case 9: {
                lpCursorName = 32644L;
                break;
            }
            case 10: {
                lpCursorName = 32645L;
                break;
            }
            case 11: {
                lpCursorName = 32645L;
                break;
            }
            case 12: {
                lpCursorName = 32644L;
                break;
            }
            case 13: {
                lpCursorName = 32644L;
                break;
            }
            case 14: {
                lpCursorName = 32643L;
                break;
            }
            case 15: {
                lpCursorName = 32642L;
                break;
            }
            case 16: {
                lpCursorName = 32643L;
                break;
            }
            case 17: {
                lpCursorName = 32642L;
                break;
            }
            case 18: {
                lpCursorName = 32516L;
                break;
            }
            case 19: {
                lpCursorName = 32513L;
                break;
            }
            case 20: {
                lpCursorName = 32648L;
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        this.handle = OS.LoadCursor(0L, lpCursorName);
        if (this.handle == 0L && style == 21) {
            int width = OS.GetSystemMetrics(13);
            int height = OS.GetSystemMetrics(14);
            if (width == 32 && height == 32) {
                long hInst = OS.GetModuleHandle(null);
                if (OS.IsWinCE) {
                    SWT.error(20);
                }
                this.handle = OS.CreateCursor(hInst, 5, 0, 32, 32, HAND_SOURCE, HAND_MASK);
            }
        }
        if (this.handle == 0L) {
            SWT.error(2);
        }
        this.init();
    }

    public Cursor(Device device, ImageData source, ImageData mask, int hotspotX, int hotspotY) {
        super(device);
        if (source == null) {
            SWT.error(4);
        }
        if (mask == null) {
            if (source.getTransparencyType() != 2) {
                SWT.error(4);
            }
            mask = source.getTransparencyMask();
        }
        if (mask.width != source.width || mask.height != source.height) {
            SWT.error(5);
        }
        if (hotspotX >= source.width || hotspotX < 0 || hotspotY >= source.height || hotspotY < 0) {
            SWT.error(5);
        }
        mask = ImageData.convertMask(mask);
        source = ImageData.convertMask(source);
        byte[] sourceData = ImageData.convertPad(source.data, source.width, source.height, source.depth, source.scanlinePad, 2);
        byte[] maskData = ImageData.convertPad(mask.data, mask.width, mask.height, mask.depth, mask.scanlinePad, 2);
        long hInst = OS.GetModuleHandle(null);
        if (OS.IsWinCE) {
            SWT.error(20);
        }
        this.handle = OS.CreateCursor(hInst, hotspotX, hotspotY, source.width, source.height, sourceData, maskData);
        if (this.handle == 0L) {
            SWT.error(2);
        }
        this.init();
    }

    public Cursor(Device device, ImageData source, int hotspotX, int hotspotY) {
        super(device);
        if (source == null) {
            SWT.error(4);
        }
        if (hotspotX >= source.width || hotspotX < 0 || hotspotY >= source.height || hotspotY < 0) {
            SWT.error(5);
        }
        long hBitmap = 0L;
        long hMask = 0L;
        if (source.maskData == null && source.transparentPixel == -1 && (source.alpha != -1 || source.alphaData != null)) {
            PaletteData palette = source.palette;
            PaletteData newPalette = new PaletteData(65280, 0xFF0000, -16777216);
            ImageData img = new ImageData(source.width, source.height, 32, newPalette);
            if (palette.isDirect) {
                ImageData.blit(1, source.data, source.depth, source.bytesPerLine, source.getByteOrder(), 0, 0, source.width, source.height, palette.redMask, palette.greenMask, palette.blueMask, 255, null, 0, 0, 0, img.data, img.depth, img.bytesPerLine, img.getByteOrder(), 0, 0, img.width, img.height, newPalette.redMask, newPalette.greenMask, newPalette.blueMask, false, false);
            } else {
                RGB[] rgbs = palette.getRGBs();
                int length = rgbs.length;
                byte[] srcReds = new byte[length];
                byte[] srcGreens = new byte[length];
                byte[] srcBlues = new byte[length];
                for (int i = 0; i < rgbs.length; ++i) {
                    RGB rgb = rgbs[i];
                    if (rgb == null) continue;
                    srcReds[i] = (byte)rgb.red;
                    srcGreens[i] = (byte)rgb.green;
                    srcBlues[i] = (byte)rgb.blue;
                }
                ImageData.blit(1, source.data, source.depth, source.bytesPerLine, source.getByteOrder(), 0, 0, source.width, source.height, srcReds, srcGreens, srcBlues, 255, null, 0, 0, 0, img.data, img.depth, img.bytesPerLine, img.getByteOrder(), 0, 0, img.width, img.height, newPalette.redMask, newPalette.greenMask, newPalette.blueMask, false, false);
            }
            hBitmap = Image.createDIB(source.width, source.height, 32);
            if (hBitmap == 0L) {
                SWT.error(2);
            }
            BITMAP dibBM = new BITMAP();
            OS.GetObject(hBitmap, BITMAP.sizeof, dibBM);
            byte[] srcData = img.data;
            if (source.alpha != -1) {
                for (int i = 3; i < srcData.length; i += 4) {
                    srcData[i] = (byte)source.alpha;
                }
            } else if (source.alphaData != null) {
                int sp = 3;
                int ap = 0;
                while (sp < srcData.length) {
                    srcData[sp] = source.alphaData[ap];
                    sp += 4;
                    ++ap;
                }
            }
            OS.MoveMemory(dibBM.bmBits, srcData, srcData.length);
            hMask = OS.CreateBitmap(source.width, source.height, 1, 1, new byte[((source.width + 7) / 8 + 3) / 4 * 4 * source.height]);
            if (hMask == 0L) {
                SWT.error(2);
            }
        } else {
            ImageData mask = source.getTransparencyMask();
            long[] result = Image.init(this.device, null, source, mask);
            hBitmap = result[0];
            hMask = result[1];
        }
        ICONINFO info = new ICONINFO();
        info.fIcon = false;
        info.hbmColor = hBitmap;
        info.hbmMask = hMask;
        info.xHotspot = hotspotX;
        info.yHotspot = hotspotY;
        this.handle = OS.CreateIconIndirect(info);
        OS.DeleteObject(hBitmap);
        OS.DeleteObject(hMask);
        if (this.handle == 0L) {
            SWT.error(2);
        }
        this.isIcon = true;
        this.init();
    }

    @Override
    void destroy() {
        if (this.isIcon) {
            OS.DestroyIcon(this.handle);
        } else if (!OS.IsWinCE) {
            OS.DestroyCursor(this.handle);
        }
        this.handle = 0L;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Cursor)) {
            return false;
        }
        Cursor cursor = (Cursor)object;
        return this.device == cursor.device && this.handle == cursor.handle;
    }

    public int hashCode() {
        return (int)this.handle;
    }

    @Override
    public boolean isDisposed() {
        return this.handle == 0L;
    }

    public String toString() {
        if (this.isDisposed()) {
            return "Cursor {*DISPOSED*}";
        }
        return "Cursor {" + this.handle + "}";
    }

    public static Cursor win32_new(Device device, int handle) {
        Cursor cursor = new Cursor(device);
        cursor.handle = handle;
        return cursor;
    }
}

