/*
 * Decompiled with CFR 0.152.
 */
package org.json.simple;

import java.util.Iterator;
import java.util.Map;
import org.gudy.azureus2.core3.util.LightHashMap;
import org.json.simple.ItemList;
import org.json.simple.JSONArray;

public class JSONObject
extends LightHashMap<String, Object> {
    public JSONObject() {
    }

    public JSONObject(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    public JSONObject(int initialCapacity) {
        super(initialCapacity);
    }

    public JSONObject(Map<String, Object> arg0) {
        super(arg0);
    }

    @Override
    public String toString() {
        ItemList list = new ItemList();
        for (Map.Entry entry : this.entrySet()) {
            list.add(JSONObject.toString(((String)entry.getKey()).toString(), entry.getValue()));
        }
        return "{" + list.toString() + "}";
    }

    public void toString(StringBuilder sb) {
        sb.append("{");
        Iterator iter = this.entrySet().iterator();
        boolean first = true;
        while (iter.hasNext()) {
            if (first) {
                first = false;
            } else {
                sb.append(",");
            }
            Map.Entry entry = (Map.Entry)iter.next();
            JSONObject.toString(sb, entry.getKey().toString(), entry.getValue());
        }
        sb.append("}");
    }

    public static String toString(String key, Object value) {
        StringBuilder sb = new StringBuilder();
        sb.append("\"");
        sb.append(JSONObject.escape(key));
        sb.append("\":");
        if (value == null) {
            sb.append("null");
            return sb.toString();
        }
        if (value instanceof String) {
            sb.append("\"");
            sb.append(JSONObject.escape((String)value));
            sb.append("\"");
        } else {
            sb.append(value);
        }
        return sb.toString();
    }

    public static void toString(StringBuilder sb, String key, Object value) {
        sb.append("\"");
        JSONObject.escape(sb, key);
        sb.append("\":");
        if (value == null) {
            sb.append("null");
            return;
        }
        if (value instanceof String) {
            sb.append("\"");
            JSONObject.escape(sb, (String)value);
            sb.append("\"");
        } else if (value instanceof JSONObject) {
            ((JSONObject)value).toString(sb);
        } else if (value instanceof JSONArray) {
            ((JSONArray)value).toString(sb);
        } else {
            sb.append(String.valueOf(value));
        }
    }

    public static String escape(String s) {
        if (s == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        block10: for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            switch (ch) {
                case '\"': {
                    sb.append("\\\"");
                    continue block10;
                }
                case '\\': {
                    sb.append("\\\\");
                    continue block10;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block10;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block10;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block10;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block10;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block10;
                }
                case '/': {
                    sb.append("\\/");
                    continue block10;
                }
                default: {
                    if (ch >= '\u0000' && ch <= '\u001f') {
                        String ss = Integer.toHexString(ch);
                        sb.append("\\u");
                        for (int k = 0; k < 4 - ss.length(); ++k) {
                            sb.append('0');
                        }
                        sb.append(ss.toUpperCase());
                        continue block10;
                    }
                    sb.append(ch);
                }
            }
        }
        return sb.toString();
    }

    public static void escape(StringBuilder sb, String s) {
        if (s == null) {
            sb.append((String)null);
        } else {
            block10: for (int i = 0; i < s.length(); ++i) {
                char ch = s.charAt(i);
                switch (ch) {
                    case '\"': {
                        sb.append("\\\"");
                        continue block10;
                    }
                    case '\\': {
                        sb.append("\\\\");
                        continue block10;
                    }
                    case '\b': {
                        sb.append("\\b");
                        continue block10;
                    }
                    case '\f': {
                        sb.append("\\f");
                        continue block10;
                    }
                    case '\n': {
                        sb.append("\\n");
                        continue block10;
                    }
                    case '\r': {
                        sb.append("\\r");
                        continue block10;
                    }
                    case '\t': {
                        sb.append("\\t");
                        continue block10;
                    }
                    case '/': {
                        sb.append("\\/");
                        continue block10;
                    }
                    default: {
                        if (ch >= '\u0000' && ch <= '\u001f') {
                            String ss = Integer.toHexString(ch);
                            sb.append("\\u");
                            for (int k = 0; k < 4 - ss.length(); ++k) {
                                sb.append('0');
                            }
                            sb.append(ss.toUpperCase());
                            continue block10;
                        }
                        sb.append(ch);
                    }
                }
            }
        }
    }
}

