/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.bouncycastle.openssl;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Reader;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.security.spec.DSAPrivateKeySpec;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.StringTokenizer;
import org.gudy.bouncycastle.asn1.ASN1InputStream;
import org.gudy.bouncycastle.asn1.ASN1Object;
import org.gudy.bouncycastle.asn1.ASN1Sequence;
import org.gudy.bouncycastle.asn1.DERInteger;
import org.gudy.bouncycastle.asn1.DERObject;
import org.gudy.bouncycastle.asn1.DERObjectIdentifier;
import org.gudy.bouncycastle.asn1.cms.ContentInfo;
import org.gudy.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.gudy.bouncycastle.asn1.sec.ECPrivateKeyStructure;
import org.gudy.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.gudy.bouncycastle.asn1.x509.RSAPublicKeyStructure;
import org.gudy.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.gudy.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.gudy.bouncycastle.jce.ECNamedCurveTable;
import org.gudy.bouncycastle.jce.PKCS10CertificationRequest;
import org.gudy.bouncycastle.jce.provider.BouncyCastleProvider;
import org.gudy.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import org.gudy.bouncycastle.openssl.PEMUtilities;
import org.gudy.bouncycastle.openssl.PasswordFinder;
import org.gudy.bouncycastle.util.encoders.Base64;
import org.gudy.bouncycastle.util.encoders.Hex;
import org.gudy.bouncycastle.x509.X509AttributeCertificate;
import org.gudy.bouncycastle.x509.X509V2AttributeCertificate;

public class PEMReader
extends BufferedReader {
    private final PasswordFinder pFinder;
    private final String provider;

    public PEMReader(Reader reader) {
        this(reader, null, BouncyCastleProvider.PROVIDER_NAME);
    }

    public PEMReader(Reader reader, PasswordFinder pFinder) {
        this(reader, pFinder, BouncyCastleProvider.PROVIDER_NAME);
    }

    public PEMReader(Reader reader, PasswordFinder pFinder, String provider2) {
        super(reader);
        this.pFinder = pFinder;
        this.provider = provider2;
    }

    public Object readObject() throws IOException {
        String line;
        while ((line = this.readLine()) != null) {
            if (line.contains("-----BEGIN PUBLIC KEY")) {
                return this.readPublicKey("-----END PUBLIC KEY");
            }
            if (line.contains("-----BEGIN RSA PUBLIC KEY")) {
                return this.readRSAPublicKey("-----END RSA PUBLIC KEY");
            }
            if (line.contains("-----BEGIN CERTIFICATE REQUEST")) {
                return this.readCertificateRequest("-----END CERTIFICATE REQUEST");
            }
            if (line.contains("-----BEGIN NEW CERTIFICATE REQUEST")) {
                return this.readCertificateRequest("-----END NEW CERTIFICATE REQUEST");
            }
            if (line.contains("-----BEGIN CERTIFICATE")) {
                return this.readCertificate("-----END CERTIFICATE");
            }
            if (line.contains("-----BEGIN PKCS7")) {
                return this.readPKCS7("-----END PKCS7");
            }
            if (line.contains("-----BEGIN X509 CERTIFICATE")) {
                return this.readCertificate("-----END X509 CERTIFICATE");
            }
            if (line.contains("-----BEGIN X509 CRL")) {
                return this.readCRL("-----END X509 CRL");
            }
            if (line.contains("-----BEGIN ATTRIBUTE CERTIFICATE")) {
                return this.readAttributeCertificate("-----END ATTRIBUTE CERTIFICATE");
            }
            if (line.contains("-----BEGIN RSA PRIVATE KEY")) {
                try {
                    return this.readKeyPair("RSA", "-----END RSA PRIVATE KEY");
                }
                catch (Exception e) {
                    throw new IOException("problem creating RSA private key: " + e.toString());
                }
            }
            if (line.contains("-----BEGIN DSA PRIVATE KEY")) {
                try {
                    return this.readKeyPair("DSA", "-----END DSA PRIVATE KEY");
                }
                catch (Exception e) {
                    throw new IOException("problem creating DSA private key: " + e.toString());
                }
            }
            if (line.contains("-----BEGIN EC PARAMETERS-----")) {
                return this.readECParameters("-----END EC PARAMETERS-----");
            }
            if (!line.contains("-----BEGIN EC PRIVATE KEY-----")) continue;
            return this.readECPrivateKey("-----END EC PRIVATE KEY-----");
        }
        return null;
    }

    private byte[] readBytes(String endMarker) throws IOException {
        String line;
        StringBuilder buf = new StringBuilder();
        while ((line = this.readLine()) != null && !line.contains(endMarker)) {
            buf.append(line.trim());
        }
        if (line == null) {
            throw new IOException(endMarker + " not found");
        }
        return Base64.decode(buf.toString());
    }

    private PublicKey readRSAPublicKey(String endMarker) throws IOException {
        ByteArrayInputStream bAIS = new ByteArrayInputStream(this.readBytes(endMarker));
        ASN1InputStream ais = new ASN1InputStream(bAIS);
        DERObject asnObject = ais.readObject();
        ASN1Sequence sequence = (ASN1Sequence)asnObject;
        RSAPublicKeyStructure rsaPubStructure = new RSAPublicKeyStructure(sequence);
        RSAPublicKeySpec keySpec = new RSAPublicKeySpec(rsaPubStructure.getModulus(), rsaPubStructure.getPublicExponent());
        try {
            KeyFactory keyFact = KeyFactory.getInstance("RSA", this.provider);
            return keyFact.generatePublic(keySpec);
        }
        catch (NoSuchProviderException e) {
            throw new IOException("can't find provider " + this.provider);
        }
        catch (Exception e) {
            throw new IOException("problem extracting key: " + e.toString());
        }
    }

    private PublicKey readPublicKey(String endMarker) throws IOException {
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(this.readBytes(endMarker));
        String[] algorithms = new String[]{"DSA", "RSA"};
        for (int i = 0; i < algorithms.length; ++i) {
            try {
                KeyFactory keyFact = KeyFactory.getInstance(algorithms[i], this.provider);
                PublicKey pubKey = keyFact.generatePublic(keySpec);
                return pubKey;
            }
            catch (NoSuchAlgorithmException e) {
                continue;
            }
            catch (InvalidKeySpecException e) {
                continue;
            }
            catch (NoSuchProviderException e) {
                throw new RuntimeException("can't find provider " + this.provider);
            }
        }
        return null;
    }

    private X509Certificate readCertificate(String endMarker) throws IOException {
        ByteArrayInputStream bIn = new ByteArrayInputStream(this.readBytes(endMarker));
        try {
            CertificateFactory certFact = CertificateFactory.getInstance("X.509", this.provider);
            return (X509Certificate)certFact.generateCertificate(bIn);
        }
        catch (Exception e) {
            throw new IOException("problem parsing cert: " + e.toString());
        }
    }

    private X509CRL readCRL(String endMarker) throws IOException {
        ByteArrayInputStream bIn = new ByteArrayInputStream(this.readBytes(endMarker));
        try {
            CertificateFactory certFact = CertificateFactory.getInstance("X.509", this.provider);
            return (X509CRL)certFact.generateCRL(bIn);
        }
        catch (Exception e) {
            throw new IOException("problem parsing cert: " + e.toString());
        }
    }

    private PKCS10CertificationRequest readCertificateRequest(String endMarker) throws IOException {
        try {
            return new PKCS10CertificationRequest(this.readBytes(endMarker));
        }
        catch (Exception e) {
            throw new IOException("problem parsing cert: " + e.toString());
        }
    }

    private X509AttributeCertificate readAttributeCertificate(String endMarker) throws IOException {
        return new X509V2AttributeCertificate(this.readBytes(endMarker));
    }

    private ContentInfo readPKCS7(String endMarker) throws IOException {
        String line;
        StringBuilder buf = new StringBuilder();
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        while ((line = this.readLine()) != null && !line.contains(endMarker)) {
            line = line.trim();
            buf.append(line.trim());
            Base64.decode(buf.substring(0, buf.length() / 4 * 4), bOut);
            buf.delete(0, buf.length() / 4 * 4);
        }
        if (buf.length() != 0) {
            throw new RuntimeException("base64 data appears to be truncated");
        }
        if (line == null) {
            throw new IOException(endMarker + " not found");
        }
        ByteArrayInputStream bIn = new ByteArrayInputStream(bOut.toByteArray());
        try {
            ASN1InputStream aIn = new ASN1InputStream(bIn);
            return ContentInfo.getInstance(aIn.readObject());
        }
        catch (Exception e) {
            throw new IOException("problem parsing PKCS7 object: " + e.toString());
        }
    }

    private KeyPair readKeyPair(String type, String endMarker) throws Exception {
        KeySpec privSpec;
        KeySpec pubSpec;
        boolean isEncrypted = false;
        String line = null;
        String dekInfo = null;
        StringBuilder buf = new StringBuilder();
        while ((line = this.readLine()) != null) {
            if (line.startsWith("Proc-Type: 4,ENCRYPTED")) {
                isEncrypted = true;
                continue;
            }
            if (line.startsWith("DEK-Info:")) {
                dekInfo = line.substring(10);
                continue;
            }
            if (line.contains(endMarker)) break;
            buf.append(line.trim());
        }
        byte[] keyBytes = Base64.decode(buf.toString());
        if (isEncrypted) {
            if (this.pFinder == null) {
                throw new IOException("No password finder specified, but a password is required");
            }
            char[] password = this.pFinder.getPassword();
            if (password == null) {
                throw new IOException("Password is null, but a password is required");
            }
            StringTokenizer tknz = new StringTokenizer(dekInfo, ",");
            String dekAlgName = tknz.nextToken();
            byte[] iv = Hex.decode(tknz.nextToken());
            keyBytes = PEMUtilities.crypt(false, this.provider, keyBytes, password, dekAlgName, iv);
        }
        ByteArrayInputStream bIn = new ByteArrayInputStream(keyBytes);
        ASN1InputStream aIn = new ASN1InputStream(bIn);
        ASN1Sequence seq = (ASN1Sequence)aIn.readObject();
        if (type.equals("RSA")) {
            DERInteger mod = (DERInteger)seq.getObjectAt(1);
            DERInteger pubExp = (DERInteger)seq.getObjectAt(2);
            DERInteger privExp = (DERInteger)seq.getObjectAt(3);
            DERInteger p1 = (DERInteger)seq.getObjectAt(4);
            DERInteger p2 = (DERInteger)seq.getObjectAt(5);
            DERInteger exp1 = (DERInteger)seq.getObjectAt(6);
            DERInteger exp2 = (DERInteger)seq.getObjectAt(7);
            DERInteger crtCoef = (DERInteger)seq.getObjectAt(8);
            pubSpec = new RSAPublicKeySpec(mod.getValue(), pubExp.getValue());
            privSpec = new RSAPrivateCrtKeySpec(mod.getValue(), pubExp.getValue(), privExp.getValue(), p1.getValue(), p2.getValue(), exp1.getValue(), exp2.getValue(), crtCoef.getValue());
        } else {
            DERInteger p = (DERInteger)seq.getObjectAt(1);
            DERInteger q = (DERInteger)seq.getObjectAt(2);
            DERInteger g = (DERInteger)seq.getObjectAt(3);
            DERInteger y = (DERInteger)seq.getObjectAt(4);
            DERInteger x = (DERInteger)seq.getObjectAt(5);
            privSpec = new DSAPrivateKeySpec(x.getValue(), p.getValue(), q.getValue(), g.getValue());
            pubSpec = new DSAPublicKeySpec(y.getValue(), p.getValue(), q.getValue(), g.getValue());
        }
        KeyFactory fact = KeyFactory.getInstance(type, this.provider);
        return new KeyPair(fact.generatePublic(pubSpec), fact.generatePrivate(privSpec));
    }

    private ECNamedCurveParameterSpec readECParameters(String endMarker) throws IOException {
        DERObjectIdentifier oid = (DERObjectIdentifier)ASN1Object.fromByteArray(this.readBytes(endMarker));
        return ECNamedCurveTable.getParameterSpec(oid.getId());
    }

    private KeyPair readECPrivateKey(String endMarker) throws IOException {
        try {
            ECPrivateKeyStructure pKey = new ECPrivateKeyStructure((ASN1Sequence)ASN1Object.fromByteArray(this.readBytes(endMarker)));
            AlgorithmIdentifier algId = new AlgorithmIdentifier(X9ObjectIdentifiers.id_ecPublicKey, pKey.getParameters());
            PrivateKeyInfo privInfo = new PrivateKeyInfo(algId, pKey.getDERObject());
            SubjectPublicKeyInfo pubInfo = new SubjectPublicKeyInfo(algId, pKey.getPublicKey().getBytes());
            PKCS8EncodedKeySpec privSpec = new PKCS8EncodedKeySpec(privInfo.getEncoded());
            X509EncodedKeySpec pubSpec = new X509EncodedKeySpec(pubInfo.getEncoded());
            KeyFactory fact = KeyFactory.getInstance("ECDSA", this.provider);
            return new KeyPair(fact.generatePublic(pubSpec), fact.generatePrivate(privSpec));
        }
        catch (ClassCastException e) {
            throw new IOException("wrong ASN.1 object found in stream");
        }
        catch (Exception e) {
            throw new IOException("problem parsing EC private key: " + e);
        }
    }
}

