/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.bouncycastle.jce.provider;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.NoSuchProviderException;
import java.security.cert.CertPath;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.gudy.bouncycastle.asn1.ASN1EncodableVector;
import org.gudy.bouncycastle.asn1.ASN1Sequence;
import org.gudy.bouncycastle.asn1.DERInputStream;
import org.gudy.bouncycastle.asn1.DERObject;
import org.gudy.bouncycastle.asn1.DEROutputStream;
import org.gudy.bouncycastle.asn1.DERSequence;
import org.gudy.bouncycastle.jce.provider.BouncyCastleProvider;

public class PKIXCertPath
extends CertPath {
    static final List certPathEncodings;
    private List certificates;

    PKIXCertPath(List certificates) {
        super("X.509");
        this.certificates = new ArrayList(certificates);
    }

    PKIXCertPath(InputStream inStream, String encoding) throws CertificateException {
        block6: {
            super("X.509");
            try {
                if (encoding.equals("PkiPath")) {
                    DERInputStream derInStream = new DERInputStream(inStream);
                    DERObject derObject = derInStream.readObject();
                    if (derObject == null || !(derObject instanceof ASN1Sequence)) {
                        throw new CertificateException("input stream does not contain a ASN1 SEQUENCE while reading PkiPath encoded data to load CertPath");
                    }
                    Enumeration enumx = ((ASN1Sequence)derObject).getObjects();
                    this.certificates = new ArrayList();
                    CertificateFactory certFactory = CertificateFactory.getInstance("X.509", BouncyCastleProvider.PROVIDER_NAME);
                    while (enumx.hasMoreElements()) {
                        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
                        DEROutputStream derOutStream = new DEROutputStream(outStream);
                        derOutStream.writeObject(enumx.nextElement());
                        derOutStream.close();
                        ByteArrayInputStream certInStream = new ByteArrayInputStream(outStream.toByteArray());
                        this.certificates.add(0, certFactory.generateCertificate(certInStream));
                    }
                    break block6;
                }
                throw new CertificateException("unsupported encoding");
            }
            catch (IOException ex) {
                throw new CertificateException("IOException throw while decoding CertPath:\n" + ex.toString());
            }
            catch (NoSuchProviderException ex) {
                throw new CertificateException("BouncyCastle provider not found while trying to get a CertificateFactory:\n" + ex.toString());
            }
        }
    }

    public Iterator getEncodings() {
        return certPathEncodings.iterator();
    }

    @Override
    public byte[] getEncoded() throws CertificateEncodingException {
        Object enc;
        Iterator iter = this.getEncodings();
        if (iter.hasNext() && (enc = iter.next()) instanceof String) {
            return this.getEncoded((String)enc);
        }
        return null;
    }

    @Override
    public byte[] getEncoded(String encoding) throws CertificateEncodingException {
        ASN1EncodableVector v;
        DERSequence encoded = null;
        if (encoding.equals("PkiPath")) {
            v = new ASN1EncodableVector();
            ListIterator iter = this.certificates.listIterator(this.certificates.size());
            while (iter.hasPrevious()) {
                v.add(this.getEncodedX509Certificate((X509Certificate)iter.previous()));
            }
        } else {
            throw new CertificateEncodingException("unsupported encoding");
        }
        encoded = new DERSequence(v);
        if (encoded == null) {
            return null;
        }
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        DEROutputStream derOutStream = new DEROutputStream(outStream);
        try {
            derOutStream.writeObject(encoded);
            derOutStream.close();
        }
        catch (IOException ex) {
            throw new CertificateEncodingException("IOExeption thrown: " + ex.toString());
        }
        return outStream.toByteArray();
    }

    public List getCertificates() {
        return new ArrayList(this.certificates);
    }

    private DERObject getEncodedX509Certificate(X509Certificate cert) throws CertificateEncodingException {
        try {
            ByteArrayInputStream inStream = new ByteArrayInputStream(cert.getEncoded());
            DERInputStream derInStream = new DERInputStream(inStream);
            return derInStream.readObject();
        }
        catch (IOException ex) {
            throw new CertificateEncodingException("IOException caught while encoding certificate\n" + ex.toString());
        }
    }

    static {
        ArrayList<String> encodings = new ArrayList<String>();
        encodings.add("PkiPath");
        certPathEncodings = Collections.unmodifiableList(encodings);
    }
}

