/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.bouncycastle.jce.provider;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactorySpi;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.interfaces.DHPrivateKey;
import javax.crypto.interfaces.DHPublicKey;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.bouncycastle.asn1.ASN1Sequence;
import org.gudy.bouncycastle.asn1.DERInputStream;
import org.gudy.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.gudy.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.gudy.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.gudy.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.gudy.bouncycastle.asn1.x509.X509ObjectIdentifiers;
import org.gudy.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.gudy.bouncycastle.jce.interfaces.ElGamalPrivateKey;
import org.gudy.bouncycastle.jce.interfaces.ElGamalPublicKey;
import org.gudy.bouncycastle.jce.provider.JCEECPrivateKey;
import org.gudy.bouncycastle.jce.provider.JCEECPublicKey;
import org.gudy.bouncycastle.jce.provider.JCERSAPublicKey;
import org.gudy.bouncycastle.jce.spec.ECPrivateKeySpec;
import org.gudy.bouncycastle.jce.spec.ECPublicKeySpec;

public abstract class JDKKeyFactory
extends KeyFactorySpi {
    protected KeySpec engineGetKeySpec(Key key, Class spec) throws InvalidKeySpecException {
        if (spec.isAssignableFrom(PKCS8EncodedKeySpec.class) && key.getFormat().equals("PKCS#8")) {
            return new PKCS8EncodedKeySpec(key.getEncoded());
        }
        if (spec.isAssignableFrom(X509EncodedKeySpec.class) && key.getFormat().equals("X.509")) {
            return new X509EncodedKeySpec(key.getEncoded());
        }
        if (spec.isAssignableFrom(RSAPublicKeySpec.class) && key instanceof RSAPublicKey) {
            RSAPublicKey k = (RSAPublicKey)key;
            return new RSAPublicKeySpec(k.getModulus(), k.getPublicExponent());
        }
        if (spec.isAssignableFrom(RSAPrivateKeySpec.class) && key instanceof RSAPrivateKey) {
            RSAPrivateKey k = (RSAPrivateKey)key;
            return new RSAPrivateKeySpec(k.getModulus(), k.getPrivateExponent());
        }
        if (spec.isAssignableFrom(RSAPrivateCrtKeySpec.class) && key instanceof RSAPrivateCrtKey) {
            RSAPrivateCrtKey k = (RSAPrivateCrtKey)key;
            return new RSAPrivateCrtKeySpec(k.getModulus(), k.getPublicExponent(), k.getPrivateExponent(), k.getPrimeP(), k.getPrimeQ(), k.getPrimeExponentP(), k.getPrimeExponentQ(), k.getCrtCoefficient());
        }
        throw new RuntimeException("not implemented yet " + key + " " + spec);
    }

    @Override
    protected Key engineTranslateKey(Key key) throws InvalidKeyException {
        if (key instanceof RSAPublicKey) {
            return new JCERSAPublicKey((RSAPublicKey)key);
        }
        if (key instanceof RSAPrivateCrtKey || key instanceof RSAPrivateKey || key instanceof DHPublicKey || key instanceof DHPrivateKey || key instanceof DSAPublicKey || key instanceof DSAPrivateKey || key instanceof ElGamalPublicKey || key instanceof ElGamalPrivateKey) {
            // empty if block
        }
        throw new InvalidKeyException("key type unknown");
    }

    static PublicKey createPublicKeyFromDERStream(InputStream in) throws IOException {
        return JDKKeyFactory.createPublicKeyFromPublicKeyInfo(new SubjectPublicKeyInfo((ASN1Sequence)new DERInputStream(in).readObject()));
    }

    static PublicKey createPublicKeyFromPublicKeyInfo(SubjectPublicKeyInfo info) {
        AlgorithmIdentifier algId = info.getAlgorithmId();
        if (algId.getObjectId().equals(PKCSObjectIdentifiers.rsaEncryption) || algId.getObjectId().equals(X509ObjectIdentifiers.id_ea_rsa)) {
            return new JCERSAPublicKey(info);
        }
        if (algId.getObjectId().equals(X9ObjectIdentifiers.id_ecPublicKey)) {
            return new JCEECPublicKey(info);
        }
        throw new RuntimeException("algorithm identifier in key not recognised");
    }

    static PrivateKey createPrivateKeyFromDERStream(InputStream in) throws IOException {
        return JDKKeyFactory.createPrivateKeyFromPrivateKeyInfo(new PrivateKeyInfo((ASN1Sequence)new DERInputStream(in).readObject()));
    }

    static PrivateKey createPrivateKeyFromPrivateKeyInfo(PrivateKeyInfo info) {
        AlgorithmIdentifier algId = info.getAlgorithmId();
        if (algId.getObjectId().equals(X9ObjectIdentifiers.id_ecPublicKey)) {
            return new JCEECPrivateKey(info);
        }
        throw new RuntimeException("algorithm identifier in key not recognised");
    }

    public static class EC
    extends JDKKeyFactory {
        String algorithm;

        public EC() throws NoSuchAlgorithmException {
            this("EC");
            try {
                StackTraceElement[] elements = new Exception().getStackTrace();
                boolean ssl = false;
                boolean x509 = false;
                for (StackTraceElement elt : elements) {
                    String name = elt.getClassName() + "." + elt.getMethodName();
                    if (name.contains("SSLSocketFactory") || name.contains("KeyStore.load")) {
                        ssl = true;
                        continue;
                    }
                    if (!name.contains("X509")) continue;
                    x509 = true;
                }
                if (ssl && x509) {
                    throw new NoSuchAlgorithmException();
                }
            }
            catch (NoSuchAlgorithmException e) {
                throw e;
            }
            catch (Throwable e) {
                Debug.out(e);
            }
        }

        public EC(String algorithm) {
            this.algorithm = algorithm;
        }

        @Override
        protected PrivateKey engineGeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
            if (keySpec instanceof PKCS8EncodedKeySpec) {
                try {
                    return JDKKeyFactory.createPrivateKeyFromDERStream(new ByteArrayInputStream(((PKCS8EncodedKeySpec)keySpec).getEncoded()));
                }
                catch (Exception e) {
                    throw new InvalidKeySpecException(e.toString());
                }
            }
            if (keySpec instanceof ECPrivateKeySpec) {
                return new JCEECPrivateKey(this.algorithm, (ECPrivateKeySpec)keySpec);
            }
            throw new InvalidKeySpecException("Unknown KeySpec type.");
        }

        @Override
        protected PublicKey engineGeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
            if (keySpec instanceof X509EncodedKeySpec) {
                try {
                    return JDKKeyFactory.createPublicKeyFromDERStream(new ByteArrayInputStream(((X509EncodedKeySpec)keySpec).getEncoded()));
                }
                catch (Exception e) {
                    throw new InvalidKeySpecException(e.toString());
                }
            }
            if (keySpec instanceof ECPublicKeySpec) {
                return new JCEECPublicKey(this.algorithm, (ECPublicKeySpec)keySpec);
            }
            throw new InvalidKeySpecException("Unknown KeySpec type.");
        }
    }

    public static class ECDSA
    extends EC {
        public ECDSA() {
            super("ECDSA");
        }
    }
}

