/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.bouncycastle.asn1.misc;

import org.gudy.bouncycastle.asn1.ASN1EncodableVector;
import org.gudy.bouncycastle.asn1.ASN1OctetString;
import org.gudy.bouncycastle.asn1.ASN1Sequence;
import org.gudy.bouncycastle.asn1.DEREncodable;
import org.gudy.bouncycastle.asn1.DERObject;
import org.gudy.bouncycastle.asn1.DEROctetString;
import org.gudy.bouncycastle.asn1.DERSequence;

public class IDEACBCPar
implements DEREncodable {
    ASN1OctetString iv;

    public static IDEACBCPar getInstance(Object o) {
        if (o instanceof IDEACBCPar) {
            return (IDEACBCPar)o;
        }
        if (o instanceof ASN1Sequence) {
            return new IDEACBCPar((ASN1Sequence)o);
        }
        throw new IllegalArgumentException("unknown object in IDEACBCPar factory");
    }

    public IDEACBCPar(byte[] iv) {
        this.iv = new DEROctetString(iv);
    }

    public IDEACBCPar(ASN1Sequence seq) {
        this.iv = seq.size() == 1 ? (ASN1OctetString)seq.getObjectAt(0) : null;
    }

    public byte[] getIV() {
        if (this.iv != null) {
            return this.iv.getOctets();
        }
        return null;
    }

    @Override
    public DERObject getDERObject() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        if (this.iv != null) {
            v.add(this.iv);
        }
        return new DERSequence(v);
    }
}

