/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.bouncycastle.asn1;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.gudy.bouncycastle.asn1.ASN1InputStream;
import org.gudy.bouncycastle.asn1.ASN1Object;
import org.gudy.bouncycastle.asn1.DEREncodable;
import org.gudy.bouncycastle.asn1.DERObject;
import org.gudy.bouncycastle.asn1.DEROutputStream;

public class DERApplicationSpecific
extends ASN1Object {
    private int tag;
    private byte[] octets;

    public DERApplicationSpecific(int tag, byte[] octets) {
        this.tag = tag;
        this.octets = octets;
    }

    public DERApplicationSpecific(int tag, DEREncodable object) throws IOException {
        this(true, tag, object);
    }

    public DERApplicationSpecific(boolean explicit, int tag, DEREncodable object) throws IOException {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        DEROutputStream dos = new DEROutputStream(bOut);
        dos.writeObject(object);
        byte[] data = bOut.toByteArray();
        if (tag >= 31) {
            throw new IOException("unsupported tag number");
        }
        if (explicit) {
            this.tag = tag | 0x20;
            this.octets = data;
        } else {
            this.tag = tag;
            int lenBytes = this.getLengthOfLength(data);
            byte[] tmp = new byte[data.length - lenBytes];
            System.arraycopy(data, lenBytes, tmp, 0, tmp.length);
            this.octets = tmp;
        }
    }

    private int getLengthOfLength(byte[] data) {
        int count = 2;
        while ((data[count - 1] & 0x80) != 0) {
            ++count;
        }
        return count;
    }

    public boolean isConstructed() {
        return (this.tag & 0x20) != 0;
    }

    public byte[] getContents() {
        return this.octets;
    }

    public int getApplicationTag() {
        return this.tag;
    }

    public DERObject getObject() throws IOException {
        return new ASN1InputStream(this.getContents()).readObject();
    }

    public DERObject getObject(int derTagNo) throws IOException {
        if (this.tag >= 31) {
            throw new IOException("unsupported tag number");
        }
        byte[] tmp = this.getEncoded();
        tmp[0] = (byte)derTagNo;
        return new ASN1InputStream(tmp).readObject();
    }

    @Override
    void encode(DEROutputStream out) throws IOException {
        out.writeEncoded(0x40 | this.tag, this.octets);
    }

    @Override
    boolean asn1Equals(DERObject o) {
        if (!(o instanceof DERApplicationSpecific)) {
            return false;
        }
        DERApplicationSpecific other = (DERApplicationSpecific)o;
        if (this.tag != other.tag) {
            return false;
        }
        if (this.octets.length != other.octets.length) {
            return false;
        }
        for (int i = 0; i < this.octets.length; ++i) {
            if (this.octets[i] == other.octets[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        byte[] b = this.getContents();
        int value = 0;
        for (int i = 0; i != b.length; ++i) {
            value ^= (b[i] & 0xFF) << i % 4;
        }
        return value ^ this.getApplicationTag();
    }
}

