/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.update;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.gudy.azureus2.core3.logging.LogAlert;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.AETemporaryFileHandler;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemProperties;
import org.gudy.azureus2.plugins.Plugin;
import org.gudy.azureus2.plugins.PluginException;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.logging.LoggerChannel;
import org.gudy.azureus2.plugins.update.UpdatableComponent;
import org.gudy.azureus2.plugins.update.Update;
import org.gudy.azureus2.plugins.update.UpdateCheckInstance;
import org.gudy.azureus2.plugins.update.UpdateCheckInstanceListener;
import org.gudy.azureus2.plugins.update.UpdateChecker;
import org.gudy.azureus2.plugins.update.UpdateInstaller;
import org.gudy.azureus2.plugins.update.UpdateListener;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloader;
import org.gudy.azureus2.update.CorePatchLevel;
import org.gudy.azureus2.update.UpdateJarPatcher;
import org.gudy.azureus2.update.UpdaterUpdateChecker;

public class CorePatchChecker
implements Plugin,
UpdatableComponent,
UpdateCheckInstanceListener {
    private static final LogIDs LOGID = LogIDs.CORE;
    public static final boolean TESTING = false;
    protected PluginInterface plugin_interface;
    private Map<UpdateCheckInstance, Update> my_updates = new HashMap<UpdateCheckInstance, Update>(1);

    @Override
    public void initialize(PluginInterface _plugin_interface) throws PluginException {
        this.plugin_interface = _plugin_interface;
        this.plugin_interface.getPluginProperties().setProperty("plugin.version", "1.0");
        this.plugin_interface.getPluginProperties().setProperty("plugin.name", "Core Patcher (level=" + CorePatchLevel.getCurrentPatchLevel() + ")");
        if (!Constants.isCVSVersion()) {
            this.plugin_interface.getUpdateManager().registerUpdatableComponent(this, false);
        }
    }

    @Override
    public String getName() {
        return "Core Patch Checker";
    }

    @Override
    public int getMaximumCheckTime() {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void checkForUpdate(UpdateChecker checker) {
        try {
            UpdateCheckInstance inst = checker.getCheckInstance();
            inst.addListener(this);
            this.my_updates.put(inst, checker.addUpdate("Core Patch Checker", new String[0], "", "", new ResourceDownloader[0], 3));
        }
        finally {
            checker.completed();
        }
    }

    @Override
    public void cancelled(UpdateCheckInstance instance) {
        Update update = this.my_updates.remove(instance);
        if (update != null) {
            update.cancel();
        }
    }

    @Override
    public void complete(final UpdateCheckInstance instance) {
        Update my_update = this.my_updates.remove(instance);
        if (my_update != null) {
            my_update.complete(true);
        }
        Update[] updates = instance.getUpdates();
        final PluginInterface updater_plugin = this.plugin_interface.getPluginManager().getPluginInterfaceByClass(UpdaterUpdateChecker.class);
        for (int i = 0; i < updates.length; ++i) {
            Update update = updates[i];
            Object user_object = update.getUserObject();
            if (user_object == null || user_object != updater_plugin) continue;
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(LOGID, "Core Patcher: updater update found"));
            }
            update.setRestartRequired(3);
            update.addListener(new UpdateListener(){

                @Override
                public void complete(Update update) {
                    if (Logger.isEnabled()) {
                        Logger.log(new LogEvent(LOGID, "Core Patcher: updater update complete"));
                    }
                    CorePatchChecker.this.patch(instance, update, updater_plugin);
                }

                @Override
                public void cancelled(Update update) {
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void patch(UpdateCheckInstance instance, Update updater_update, PluginInterface updater_plugin) {
        block19: {
            try {
                ResourceDownloader rd_log = updater_update.getDownloaders()[0];
                File[] files = new File(updater_plugin.getPluginDirectoryName()).listFiles();
                if (files == null) {
                    if (Logger.isEnabled()) {
                        Logger.log(new LogEvent(LOGID, "Core Patcher: no files in plugin dir!!!"));
                    }
                    return;
                }
                String patch_prefix = "Azureus2_" + Constants.getBaseVersion() + "_P";
                int highest_p = -1;
                File highest_p_file = null;
                for (int i = 0; i < files.length; ++i) {
                    String name = files[i].getName();
                    if (!name.startsWith(patch_prefix) || !name.endsWith(".pat")) continue;
                    if (Logger.isEnabled()) {
                        Logger.log(new LogEvent(LOGID, "Core Patcher: found patch file '" + name + "'"));
                    }
                    try {
                        int this_p = Integer.parseInt(name.substring(patch_prefix.length(), name.indexOf(".pat")));
                        if (this_p <= highest_p) continue;
                        highest_p = this_p;
                        highest_p_file = files[i];
                        continue;
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                    }
                }
                if (CorePatchLevel.getCurrentPatchLevel() >= highest_p) {
                    if (Logger.isEnabled()) {
                        Logger.log(new LogEvent(LOGID, "Core Patcher: no applicable patch found (highest = " + highest_p + ")"));
                    }
                    if (updater_update.getRestartRequired() == 3) {
                        updater_update.setRestartRequired(1);
                    }
                    break block19;
                }
                rd_log.reportActivity("Applying patch '" + highest_p_file.getName() + "'");
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(LOGID, "Core Patcher: applying patch '" + highest_p_file.toString() + "'"));
                }
                FileInputStream pis = new FileInputStream(highest_p_file);
                try {
                    CorePatchChecker.patchAzureus2(instance, pis, "P" + highest_p, this.plugin_interface.getLogger().getChannel("CorePatcher"));
                    Logger.log(new LogAlert(false, 0, "Patch " + highest_p_file.getName() + " ready to be applied"));
                    String done_file = highest_p_file.toString();
                    done_file = done_file.substring(0, done_file.length() - 1) + "x";
                    highest_p_file.renameTo(new File(done_file));
                    updater_update.setRestartRequired(2);
                }
                finally {
                    try {
                        ((InputStream)pis).close();
                    }
                    catch (Throwable e) {}
                }
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
                Logger.log(new LogAlert(false, "Core Patcher failed", e));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void patchAzureus2(UpdateCheckInstance instance, InputStream pis, String resource_tag, LoggerChannel log) throws Exception {
        OutputStream os = null;
        InputStream is = null;
        try {
            String resource_name = "Azureus2_" + resource_tag + ".jar";
            UpdateInstaller installer = instance.createInstaller();
            File tmp = AETemporaryFileHandler.createTempFile();
            os = new FileOutputStream(tmp);
            String az2_jar = Constants.isOSX ? installer.getInstallDir() + "/" + SystemProperties.getApplicationName() + ".app/Contents/Resources/Java/" : installer.getInstallDir() + File.separator;
            az2_jar = az2_jar + "Azureus2.jar";
            is = new FileInputStream(az2_jar);
            new UpdateJarPatcher(is, pis, os, log);
            is.close();
            is = null;
            pis.close();
            pis = null;
            os.close();
            os = null;
            installer.addResource(resource_name, new FileInputStream(tmp));
            tmp.delete();
            installer.addMoveAction(resource_name, az2_jar);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Throwable e) {}
            }
            if (os != null) {
                try {
                    os.close();
                }
                catch (Throwable e) {}
            }
            if (pis != null) {
                try {
                    pis.close();
                }
                catch (Throwable e) {}
            }
        }
    }
}

