/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.wizard;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.components.shell.ShellFactory;
import org.gudy.azureus2.ui.swt.wizard.IWizardPanel;
import org.gudy.azureus2.ui.swt.wizard.WizardListener;

public class Wizard {
    private static final int DEFAULT_WIDTH = 500;
    List<WizardListener> listeners = new ArrayList<WizardListener>(1);
    Display display;
    Shell wizardWindow;
    Label title;
    Label currentInfo;
    Label errorMessage;
    IWizardPanel<?> currentPanel;
    Composite panel;
    Font titleFont;
    protected Button previous;
    protected Button next;
    protected Button finish;
    protected Button cancel;
    Listener closeCatcher;
    int wizardHeight;
    private boolean completed;

    public Wizard(String keyTitle) {
        this(keyTitle, false);
    }

    public Wizard(String keyTitle, boolean modal) {
        this(modal);
        this.setTitleKey(keyTitle);
    }

    public Wizard(String keyTitle, boolean modal, int width) {
        this(modal, width);
        this.setTitleKey(keyTitle);
    }

    public Wizard(boolean modal) {
        this(modal, 500);
    }

    public Wizard(boolean modal, int width) {
        int style = 2160;
        if (modal) {
            style |= 0x10000;
        }
        this.wizardWindow = ShellFactory.createMainShell(style);
        this.display = this.wizardWindow.getDisplay();
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.wizardWindow.setLayout(layout);
        Utils.setShellIcon(this.wizardWindow);
        Composite cTitle = new Composite(this.wizardWindow, 0);
        Color white = this.display.getSystemColor(1);
        cTitle.setBackground(white);
        GridData gridData = new GridData(768);
        Utils.setLayoutData((Control)cTitle, gridData);
        GridLayout titleLayout = new GridLayout();
        titleLayout.numColumns = 1;
        cTitle.setLayout(titleLayout);
        this.title = new Label(cTitle, 0);
        this.title.setBackground(white);
        gridData = new GridData(768);
        Utils.setLayoutData((Control)this.title, gridData);
        Font font = this.title.getFont();
        FontData[] data = font.getFontData();
        for (int i = 0; i < data.length; ++i) {
            data[i].setStyle(1);
        }
        this.titleFont = new Font((Device)this.display, data);
        this.title.setFont(this.titleFont);
        this.currentInfo = new Label(cTitle, 64);
        gridData = Utils.getWrappableLabelGridData(1, 768);
        Utils.setLayoutData((Control)this.currentInfo, gridData);
        this.currentInfo.setBackground(white);
        this.errorMessage = new Label(cTitle, 0);
        gridData = new GridData(768);
        Utils.setLayoutData((Control)this.errorMessage, gridData);
        this.errorMessage.setBackground(white);
        Color red = this.display.getSystemColor(3);
        this.errorMessage.setForeground(red);
        gridData = new GridData(768);
        new Label(this.wizardWindow, 258).setLayoutData(gridData);
        this.panel = new Composite(this.wizardWindow, 0);
        gridData = new GridData(1808);
        Utils.setLayoutData((Control)this.panel, gridData);
        gridData = new GridData(768);
        new Label(this.wizardWindow, 258).setLayoutData(gridData);
        Composite cButtons = new Composite(this.wizardWindow, 0);
        gridData = new GridData(768);
        Utils.setLayoutData((Control)cButtons, gridData);
        GridLayout layoutButtons = new GridLayout();
        layoutButtons.numColumns = 5;
        cButtons.setLayout(layoutButtons);
        gridData = new GridData(768);
        new Label(cButtons, 0).setLayoutData(gridData);
        this.cancel = new Button(cButtons, 8);
        gridData = new GridData();
        gridData.widthHint = 90;
        gridData.horizontalAlignment = 2;
        Utils.setLayoutData((Control)this.cancel, gridData);
        Messages.setLanguageText(this.cancel, "Button.cancel");
        this.previous = new Button(cButtons, 8);
        gridData = new GridData();
        gridData.widthHint = 90;
        gridData.horizontalAlignment = 3;
        Utils.setLayoutData((Control)this.previous, gridData);
        Messages.setLanguageText(this.previous, "wizard.previous");
        this.next = new Button(cButtons, 8);
        gridData = new GridData();
        gridData.widthHint = 90;
        gridData.horizontalAlignment = 1;
        Utils.setLayoutData((Control)this.next, gridData);
        Messages.setLanguageText(this.next, "wizard.next");
        this.finish = new Button(cButtons, 8);
        gridData = new GridData();
        gridData.widthHint = 90;
        gridData.horizontalAlignment = 2;
        Utils.setLayoutData((Control)this.finish, gridData);
        Messages.setLanguageText(this.finish, "wizard.finish");
        this.previous.addListener(13, new Listener(){

            @Override
            public void handleEvent(Event arg0) {
                Wizard.this.clearPanel();
                Wizard.this.currentPanel = Wizard.this.currentPanel.getPreviousPanel();
                Wizard.this.refresh();
            }
        });
        this.next.addListener(13, new Listener(){

            @Override
            public void handleEvent(Event arg0) {
                IWizardPanel<?> nextPanel = Wizard.this.currentPanel.getNextPanel();
                Wizard.this.clearPanel();
                Wizard.this.currentPanel = nextPanel;
                Wizard.this.refresh();
            }
        });
        this.closeCatcher = new Listener(){

            @Override
            public void handleEvent(Event event2) {
                event2.doit = false;
            }
        };
        this.finish.addListener(13, new Listener(){

            @Override
            public void handleEvent(Event arg0) {
                Wizard.this.finishSelected();
            }
        });
        this.cancel.addListener(13, new Listener(){

            @Override
            public void handleEvent(Event arg0) {
                Wizard.this.cancelSelected();
            }
        });
        this.wizardWindow.addDisposeListener(new DisposeListener(){

            @Override
            public void widgetDisposed(DisposeEvent de) {
                Wizard.this.onClose();
            }
        });
        this.wizardWindow.addListener(31, new Listener(){

            @Override
            public void handleEvent(Event e) {
                if (e.character == '\u001b' && Wizard.this.cancel.isEnabled()) {
                    Wizard.this.wizardWindow.dispose();
                }
            }
        });
        this.wizardHeight = this.wizardWindow.computeSize((int)width, (int)-1).y - 50;
        this.wizardWindow.setSize(Utils.adjustPXForDPI(width), Utils.adjustPXForDPI(400));
    }

    private void cancelSelected() {
        this.completed = true;
        if (this.currentPanel != null) {
            this.currentPanel.cancelled();
        }
        this.wizardWindow.dispose();
    }

    private void finishSelected() {
        if (this.currentPanel.isFinishSelectionOK()) {
            this.completed = true;
            this.wizardWindow.addListener(21, this.closeCatcher);
            this.clearPanel();
            this.currentPanel = this.currentPanel.getFinishPanel();
            this.refresh();
            this.currentPanel.finish();
        }
    }

    private void clearPanel() {
        if (this.panel.isDisposed()) {
            return;
        }
        Control[] controls = this.panel.getChildren();
        for (int i = 0; i < controls.length; ++i) {
            if (controls[i] == null || controls[i].isDisposed()) continue;
            controls[i].dispose();
        }
        this.setTitle("");
        this.setCurrentInfo("");
    }

    private void refresh() {
        if (this.currentPanel == null) {
            this.setDefaultButton();
            return;
        }
        this.previous.setEnabled(this.currentPanel.isPreviousEnabled());
        this.next.setEnabled(this.currentPanel.isNextEnabled());
        this.finish.setEnabled(this.currentPanel.isFinishEnabled());
        this.setDefaultButton();
        this.currentPanel.show();
        this.panel.layout();
        this.panel.redraw();
        this.insureSize();
    }

    private void setDefaultButton() {
        if (!this.wizardWindow.isDisposed()) {
            this.display.asyncExec(new AERunnable(){

                @Override
                public void runSupport() {
                    if (!Wizard.this.wizardWindow.isDisposed()) {
                        Button default_button = null;
                        if (Wizard.this.next.isEnabled()) {
                            default_button = Wizard.this.next;
                        } else if (Wizard.this.finish.isEnabled()) {
                            default_button = Wizard.this.finish;
                        } else if (Wizard.this.previous.isEnabled()) {
                            default_button = Wizard.this.previous;
                        } else if (Wizard.this.cancel.isEnabled()) {
                            default_button = Wizard.this.cancel;
                        }
                        if (default_button != null) {
                            Wizard.this.wizardWindow.setDefaultButton(default_button);
                        }
                    }
                }
            });
        }
    }

    public Composite getPanel() {
        return this.panel;
    }

    public void setTitle(String title) {
        this.title.setText(title);
    }

    public void setTitleAsResourceID(String id) {
        Messages.setLanguageText(this.title, id);
    }

    public void setCurrentInfo(String currentInfo) {
        currentInfo = currentInfo.replaceAll("\n", "\n\t");
        this.currentInfo.setText("\t" + currentInfo);
        this.currentInfo.getParent().layout();
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage.setText(errorMessage);
    }

    public void setTitleKey(String key) {
        Messages.setLanguageText(this.wizardWindow, key);
    }

    public void setNextEnabled(boolean enabled) {
        this.next.setEnabled(enabled);
        this.setDefaultButton();
    }

    public void setPreviousEnabled(boolean enabled) {
        this.previous.setEnabled(enabled);
        this.setDefaultButton();
    }

    public void setFinishEnabled(boolean enabled) {
        this.finish.setEnabled(enabled);
        this.setDefaultButton();
    }

    public void setFirstPanel(IWizardPanel<?> panel) {
        this.currentPanel = panel;
        this.refresh();
        this.insureSize();
        Utils.centreWindow(this.wizardWindow);
        this.wizardWindow.open();
    }

    public Shell getWizardWindow() {
        return this.wizardWindow;
    }

    public String getErrorMessage() {
        return this.errorMessage.getText();
    }

    public Display getDisplay() {
        return this.display;
    }

    public void switchToClose() {
        this.switchToClose(null);
    }

    public void switchToClose(final Runnable do_it) {
        if (!this.wizardWindow.isDisposed()) {
            this.display.asyncExec(new AERunnable(){

                @Override
                public void runSupport() {
                    if (Wizard.this.closeCatcher != null && Wizard.this.wizardWindow != null && !Wizard.this.wizardWindow.isDisposed()) {
                        Wizard.this.wizardWindow.removeListener(21, Wizard.this.closeCatcher);
                        Wizard.this.cancel.setText(MessageText.getString("wizard.close"));
                        Wizard.this.cancel.setEnabled(true);
                        Wizard.this.setDefaultButton();
                        if (do_it != null) {
                            do_it.run();
                        }
                    }
                }
            });
        }
    }

    public void close() {
        this.completed = true;
        if (!this.wizardWindow.isDisposed()) {
            this.wizardWindow.dispose();
        }
    }

    public void onClose() {
        if (this.titleFont != null && !this.titleFont.isDisposed()) {
            this.titleFont.dispose();
            this.titleFont = null;
        }
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.get(i).closed();
        }
        if (!this.completed) {
            this.completed = true;
            if (this.currentPanel != null) {
                this.currentPanel.cancelled();
            }
        }
    }

    public IWizardPanel<?> getCurrentPanel() {
        return this.currentPanel;
    }

    private void insureSize() {
        Point p = this.panel.computeSize(this.wizardWindow.getSize().x, -1);
        int height = p.y + this.wizardHeight;
        if (height > this.wizardWindow.getSize().y) {
            this.wizardWindow.setSize(p.x, height);
        }
    }

    public void addListener(WizardListener l) {
        if (this.wizardWindow.isDisposed() && this.closeCatcher != null) {
            l.closed();
        }
        this.listeners.add(l);
    }

    public void removeListener(WizardListener l) {
        this.listeners.remove(l);
    }
}

