/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.utils;

import com.aelitis.azureus.core.tag.Tag;
import com.aelitis.azureus.core.tag.Taggable;
import com.aelitis.azureus.ui.swt.utils.ColorCache;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.ui.swt.MenuBuildUtils;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.views.utils.TagUIUtils;

public class TagButtonsUI
implements PaintListener {
    private ArrayList<Button> buttons;
    private Composite cMainComposite;

    @Override
    public void paintControl(PaintEvent e) {
        Button button;
        Composite c = null;
        if (e.widget instanceof Composite) {
            c = (Composite)e.widget;
            button = (Button)c.getChildren()[0];
        } else {
            button = (Button)e.widget;
        }
        Tag tag = (Tag)button.getData("Tag");
        if (tag == null) {
            return;
        }
        if (c != null) {
            boolean checked = button.getSelection();
            Point size = c.getSize();
            Point sizeButton = button.getSize();
            e.gc.setAntialias(1);
            e.gc.setForeground(ColorCache.getColor((Device)e.display, tag.getColor()));
            int lineWidth = button.getSelection() ? 2 : 1;
            e.gc.setLineWidth(lineWidth);
            int curve = 20;
            int width = sizeButton.x + lineWidth + 1;
            width += Constants.isOSX ? 5 : curve / 2;
            if (checked) {
                e.gc.setAlpha(32);
                e.gc.setBackground(ColorCache.getColor((Device)e.display, tag.getColor()));
                e.gc.fillRoundRectangle(-curve, lineWidth - 1, width + curve, size.y - lineWidth, curve, curve);
                e.gc.setAlpha(255);
            }
            if (!checked) {
                e.gc.setAlpha(128);
            }
            e.gc.drawRoundRectangle(-curve, lineWidth - 1, width + curve, size.y - lineWidth, curve, curve);
            e.gc.drawLine(lineWidth - 1, lineWidth, lineWidth - 1, size.y - lineWidth);
        } else if (!Constants.isOSX && button.getSelection()) {
            Point size = button.getSize();
            e.gc.setBackground(ColorCache.getColor((Device)e.display, tag.getColor()));
            e.gc.setAlpha(20);
            e.gc.fillRectangle(0, 0, size.x, size.y);
        }
    }

    public void buildTagGroup(List<Tag> tags, Composite cMainComposite, final TagButtonTrigger trigger) {
        this.cMainComposite = cMainComposite;
        cMainComposite.setLayout(new GridLayout(1, false));
        this.buttons = new ArrayList();
        SelectionListener selectionListener = new SelectionListener(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                Button button = (Button)e.widget;
                Tag tag = (Tag)button.getData("Tag");
                if (button.getGrayed()) {
                    button.setGrayed(false);
                    button.setSelection(!button.getSelection());
                    button.getParent().redraw();
                }
                boolean doTag = button.getSelection();
                trigger.tagButtonTriggered(tag, doTag);
                button.getParent().redraw();
                button.getParent().update();
            }

            @Override
            public void widgetDefaultSelected(SelectionEvent e) {
            }
        };
        Listener menuDetectListener = new Listener(){

            @Override
            public void handleEvent(Event event2) {
                final Button button = (Button)event2.widget;
                Menu menu = new Menu(button);
                button.setMenu(menu);
                MenuBuildUtils.addMaintenanceListenerForMenu(menu, new MenuBuildUtils.MenuBuilder(){

                    @Override
                    public void buildMenu(Menu menu, MenuEvent menuEvent) {
                        Tag tag = (Tag)button.getData("Tag");
                        TagUIUtils.createSideBarMenuItems(menu, tag);
                    }
                });
            }
        };
        tags = TagUIUtils.sortTags(tags);
        Composite g = null;
        String group = null;
        for (Tag tag : tags) {
            String newGroup = tag.getGroup();
            if (g == null || group != null && !group.equals(newGroup) || group == null && newGroup != null) {
                group = newGroup;
                Composite composite = g = group == null ? new Composite(cMainComposite, 0x20000000) : new Group(cMainComposite, 0x20000000);
                if (group != null) {
                    ((Group)g).setText(group);
                }
                g.setLayoutData(new GridData(4, 4, true, true));
                RowLayout rowLayout = new RowLayout();
                rowLayout.pack = true;
                rowLayout.spacing = 5;
                Utils.setLayout(g, rowLayout);
            }
            Composite p = new Composite(g, 0x20000000);
            GridLayout layout = new GridLayout(1, false);
            layout.marginHeight = 3;
            if (Constants.isWindows) {
                layout.marginWidth = 6;
                layout.marginLeft = 2;
                layout.marginTop = 1;
            } else {
                layout.marginWidth = 0;
                layout.marginLeft = 3;
                layout.marginRight = 11;
            }
            p.setLayout(layout);
            p.addPaintListener(this);
            Button button = new Button(p, 32);
            this.buttons.add(button);
            boolean[] auto = tag.isTagAuto();
            if (auto[0] && auto[1]) {
                button.setEnabled(false);
            } else {
                button.addSelectionListener(selectionListener);
            }
            button.setData("Tag", tag);
            button.addListener(35, menuDetectListener);
            button.addPaintListener(this);
        }
    }

    public boolean updateFields(List<Taggable> taggables) {
        ArrayList<Button> layoutChanges = new ArrayList<Button>();
        for (Button button : this.buttons) {
            Tag tag = (Tag)button.getData("Tag");
            if (tag == null) continue;
            String name = tag.getTagName(true);
            if (!button.getText().equals(name)) {
                button.setText(name);
                layoutChanges.add(button);
            }
            this.updateButtonState(tag, button, taggables);
            button.getParent().redraw();
        }
        if (layoutChanges.size() > 0) {
            this.cMainComposite.layout(layoutChanges.toArray(new Control[0]));
            return true;
        }
        return false;
    }

    private void updateButtonState(Tag tag, Button button, List<Taggable> taggables) {
        if (taggables == null) {
            button.setSelection(false);
            button.setEnabled(false);
            button.getParent().redraw();
            return;
        }
        boolean hasTag = false;
        boolean hasNoTag = false;
        for (Taggable taggable : taggables) {
            boolean curHasTag = tag.hasTaggable(taggable);
            if (!hasTag && curHasTag) {
                hasTag = true;
                if (!hasNoTag) continue;
                break;
            }
            if (hasNoTag || curHasTag) continue;
            hasNoTag = true;
            if (!hasTag) continue;
            break;
        }
        boolean[] auto = tag.isTagAuto();
        boolean auto_add = auto[0];
        boolean auto_rem = auto[1];
        if (hasTag && hasNoTag) {
            button.setEnabled(!auto_add);
            button.setGrayed(true);
            button.setSelection(true);
        } else {
            if (auto_add && auto_rem) {
                button.setEnabled(false);
            } else {
                button.setEnabled(hasTag || !hasTag && !auto_add);
            }
            button.setGrayed(false);
            button.setSelection(hasTag);
        }
    }

    public static interface TagButtonTrigger {
        public void tagButtonTriggered(Tag var1, boolean var2);
    }
}

