/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.utils;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.AzureusCoreRunningListener;
import com.aelitis.azureus.core.tag.Tag;
import com.aelitis.azureus.core.tag.TagManager;
import com.aelitis.azureus.core.tag.TagManagerFactory;
import com.aelitis.azureus.core.tag.TagType;
import com.aelitis.azureus.core.util.AZ3Functions;
import com.aelitis.azureus.core.util.HTTPUtils;
import com.aelitis.azureus.core.util.LaunchManager;
import com.aelitis.azureus.ui.UIFunctions;
import com.aelitis.azureus.ui.UIFunctionsManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfo;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfoSet;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.download.impl.DownloadManagerAdapter;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.global.GlobalManagerDownloadRemovalVetoException;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentFactory;
import org.gudy.azureus2.core3.torrent.TOTorrentFile;
import org.gudy.azureus2.core3.torrent.impl.TorrentOpenOptions;
import org.gudy.azureus2.core3.tracker.host.TRHostException;
import org.gudy.azureus2.core3.util.AENetworkClassifier;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AETemporaryFileHandler;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.AsyncDispatcher;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.core3.util.TimerEventPeriodic;
import org.gudy.azureus2.core3.util.TorrentUtils;
import org.gudy.azureus2.core3.util.UrlUtils;
import org.gudy.azureus2.core3.xml.util.XUXmlWriter;
import org.gudy.azureus2.platform.PlatformManager;
import org.gudy.azureus2.platform.PlatformManagerCapabilities;
import org.gudy.azureus2.platform.PlatformManagerFactory;
import org.gudy.azureus2.plugins.PluginException;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.PluginManager;
import org.gudy.azureus2.plugins.UnloadablePlugin;
import org.gudy.azureus2.plugins.disk.DiskManagerChannel;
import org.gudy.azureus2.plugins.disk.DiskManagerEvent;
import org.gudy.azureus2.plugins.disk.DiskManagerListener;
import org.gudy.azureus2.plugins.disk.DiskManagerRequest;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.download.DownloadStub;
import org.gudy.azureus2.plugins.platform.PlatformManagerException;
import org.gudy.azureus2.plugins.sharing.ShareManager;
import org.gudy.azureus2.plugins.sharing.ShareResource;
import org.gudy.azureus2.plugins.sharing.ShareResourceDir;
import org.gudy.azureus2.plugins.sharing.ShareResourceFile;
import org.gudy.azureus2.plugins.tracker.Tracker;
import org.gudy.azureus2.plugins.tracker.TrackerTorrent;
import org.gudy.azureus2.plugins.tracker.web.TrackerWebPageRequest;
import org.gudy.azureus2.plugins.tracker.web.TrackerWebPageResponse;
import org.gudy.azureus2.plugins.ui.UIInputReceiver;
import org.gudy.azureus2.plugins.ui.UIInputReceiverListener;
import org.gudy.azureus2.plugins.utils.PooledByteBuffer;
import org.gudy.azureus2.pluginsimpl.local.PluginCoreUtils;
import org.gudy.azureus2.pluginsimpl.local.PluginInitializer;
import org.gudy.azureus2.pluginsimpl.local.utils.FormattersImpl;
import org.gudy.azureus2.ui.swt.SimpleTextEntryWindow;
import org.gudy.azureus2.ui.swt.TextViewerWindow;
import org.gudy.azureus2.ui.swt.TorrentUtil;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.mainwindow.TorrentOpener;
import org.gudy.azureus2.ui.swt.shells.CoreWaiterSWT;
import org.gudy.azureus2.ui.swt.shells.MessageBoxShell;
import org.gudy.azureus2.ui.webplugin.WebPlugin;

public class ManagerUtils {
    private static RunDownloadManager run;
    private static Map<DownloadManager, WebPlugin> browse_plugins;
    private static AsyncDispatcher async;

    public static void setRunRunnable(RunDownloadManager run) {
        ManagerUtils.run = run;
    }

    public static void run(final DownloadManager dm) {
        if (dm != null) {
            LaunchManager launch_manager = LaunchManager.getManager();
            LaunchManager.LaunchTarget target = launch_manager.createTarget(dm);
            launch_manager.launchRequest(target, new LaunchManager.LaunchAction(){

                @Override
                public void actionAllowed() {
                    AZ3Functions.provider prov = AZ3Functions.getProvider();
                    if (prov != null) {
                        prov.setOpened(dm, true);
                    }
                    Utils.execSWTThread(new Runnable(){

                        @Override
                        public void run() {
                            if (run != null) {
                                run.run(dm);
                            } else {
                                Utils.launch(dm.getSaveLocation().toString());
                            }
                        }
                    });
                }

                @Override
                public void actionDenied(Throwable reason) {
                    Debug.out("Launch request denied", reason);
                }
            });
        }
    }

    public static void open(DownloadManager dm) {
        ManagerUtils.open(dm, false);
    }

    public static void open(final DownloadManager dm, final boolean open_containing_folder_mode) {
        if (dm != null) {
            LaunchManager launch_manager = LaunchManager.getManager();
            LaunchManager.LaunchTarget target = launch_manager.createTarget(dm);
            launch_manager.launchRequest(target, new LaunchManager.LaunchAction(){

                @Override
                public void actionAllowed() {
                    Utils.execSWTThread(new Runnable(){

                        @Override
                        public void run() {
                            ManagerUtils.open(dm.getSaveLocation(), open_containing_folder_mode);
                        }
                    });
                }

                @Override
                public void actionDenied(Throwable reason) {
                    Debug.out("Launch request denied", reason);
                }
            });
        }
    }

    public static void open(final DiskManagerFileInfo file, final boolean open_containing_folder_mode) {
        if (file != null) {
            LaunchManager launch_manager = LaunchManager.getManager();
            LaunchManager.LaunchTarget target = launch_manager.createTarget(file);
            launch_manager.launchRequest(target, new LaunchManager.LaunchAction(){

                @Override
                public void actionAllowed() {
                    Utils.execSWTThread(new Runnable(){

                        @Override
                        public void run() {
                            File this_file = file.getFile(true);
                            File parent_file = open_containing_folder_mode ? this_file.getParentFile() : null;
                            ManagerUtils.open(parent_file == null ? this_file : parent_file);
                        }
                    });
                }

                @Override
                public void actionDenied(Throwable reason) {
                    Debug.out("Launch request denied", reason);
                }
            });
        }
    }

    public static void open(File f, boolean open_containing_folder_mode) {
        if (open_containing_folder_mode) {
            Utils.launch(f.getParent());
        } else {
            ManagerUtils.open(f);
        }
    }

    public static void open(File f) {
        while (f != null && !f.exists()) {
            f = f.getParentFile();
        }
        if (f == null) {
            return;
        }
        PlatformManager mgr = PlatformManagerFactory.getPlatformManager();
        if (mgr.hasCapability(PlatformManagerCapabilities.ShowFileInBrowser)) {
            try {
                PlatformManagerFactory.getPlatformManager().showFile(f.toString());
                return;
            }
            catch (PlatformManagerException e) {
                Debug.printStackTrace(e);
            }
        }
        if (f.isDirectory()) {
            Utils.launch(f.toString());
        } else {
            Utils.launch(f.getParent().toString());
        }
    }

    private static boolean getBrowseAnon(DownloadManager dm) {
        boolean anon = COConfigurationManager.getBooleanParameter("Library.LaunchWebsiteInBrowserAnon");
        if (!anon) {
            String[] nets;
            boolean found_pub = false;
            for (String net : nets = dm.getDownloadState().getNetworks()) {
                if (net != "Public") continue;
                found_pub = true;
                break;
            }
            if (nets.length > 0 && !found_pub) {
                anon = true;
            }
        }
        return anon;
    }

    private static DiskManagerFileInfo getBrowseHomePage(DownloadManager dm) {
        try {
            DiskManagerFileInfo[] files;
            for (DiskManagerFileInfo file : files = dm.getDiskManagerFileInfoSet().getFiles()) {
                String name;
                if (file.getTorrentFile().getPathComponents().length != 1 || !(name = file.getTorrentFile().getRelativePath().toLowerCase(Locale.US)).equals("index.html") && !name.equals("index.htm")) continue;
                return file;
            }
        }
        catch (Throwable e) {
            Debug.out(e);
        }
        return null;
    }

    public static boolean browseWebsite(DiskManagerFileInfo file) {
        try {
            String name = file.getTorrentFile().getRelativePath().toLowerCase(Locale.US);
            if (name.equals("index.html") || name.equals("index.htm")) {
                ManagerUtils.browse(file);
                return true;
            }
        }
        catch (Throwable e) {
            Debug.out(e);
        }
        return false;
    }

    public static boolean browseWebsite(DownloadManager dm) {
        DiskManagerFileInfo file = ManagerUtils.getBrowseHomePage(dm);
        if (file != null) {
            ManagerUtils.browse(file);
            return true;
        }
        return false;
    }

    public static String browse(DiskManagerFileInfo file) {
        boolean anon = ManagerUtils.getBrowseAnon(file.getDownloadManager());
        return ManagerUtils.browse(file, anon, true);
    }

    public static String browse(DiskManagerFileInfo file, boolean anon, boolean launch) {
        return ManagerUtils.browse(file.getDownloadManager(), file, anon, launch);
    }

    public static String browse(DownloadManager dm) {
        boolean anon = ManagerUtils.getBrowseAnon(dm);
        return ManagerUtils.browse(dm, null, anon, true);
    }

    public static String browse(DownloadManager dm, boolean anon, boolean launch) {
        return ManagerUtils.browse(dm, null, anon, launch);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String browse(final DownloadManager dm, DiskManagerFileInfo _file, final boolean anon, final boolean launch) {
        String url_suffix;
        DiskManagerFileInfo file;
        Properties props = new Properties();
        File save_location = dm.getSaveLocation();
        String root_dir = save_location.isFile() ? save_location.getParentFile().getAbsolutePath() : save_location.getAbsolutePath();
        boolean always_browse = COConfigurationManager.getBooleanParameter("Library.LaunchWebsiteInBrowserDirList");
        if (!always_browse && _file == null) {
            _file = ManagerUtils.getBrowseHomePage(dm);
        }
        if ((file = _file) == null) {
            url_suffix = "";
        } else {
            String relative_path = file.getTorrentFile().getRelativePath();
            String[] bits = relative_path.replace(File.separatorChar, '/').split("/");
            String _url_suffix = "";
            int bits_to_use = always_browse ? bits.length - 1 : bits.length;
            for (int i = 0; i < bits_to_use; ++i) {
                String bit = bits[i];
                if (bit.length() == 0) continue;
                _url_suffix = _url_suffix + (_url_suffix == "" ? "" : "/") + UrlUtils.encode(bit);
            }
            url_suffix = _url_suffix;
        }
        Map<DownloadManager, WebPlugin> map = browse_plugins;
        synchronized (map) {
            WebPlugin plugin = browse_plugins.get(dm);
            if (plugin == null) {
                props.put("Port", (Object)0);
                props.put("Bind IP", "127.0.0.1");
                props.put("Home Page", "");
                props.put("Root Dir", root_dir);
                props.put("Access", "local");
                props.put("DefaultHideResourceConfig", (Object)true);
                props.put("DefaultEnableKeepAlive", (Object)true);
                props.put("EnablePairing", (Object)false);
                props.put("EnableUPNP", (Object)false);
                props.put("EnableI2P", (Object)false);
                props.put("EnableTor", (Object)false);
                String plugin_id = "webserver:" + dm.getInternalName();
                final String plugin_name = "Web Server for " + dm.getDisplayName();
                Properties messages = new Properties();
                messages.put("plugins." + plugin_id, plugin_name);
                PluginInitializer.getDefaultInterface().getUtilities().getLocaleUtilities().integrateLocalisedMessageBundle(messages);
                final AESemaphore waiter = new AESemaphore("waiter");
                final String[] url_holder = new String[]{null};
                plugin = new UnloadableWebPlugin(props){
                    private Map<String, Object> file_map;
                    private String protocol;
                    private String host;
                    private int port;
                    {
                        super(x0);
                        this.file_map = new HashMap<String, Object>();
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    @Override
                    public void initialize(PluginInterface plugin_interface) throws PluginException {
                        DiskManagerFileInfoSet file_set = dm.getDiskManagerFileInfoSet();
                        DiskManagerFileInfo[] files = file_set.getFiles();
                        HashSet<Object> root_dir = new HashSet<Object>();
                        this.file_map.put("", root_dir);
                        for (DiskManagerFileInfo dm_file : files) {
                            TOTorrentFile file2 = dm_file.getTorrentFile();
                            String path = file2.getRelativePath();
                            this.file_map.put(path, dm_file);
                            if (path.startsWith(File.separator)) {
                                path = path.substring(1);
                            }
                            Set<Object> dir = root_dir;
                            int pos = 0;
                            while (true) {
                                int next_pos;
                                if ((next_pos = path.indexOf(File.separatorChar, pos)) == -1) break;
                                String bit = path.substring(pos, next_pos);
                                dir.add(bit);
                                String sub_path = path.substring(0, next_pos);
                                dir = (Set)this.file_map.get(sub_path);
                                if (dir == null) {
                                    dir = new HashSet();
                                    this.file_map.put(sub_path, dir);
                                }
                                pos = next_pos + 1;
                            }
                            dir.add(dm_file);
                        }
                        Properties props = plugin_interface.getPluginProperties();
                        props.put("plugin.name", plugin_name);
                        super.initialize(plugin_interface);
                        InetAddress bind_ip = this.getServerBindIP();
                        this.host = bind_ip.isAnyLocalAddress() ? "127.0.0.1" : bind_ip.getHostAddress();
                        this.port = this.getServerPort();
                        this.log("Assigned port: " + this.port);
                        this.protocol = this.getProtocol();
                        String url = this.protocol + "://" + this.host + ":" + this.port + "/" + url_suffix;
                        if (launch) {
                            Utils.launch(url, false, true, anon);
                            return;
                        }
                        String[] stringArray = url_holder;
                        synchronized (url_holder) {
                            url_holder[0] = url;
                            // ** MonitorExit[var8_10] (shouldn't be in output)
                            waiter.release();
                            return;
                        }
                    }

                    @Override
                    public boolean generate(TrackerWebPageRequest request2, TrackerWebPageResponse response) throws IOException {
                        try {
                            boolean res = super.generate(request2, response);
                            if (!res) {
                                response.setReplyStatus(404);
                            }
                        }
                        catch (Throwable e) {
                            response.setReplyStatus(404);
                        }
                        return true;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    protected boolean useFile(TrackerWebPageRequest request2, final TrackerWebPageResponse response, String root, String relative_url) throws IOException {
                        OutputStream os;
                        URL stream_url2;
                        String content_type;
                        String path;
                        URL absolute_url = request2.getAbsoluteURL();
                        String query = absolute_url.getQuery();
                        if (query != null) {
                            String[] args = query.split("&");
                            String vuze_source = null;
                            int vuze_file_index = -1;
                            String vuze_file_name = null;
                            ArrayList<String> networks = new ArrayList<String>();
                            for (String arg : args) {
                                String net;
                                String[] bits = arg.split("=");
                                String lhs = bits[0];
                                String rhs = UrlUtils.decode(bits[1]);
                                if (lhs.equals("vuze_source")) {
                                    if (!rhs.endsWith(".torrent") && !rhs.startsWith("magnet")) continue;
                                    vuze_source = rhs;
                                    continue;
                                }
                                if (lhs.equals("vuze_file_index")) {
                                    vuze_file_index = Integer.parseInt(rhs);
                                    continue;
                                }
                                if (lhs.equals("vuze_file_name")) {
                                    vuze_file_name = rhs;
                                    continue;
                                }
                                if (!lhs.equals("vuze_network") || (net = AENetworkClassifier.internalise(rhs)) == null) continue;
                                networks.add(net);
                            }
                            if (vuze_source != null) {
                                String referrer = (String)request2.getHeaders().get("referer");
                                if (referrer == null || !referrer.contains("://" + this.host + ":" + this.port)) {
                                    response.setReplyStatus(403);
                                    return true;
                                }
                                if (vuze_source.endsWith(".torrent")) {
                                    Object file_node = this.file_map.get(vuze_source);
                                    if (file_node instanceof DiskManagerFileInfo) {
                                        boolean done;
                                        DiskManagerFileInfo dm_file = (DiskManagerFileInfo)file_node;
                                        long file_size = dm_file.getLength();
                                        File target_file = dm_file.getFile(true);
                                        boolean bl = done = dm_file.getDownloaded() == file_size && target_file.length() == file_size;
                                        if (done) {
                                            return this.handleRedirect(dm, target_file, vuze_file_index, vuze_file_name, networks, request2, response);
                                        }
                                        try {
                                            File torrent_file = AETemporaryFileHandler.createTempFile();
                                            final FileOutputStream fos = new FileOutputStream(torrent_file);
                                            try {
                                                DiskManagerChannel chan = PluginCoreUtils.wrap(dm_file).createChannel();
                                                try {
                                                    DiskManagerRequest req = chan.createRequest();
                                                    req.setOffset(0L);
                                                    req.setLength(file_size);
                                                    req.addListener(new DiskManagerListener(){

                                                        @Override
                                                        public void eventOccurred(DiskManagerEvent event2) {
                                                            int type = event2.getType();
                                                            if (type == 3) {
                                                                return;
                                                            }
                                                            if (type == 2) {
                                                                throw new RuntimeException(event2.getFailure());
                                                            }
                                                            PooledByteBuffer buffer = event2.getBuffer();
                                                            if (buffer == null) {
                                                                throw new RuntimeException("eh?");
                                                            }
                                                            try {
                                                                byte[] data = buffer.toByteArray();
                                                                fos.write(data);
                                                            }
                                                            catch (IOException e) {
                                                                throw new RuntimeException("Failed to write to " + file, e);
                                                            }
                                                            finally {
                                                                buffer.returnToPool();
                                                            }
                                                        }
                                                    });
                                                    req.run();
                                                }
                                                finally {
                                                    chan.destroy();
                                                }
                                            }
                                            finally {
                                                fos.close();
                                            }
                                            return this.handleRedirect(dm, torrent_file, vuze_file_index, vuze_file_name, networks, request2, response);
                                        }
                                        catch (Throwable e) {
                                            Debug.out(e);
                                            return false;
                                        }
                                    }
                                    return false;
                                }
                                URL magnet = new URL(vuze_source);
                                File torrent_file = AETemporaryFileHandler.createTempFile();
                                try {
                                    URLConnection connection = magnet.openConnection();
                                    connection.connect();
                                    FileUtil.copyFile(connection.getInputStream(), torrent_file.getAbsoluteFile());
                                    return this.handleRedirect(dm, torrent_file, vuze_file_index, vuze_file_name, networks, request2, response);
                                }
                                catch (Throwable e) {
                                    Debug.out(e);
                                }
                            }
                        }
                        if ((path = absolute_url.getPath()).equals("/") && COConfigurationManager.getBooleanParameter("Library.LaunchWebsiteInBrowserDirList")) {
                            relative_url = "/";
                        }
                        String download_name = XUXmlWriter.escapeXML(dm.getDisplayName());
                        String relative_file = relative_url.replace('/', File.separatorChar);
                        String node_key = relative_file.substring(1);
                        Object file_node = this.file_map.get(node_key);
                        boolean file_node_is_parent = false;
                        if (file_node == null) {
                            int pos = node_key.lastIndexOf(File.separator);
                            node_key = pos == -1 ? "" : node_key.substring(0, pos);
                            file_node = this.file_map.get(node_key);
                            file_node_is_parent = true;
                        }
                        if (file_node == null) {
                            return false;
                        }
                        if (file_node instanceof Set) {
                            String file_name;
                            if (relative_url.equals("/favicon.ico")) {
                                try {
                                    InputStream stream = this.getClass().getClassLoader().getResourceAsStream("org/gudy/azureus2/ui/icons/favicon.ico");
                                    response.useStream("image/x-icon", stream);
                                    return true;
                                }
                                catch (Throwable e) {
                                    // empty catch block
                                }
                            }
                            Set kids = (Set)file_node;
                            String request_url = request2.getURL();
                            if (file_node_is_parent) {
                                int pos = request_url.lastIndexOf("/");
                                request_url = pos == -1 ? "" : request_url.substring(0, pos);
                            }
                            response.setContentType("text/html");
                            OutputStream os2 = response.getOutputStream();
                            String title = XUXmlWriter.escapeXML(UrlUtils.decode(request_url));
                            if (title.length() == 0) {
                                title = "/";
                            }
                            os2.write(("<html>\r\n <head>\r\n <meta charset=\"UTF-8\">\r\n  <title>" + download_name + ": Index of " + title + "</title>" + "\r\n" + " </head>" + "\r\n" + " <body>" + "\r\n" + "  <p>" + download_name + "</p>" + "\r\n" + "  <h1>Index of " + title + "</h1>" + "\r\n" + "  <pre><hr>" + "\r\n").getBytes("UTF-8"));
                            String root_url = request_url;
                            if (!root_url.endsWith("/")) {
                                root_url = root_url + "/";
                            }
                            if (request_url.length() > 1) {
                                int pos = request_url.lastIndexOf(47);
                                if (pos == 0) {
                                    ++pos;
                                }
                                String parent = request_url.substring(0, pos);
                                os2.write(("<a href=\"" + parent + "\">..</a>" + "\r\n").getBytes("UTF-8"));
                            }
                            ArrayList<String[]> filenames = new ArrayList<String[]>(kids.size());
                            int max_filename = 0;
                            int MAX_LEN = 120;
                            for (Object entry : kids) {
                                int len;
                                DiskManagerFileInfo file2;
                                if (entry instanceof String) {
                                    file2 = null;
                                    file_name = (String)entry;
                                } else {
                                    file2 = (DiskManagerFileInfo)entry;
                                    if (file2.isSkipped()) continue;
                                    file_name = file2.getTorrentFile().getRelativePath();
                                    int pos = file_name.lastIndexOf(File.separatorChar);
                                    if (pos != -1) {
                                        file_name = file_name.substring(pos + 1);
                                    }
                                }
                                String url = root_url + UrlUtils.encode(file_name);
                                if (file2 == null) {
                                    file_name = file_name + "/";
                                }
                                if ((len = file_name.length()) > MAX_LEN) {
                                    file_name = file_name.substring(0, MAX_LEN - 3) + "...";
                                    len = file_name.length();
                                }
                                if (len > max_filename) {
                                    max_filename = len;
                                }
                                filenames.add(new String[]{url, file_name, file2 == null ? "" : DisplayFormatters.formatByteCountToKiBEtc(file2.getLength())});
                            }
                            max_filename = (max_filename + 15) / 8 * 8;
                            char[] padding = new char[max_filename];
                            Arrays.fill(padding, ' ');
                            Collections.sort(filenames, new Comparator<String[]>(){
                                Comparator comp = new FormattersImpl().getAlphanumericComparator(true);

                                @Override
                                public int compare(String[] o1, String[] o2) {
                                    return this.comp.compare(o1[0], o2[0]);
                                }
                            });
                            for (String[] entry : filenames) {
                                file_name = entry[1];
                                int len = file_name.length();
                                StringBuilder line = new StringBuilder(max_filename + 64);
                                line.append("<a href=\"").append(entry[0]).append("\">").append(XUXmlWriter.escapeXML(file_name)).append("</a>");
                                line.append(padding, 0, max_filename - len);
                                line.append(entry[2]);
                                line.append("\r\n");
                                os2.write(line.toString().getBytes("UTF-8"));
                            }
                            os2.write(("  <hr></pre>\r\n  <address>Vuze Web Server at " + this.host + " Port " + this.getServerPort() + "</address>" + "\r\n" + " </body>" + "\r\n" + "</html>").getBytes("UTF-8"));
                            return true;
                        }
                        DiskManagerFileInfo dm_file = (DiskManagerFileInfo)file_node;
                        long file_size = dm_file.getLength();
                        File target_file = dm_file.getFile(true);
                        boolean done = dm_file.getDownloaded() == file_size && target_file.length() == file_size;
                        String relative_path = dm_file.getTorrentFile().getRelativePath();
                        int pos = relative_path.lastIndexOf(".");
                        String file_type = pos == -1 ? "" : relative_path.substring(pos + 1);
                        if (file_size >= 524288L && !(content_type = HTTPUtils.guessContentTypeFromFileType(file_type)).startsWith("text/") && !content_type.startsWith("image/") && (stream_url2 = ManagerUtils.getMediaServerContentURL(dm_file)) != null) {
                            OutputStream os3 = response.getRawOutputStream();
                            os3.write(("HTTP/1.1 302 Found\r\nLocation: " + stream_url2.toExternalForm() + "\r\n" + "\r\n").getBytes("UTF-8"));
                            return true;
                        }
                        if (done) {
                            if (file_size < 524288L) {
                                FileInputStream fis = null;
                                try {
                                    fis = new FileInputStream(target_file);
                                    response.useStream(file_type, fis);
                                    boolean stream_url2 = true;
                                    return stream_url2;
                                }
                                finally {
                                    if (fis != null) {
                                        fis.close();
                                    }
                                }
                            }
                            os = null;
                            InputStream is = null;
                            try {
                                int len;
                                os = response.getRawOutputStream();
                                os.write(("HTTP/1.1 200 OK\r\nContent-Type:" + HTTPUtils.guessContentTypeFromFileType(file_type) + "\r\n" + "Content-Length: " + file_size + "\r\n" + "Connection: close" + "\r\n" + "\r\n").getBytes("UTF-8"));
                                byte[] buffer = new byte[131072];
                                is = new FileInputStream(target_file);
                                while ((len = is.read(buffer)) > 0) {
                                    os.write(buffer, 0, len);
                                }
                            }
                            catch (Throwable e) {
                            }
                            finally {
                                try {
                                    os.close();
                                }
                                catch (Throwable e) {}
                                try {
                                    is.close();
                                }
                                catch (Throwable e) {}
                            }
                            return true;
                        }
                        dm_file.setPriority(10);
                        os = response.getRawOutputStream();
                        os.write(("HTTP/1.1 200 OK\r\nContent-Type:" + HTTPUtils.guessContentTypeFromFileType(file_type) + "\r\n" + "Content-Length: " + file_size + "\r\n" + "Connection: close" + "\r\n" + "X-Vuze-Hack: X").getBytes("UTF-8"));
                        DiskManagerChannel chan = PluginCoreUtils.wrap(dm_file).createChannel();
                        try {
                            final DiskManagerRequest req = chan.createRequest();
                            final boolean[] header_complete = new boolean[]{false};
                            final long[] last_write = new long[]{0L};
                            req.setOffset(0L);
                            req.setLength(file_size);
                            req.addListener(new DiskManagerListener(){

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                @Override
                                public void eventOccurred(DiskManagerEvent event2) {
                                    int type = event2.getType();
                                    if (type == 3) {
                                        return;
                                    }
                                    if (type == 2) {
                                        throw new RuntimeException(event2.getFailure());
                                    }
                                    PooledByteBuffer buffer = event2.getBuffer();
                                    if (buffer == null) {
                                        throw new RuntimeException("eh?");
                                    }
                                    try {
                                        boolean do_header = false;
                                        boolean[] blArray = header_complete;
                                        synchronized (header_complete) {
                                            if (!header_complete[0]) {
                                                do_header = true;
                                                header_complete[0] = true;
                                            }
                                            last_write[0] = SystemTime.getMonotonousTime();
                                            // ** MonitorExit[var5_6] (shouldn't be in output)
                                            if (do_header) {
                                                os.write("\r\n\r\n".getBytes("UTF-8"));
                                            }
                                            byte[] data = buffer.toByteArray();
                                            os.write(data);
                                        }
                                    }
                                    catch (IOException e) {
                                        throw new RuntimeException("Failed to write to " + file, e);
                                    }
                                    finally {
                                        buffer.returnToPool();
                                    }
                                    {
                                        return;
                                    }
                                }
                            });
                            TimerEventPeriodic[] timer_event = new TimerEventPeriodic[]{null};
                            timer_event[0] = SimpleTimer.addPeriodicEvent("KeepAlive", 10000L, new TimerEventPerformer(){
                                boolean cancel_outstanding = false;

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 * Enabled force condition propagation
                                 * Lifted jumps to return sites
                                 */
                                @Override
                                public void perform(TimerEvent event2) {
                                    if (this.cancel_outstanding) {
                                        req.cancel();
                                        return;
                                    }
                                    boolean[] blArray = header_complete;
                                    synchronized (header_complete) {
                                        if (header_complete[0]) {
                                            if (SystemTime.getMonotonousTime() - last_write[0] >= 300000L) {
                                                req.cancel();
                                            }
                                        } else {
                                            try {
                                                os.write("X".getBytes("UTF-8"));
                                                os.flush();
                                            }
                                            catch (Throwable e) {
                                                req.cancel();
                                            }
                                        }
                                        // ** MonitorExit[var2_2] (shouldn't be in output)
                                        if (response.isActive()) return;
                                        this.cancel_outstanding = true;
                                        return;
                                    }
                                }
                            });
                            try {
                                req.run();
                            }
                            finally {
                                timer_event[0].cancel();
                            }
                            boolean bl = true;
                            chan.destroy();
                            return bl;
                        }
                        catch (Throwable throwable) {
                            try {
                                chan.destroy();
                                throw throwable;
                            }
                            catch (Throwable e) {
                                return false;
                            }
                        }
                    }

                    private boolean handleRedirect(DownloadManager dm2, File torrent_file, int file_index, String file_name, List<String> networks, TrackerWebPageRequest request2, TrackerWebPageResponse response) {
                        try {
                            TOTorrent torrent = TOTorrentFactory.deserialiseFromBEncodedFile(torrent_file);
                            GlobalManager gm = AzureusCoreFactory.getSingleton().getGlobalManager();
                            UIFunctions uif = UIFunctionsManager.getUIFunctions();
                            TorrentOpenOptions torrent_options = new TorrentOpenOptions(torrent_file.getAbsolutePath(), torrent, false);
                            torrent_options.setTorrent(torrent);
                            String[] existing_nets = networks.size() == 0 ? dm2.getDownloadState().getNetworks() : networks.toArray(new String[networks.size()]);
                            for (String net : AENetworkClassifier.AT_NETWORKS) {
                                boolean found = false;
                                for (String x : existing_nets) {
                                    if (net != x) continue;
                                    found = true;
                                    break;
                                }
                                torrent_options.setNetworkEnabled(net, found);
                            }
                            HashMap<String, Object> add_options = new HashMap<String, Object>();
                            add_options.put("silent", true);
                            if (uif.addTorrentWithOptions(torrent_options, add_options)) {
                                long start = SystemTime.getMonotonousTime();
                                while (true) {
                                    long now;
                                    DownloadManager o_dm;
                                    if ((o_dm = gm.getDownloadManager(torrent)) != null && !o_dm.getDownloadState().getFlag(512L)) {
                                        String original_path;
                                        DiskManagerFileInfo[] files = o_dm.getDiskManagerFileInfoSet().getFiles();
                                        DiskManagerFileInfo o_dm_file = null;
                                        if (file_name != null) {
                                            for (DiskManagerFileInfo file2 : files) {
                                                String path = file2.getTorrentFile().getRelativePath();
                                                if (!path.equals(file_name)) continue;
                                                o_dm_file = file2;
                                                break;
                                            }
                                            if (o_dm_file == null) {
                                                o_dm_file = files[0];
                                            }
                                        } else if (file_index < 0) {
                                            long largest = -1L;
                                            for (DiskManagerFileInfo file3 : files) {
                                                if (file3.getLength() <= largest) continue;
                                                o_dm_file = file3;
                                                largest = file3.getLength();
                                            }
                                        } else {
                                            o_dm_file = files[file_index];
                                        }
                                        if ((original_path = request2.getAbsoluteURL().getPath()).endsWith(".html")) {
                                            String url = ManagerUtils.browse(o_dm, file_index < 0 ? null : o_dm_file, anon, false);
                                            OutputStream os = response.getRawOutputStream();
                                            os.write(("HTTP/1.1 302 Found\r\nLocation: " + url + "\r\n" + "\r\n").getBytes("UTF-8"));
                                            return true;
                                        }
                                        URL stream_url = ManagerUtils.getMediaServerContentURL(o_dm_file);
                                        if (stream_url != null) {
                                            OutputStream os = response.getRawOutputStream();
                                            os.write(("HTTP/1.1 302 Found\r\nLocation: " + stream_url.toExternalForm() + "\r\n" + "\r\n").getBytes("UTF-8"));
                                            return true;
                                        }
                                    }
                                    if ((now = SystemTime.getMonotonousTime()) - start > 180000L) {
                                        Debug.out("Timeout waiting for download to be added");
                                        return false;
                                    }
                                    Thread.sleep(1000L);
                                }
                            }
                            Debug.out("Failed to add download for some reason");
                            return false;
                        }
                        catch (Throwable e) {
                            Debug.out(e);
                            return false;
                        }
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void unload() throws PluginException {
                        Map map = browse_plugins;
                        synchronized (map) {
                            browse_plugins.remove(dm);
                        }
                        super.unload();
                    }
                };
                PluginManager.registerPlugin(plugin, plugin_id, plugin_id);
                browse_plugins.put(dm, plugin);
                if (launch) {
                    return null;
                }
                waiter.reserve(10000L);
                String[] stringArray = url_holder;
                synchronized (url_holder) {
                    // ** MonitorExit[var17_21] (shouldn't be in output)
                    return url_holder[0];
                }
            }
            String protocol = plugin.getProtocol();
            InetAddress bind_ip = plugin.getServerBindIP();
            String host = bind_ip.isAnyLocalAddress() ? "127.0.0.1" : bind_ip.getHostAddress();
            String url = protocol + "://" + host + ":" + plugin.getServerPort() + "/" + url_suffix;
            if (launch) {
                Utils.launch(url, false, true, anon);
                return null;
            }
            return url;
        }
    }

    public static URL getMediaServerContentURL(DiskManagerFileInfo file) {
        PluginManager pm = AzureusCoreFactory.getSingleton().getPluginManager();
        PluginInterface pi = pm.getPluginInterfaceByID("azupnpav", false);
        if (pi == null) {
            return null;
        }
        if (!pi.getPluginState().isOperational()) {
            return null;
        }
        try {
            String s_url;
            Object url = pi.getIPC().invoke("getContentURL", new Object[]{PluginCoreUtils.wrap(file)});
            if (url instanceof String && (s_url = (String)url).length() > 0) {
                return new URL(s_url);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return null;
    }

    public static boolean isStartable(DownloadManager dm) {
        if (dm == null) {
            return false;
        }
        int state = dm.getState();
        return state == 70;
    }

    public static boolean isStopable(DownloadManager dm) {
        if (dm == null) {
            return false;
        }
        int state = dm.getState();
        return state != 70 && state != 65;
    }

    public static boolean isPauseable(DownloadManager dm) {
        if (dm == null) {
            return false;
        }
        int state = dm.getState();
        return state != 70 && state != 65 && state != 100;
    }

    public static boolean isStopped(DownloadManager dm) {
        if (dm == null) {
            return false;
        }
        int state = dm.getState();
        return state == 70 || state == 100;
    }

    public static boolean isForceStartable(DownloadManager dm) {
        if (dm == null) {
            return false;
        }
        int state = dm.getState();
        return state == 70 || state == 75 || state == 60 || state == 50;
    }

    public static void host(AzureusCore azureus_core, DownloadManager dm) {
        if (dm == null) {
            return;
        }
        TOTorrent torrent = dm.getTorrent();
        if (torrent == null) {
            return;
        }
        try {
            azureus_core.getTrackerHost().hostTorrent(torrent, true, false);
        }
        catch (TRHostException e) {
            MessageBoxShell mb = new MessageBoxShell(33, MessageText.getString("MyTorrentsView.menu.host.error.title"), MessageText.getString("MyTorrentsView.menu.host.error.message").concat("\n").concat(e.toString()));
            mb.open(null);
        }
    }

    public static void publish(AzureusCore azureus_core, DownloadManager dm) {
        if (dm == null) {
            return;
        }
        TOTorrent torrent = dm.getTorrent();
        if (torrent == null) {
            return;
        }
        try {
            azureus_core.getTrackerHost().publishTorrent(torrent);
        }
        catch (TRHostException e) {
            MessageBoxShell mb = new MessageBoxShell(33, MessageText.getString("MyTorrentsView.menu.host.error.title"), MessageText.getString("MyTorrentsView.menu.host.error.message").concat("\n").concat(e.toString()));
            mb.open(null);
        }
    }

    public static void start(DownloadManager dm) {
        if (dm != null && dm.getState() == 70) {
            dm.setStateWaiting();
        }
    }

    public static void queue(DownloadManager dm, Composite panelNotUsed) {
        if (dm != null && dm.getState() == 70) {
            dm.setStateQueued();
        }
    }

    public static void pause(DownloadManager dm, Shell shell) {
        if (dm == null) {
            return;
        }
        int state = dm.getState();
        if (state == 70 || state == 65) {
            return;
        }
        ManagerUtils.asyncPause(dm);
    }

    public static void stop(DownloadManager dm, Shell shell) {
        ManagerUtils.stop(dm, shell, 70);
    }

    public static void stop(final DownloadManager dm, final Shell shell, final int stateAfterStopped) {
        if (dm == null) {
            return;
        }
        int state = dm.getState();
        if (state == 70 || state == 65 || state == stateAfterStopped) {
            return;
        }
        boolean stopme = true;
        if (state == 60 && dm.getStats().getShareRatio() >= 0 && dm.getStats().getShareRatio() < 1000 && COConfigurationManager.getBooleanParameter("Alert on close", false)) {
            if (!Utils.isThisThreadSWT()) {
                Utils.execSWTThread(new AERunnable(){

                    @Override
                    public void runSupport() {
                        ManagerUtils.stop(dm, shell, stateAfterStopped);
                    }
                });
                return;
            }
            Shell aShell = shell == null ? Utils.findAnyShell() : shell;
            MessageBox mb = new MessageBox(aShell, 200);
            mb.setText(MessageText.getString("seedmore.title"));
            mb.setMessage(MessageText.getString("seedmore.shareratio") + dm.getStats().getShareRatio() / 10 + "%.\n" + MessageText.getString("seedmore.uploadmore"));
            int action = mb.open();
            boolean bl = stopme = action == 64;
        }
        if (stopme) {
            ManagerUtils.asyncStop(dm, stateAfterStopped);
        }
    }

    public static void remove(DownloadManager dm, Shell unused_shell, boolean bDeleteTorrent, boolean bDeleteData) {
        ManagerUtils.remove(dm, unused_shell, bDeleteTorrent, bDeleteData, null);
    }

    public static void remove(DownloadManager dm, Shell unused_shell, boolean bDeleteTorrent, boolean bDeleteData, AERunnable deleteFailed) {
        TorrentUtil.removeDownloads(new DownloadManager[]{dm}, null);
        Debug.out("ManagerUtils.remove is Deprecated.  Use TorrentUtil.removeDownloads");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static void asyncStopDelete(final DownloadManager dm, int stateAfterStopped, final boolean bDeleteTorrent, final boolean bDeleteData, final AERunnable deleteFailed) {
        TorrentUtils.startTorrentDelete();
        final boolean[] endDone = new boolean[]{false};
        try {
            async.dispatch(new AERunnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Loose catch block
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                @Override
                public void runSupport() {
                    try {
                        boolean reallyDeleteData = bDeleteData && !dm.getDownloadState().getFlag(64L);
                        dm.getGlobalManager().removeDownloadManager(dm, bDeleteTorrent, reallyDeleteData);
                        return;
                    }
                    catch (GlobalManagerDownloadRemovalVetoException f) {
                        try {
                            int len$;
                            ShareResource[] arr$;
                            byte[] target_hash;
                            TOTorrent torrent;
                            Tracker tracker;
                            block29: {
                                PluginInterface pi = AzureusCoreFactory.getSingleton().getPluginManager().getDefaultPluginInterface();
                                ShareManager sm = pi.getShareManager();
                                tracker = pi.getTracker();
                                ShareResource[] shares = sm.getShares();
                                torrent = dm.getTorrent();
                                target_hash = torrent.getHash();
                                arr$ = shares;
                                len$ = arr$.length;
                                break block29;
                                catch (Exception ex) {
                                    Debug.printStackTrace(ex);
                                    if (deleteFailed == null) return;
                                    deleteFailed.runSupport();
                                    return;
                                }
                                finally {
                                    boolean[] blArray = endDone;
                                    synchronized (endDone) {
                                        if (!endDone[0]) {
                                            TorrentUtils.endTorrentDelete();
                                            endDone[0] = true;
                                        }
                                        // ** MonitorExit[var14_21] (shouldn't be in output)
                                    }
                                }
                            }
                            for (int i$ = 0; i$ < len$; ++i$) {
                                ShareResource share = arr$[i$];
                                int type = share.getType();
                                byte[] hash = type == 2 ? ((ShareResourceDir)share).getItem().getTorrent().getHash() : (type == 1 ? ((ShareResourceFile)share).getItem().getTorrent().getHash() : null);
                                if (hash == null || !Arrays.equals(target_hash, hash)) continue;
                                try {
                                    dm.stopIt(70, false, false);
                                }
                                catch (Throwable e) {
                                    // empty catch block
                                }
                                try {
                                    TrackerTorrent tracker_torrent = tracker.getTorrent(PluginCoreUtils.wrap(torrent));
                                    if (tracker_torrent != null) {
                                        tracker_torrent.stop();
                                    }
                                }
                                catch (Throwable e) {
                                    // empty catch block
                                }
                                share.delete();
                                return;
                            }
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        if (!f.isSilent()) {
                            UIFunctionsManager.getUIFunctions().forceNotify(1, MessageText.getString("globalmanager.download.remove.veto"), f.getMessage(), null, null, -1);
                        }
                        if (deleteFailed == null) return;
                        deleteFailed.runSupport();
                        return;
                    }
                }
            });
            return;
        }
        catch (Throwable e) {
            boolean[] blArray = endDone;
            // MONITORENTER : endDone
            if (!endDone[0]) {
                TorrentUtils.endTorrentDelete();
                endDone[0] = true;
            }
            // MONITOREXIT : blArray
            Debug.out(e);
        }
    }

    public static void asyncStop(final DownloadManager dm, final int stateAfterStopped) {
        async.dispatch(new AERunnable(){

            @Override
            public void runSupport() {
                dm.stopIt(stateAfterStopped, false, false);
            }
        });
    }

    public static void asyncPause(final DownloadManager dm) {
        async.dispatch(new AERunnable(){

            @Override
            public void runSupport() {
                dm.pause();
            }
        });
    }

    public static void asyncStartAll() {
        CoreWaiterSWT.waitForCore(CoreWaiterSWT.TriggerInThread.NEW_THREAD, new AzureusCoreRunningListener(){

            @Override
            public void azureusCoreRunning(AzureusCore core) {
                core.getGlobalManager().startAllDownloads();
            }
        });
    }

    public static void asyncStopAll() {
        CoreWaiterSWT.waitForCore(CoreWaiterSWT.TriggerInThread.NEW_THREAD, new AzureusCoreRunningListener(){

            @Override
            public void azureusCoreRunning(AzureusCore core) {
                core.getGlobalManager().stopAllDownloads();
            }
        });
    }

    public static void asyncPause() {
        CoreWaiterSWT.waitForCore(CoreWaiterSWT.TriggerInThread.NEW_THREAD, new AzureusCoreRunningListener(){

            @Override
            public void azureusCoreRunning(AzureusCore core) {
                core.getGlobalManager().pauseDownloads();
            }
        });
    }

    public static void asyncPauseForPeriod(final int seconds) {
        CoreWaiterSWT.waitForCore(CoreWaiterSWT.TriggerInThread.NEW_THREAD, new AzureusCoreRunningListener(){

            @Override
            public void azureusCoreRunning(AzureusCore core) {
                core.getGlobalManager().pauseDownloadsForPeriod(seconds);
            }
        });
    }

    public static void asyncResume() {
        CoreWaiterSWT.waitForCore(CoreWaiterSWT.TriggerInThread.NEW_THREAD, new AzureusCoreRunningListener(){

            @Override
            public void azureusCoreRunning(AzureusCore core) {
                core.getGlobalManager().resumeDownloads();
            }
        });
    }

    public static void asyncPauseForPeriod(final List<DownloadManager> dms, final int seconds) {
        CoreWaiterSWT.waitForCore(CoreWaiterSWT.TriggerInThread.NEW_THREAD, new AzureusCoreRunningListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void azureusCoreRunning(AzureusCore core) {
                final ArrayList<DownloadManager> paused = new ArrayList<DownloadManager>();
                final DownloadManagerAdapter listener = new DownloadManagerAdapter(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void stateChanged(DownloadManager manager, int state) {
                        List list = paused;
                        synchronized (list) {
                            if (!paused.remove(manager)) {
                                return;
                            }
                        }
                        manager.removeListener(this);
                    }
                };
                long target_time = SystemTime.getOffsetTime(seconds * 1000);
                for (DownloadManager dm : dms) {
                    if (!ManagerUtils.isPauseable(dm) || !dm.pause(target_time)) continue;
                    ArrayList<DownloadManager> arrayList = paused;
                    synchronized (arrayList) {
                        paused.add(dm);
                    }
                    dm.addListener(listener, false);
                }
                if (paused.size() > 0) {
                    SimpleTimer.addEvent("ManagerUtils.resumer", target_time, new TimerEventPerformer(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void perform(TimerEvent event2) {
                            ArrayList to_resume = new ArrayList();
                            List list = paused;
                            synchronized (list) {
                                to_resume.addAll(paused);
                                paused.clear();
                            }
                            for (DownloadManager dm : to_resume) {
                                dm.removeListener(listener);
                                try {
                                    dm.resume();
                                }
                                catch (Throwable e) {
                                    Debug.out(e);
                                }
                            }
                        }
                    });
                }
            }
        });
    }

    public static void moveToArchive(final List<Download> downloads, ArchiveCallback _run_when_complete) {
        final ArchiveCallback run_when_complete = _run_when_complete == null ? new ArchiveCallback() : _run_when_complete;
        Utils.getOffOfSWTThread(new AERunnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void runSupport() {
                try {
                    String title = MessageText.getString("archive.info.title");
                    String text = MessageText.getString("archive.info.text");
                    MessageBoxShell prompter = new MessageBoxShell(title, text, new String[]{MessageText.getString("Button.ok")}, 0);
                    String remember_id = "managerutils.archive.info";
                    prompter.setRemember(remember_id, true, MessageText.getString("MessageBoxWindow.nomoreprompting"));
                    prompter.setAutoCloseInMS(0);
                    prompter.open(null);
                    prompter.waitUntilClosed();
                    for (Download dm : downloads) {
                        try {
                            DownloadStub stub = dm.stubbify();
                            run_when_complete.success(dm, stub);
                        }
                        catch (Throwable e) {
                            run_when_complete.failed(dm, e);
                            Debug.out(e);
                        }
                    }
                }
                finally {
                    run_when_complete.completed();
                }
            }
        });
    }

    public static void restoreFromArchive(final List<DownloadStub> downloads, final boolean start, ArchiveCallback _run_when_complete) {
        final ArchiveCallback run_when_complete = _run_when_complete == null ? new ArchiveCallback() : _run_when_complete;
        Utils.getOffOfSWTThread(new AERunnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void runSupport() {
                try {
                    Tag tag = null;
                    try {
                        TagManager tm = TagManagerFactory.getTagManager();
                        TagType tt = tm.getTagType(3);
                        String tag_name = MessageText.getString("label.restored");
                        tag = tt.getTag(tag_name, true);
                        if (tag == null) {
                            tag = tt.createTag(tag_name, true);
                            tag.setPublic(false);
                        }
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                    }
                    for (DownloadStub dm : downloads) {
                        try {
                            Download dl = dm.destubbify();
                            if (dl != null) {
                                run_when_complete.success(dm, dl);
                                if (tag != null) {
                                    tag.addTaggable(PluginCoreUtils.unwrap(dl));
                                }
                                if (!start) continue;
                                ManagerUtils.start(PluginCoreUtils.unwrap(dl));
                                continue;
                            }
                            run_when_complete.failed(dm, new Exception("Unknown error"));
                        }
                        catch (Throwable e) {
                            run_when_complete.failed(dm, e);
                            Debug.out(e);
                        }
                    }
                }
                finally {
                    run_when_complete.completed();
                }
            }
        });
    }

    public static DownloadManager[] cleanUp(DownloadManager[] dms) {
        ArrayList<DownloadManager> result = new ArrayList<DownloadManager>();
        if (dms != null) {
            for (DownloadManager dm : dms) {
                if (dm == null || dm.isDestroyed()) continue;
                result.add(dm);
            }
        }
        return result.toArray(new DownloadManager[result.size()]);
    }

    public static void locateFiles(DownloadManager[] dms, Shell shell) {
        ManagerUtils.locateFiles(dms, null, shell);
    }

    public static void locateFiles(final DownloadManager[] dms, final DiskManagerFileInfo[][] dm_files, Shell shell) {
        DirectoryDialog dd = new DirectoryDialog(shell);
        dd.setFilterPath(TorrentOpener.getFilterPathData());
        dd.setText(MessageText.getString("MyTorrentsView.menu.locatefiles.dialog"));
        String path = dd.open();
        if (path != null) {
            TorrentOpener.setFilterPathData(path);
            final File dir = new File(path);
            final TextViewerWindow viewer = new TextViewerWindow(MessageText.getString("locatefiles.view.title"), null, "", true, true);
            viewer.setEditable(false);
            viewer.setOKEnabled(true);
            new AEThread2("FileLocator"){

                /*
                 * Exception decompiling
                 */
                @Override
                public void run() {
                    /*
                     * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                     * 
                     * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                     *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                     *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                     *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                     *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                     *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                     *     at org.benf.cfr.reader.Main.main(Main.java:54)
                     */
                    throw new IllegalStateException("Decompilation failed");
                }
            }.start();
            viewer.goModal();
        }
    }

    private static void logLine(TextViewerWindow viewer, String str) {
        ManagerUtils.log(viewer, str + "\r\n");
    }

    private static void log(final TextViewerWindow viewer, final String str) {
        Utils.execSWTThread(new Runnable(){

            @Override
            public void run() {
                if (!viewer.isDisposed()) {
                    viewer.append(str);
                }
            }
        });
    }

    private static int buildFileMap(TextViewerWindow viewer, File dir, Map<Long, Set<File>> map, long[] last_log, boolean[] quit) {
        File[] files = dir.listFiles();
        int total_files = 0;
        if (files != null) {
            for (File f : files) {
                if (quit[0]) {
                    return total_files;
                }
                long now = SystemTime.getMonotonousTime();
                if (now - last_log[0] > 250L) {
                    ManagerUtils.log(viewer, ".");
                    last_log[0] = now;
                }
                if (f.isDirectory()) {
                    total_files += ManagerUtils.buildFileMap(viewer, f, map, last_log, quit);
                    continue;
                }
                long size = f.length();
                if (size <= 0L) continue;
                ++total_files;
                Set<File> list = map.get(size);
                if (list == null) {
                    list = new HashSet<File>();
                    map.put(size, list);
                }
                list.add(f);
            }
        }
        return total_files;
    }

    public static boolean canFindMoreLikeThis() {
        try {
            PluginInterface pi = AzureusCoreFactory.getSingleton().getPluginManager().getPluginInterfaceByID("aercm");
            if (pi != null && pi.getPluginState().isOperational() && pi.getIPC().canInvoke("lookupByExpression", new Object[]{"", new String[0], new HashMap()})) {
                return true;
            }
        }
        catch (Throwable e) {
            Debug.out(e);
        }
        return false;
    }

    public static void findMoreLikeThis(DownloadManager dm, Shell shell) {
        ManagerUtils.findMoreLikeThis(dm, null, shell);
    }

    public static void findMoreLikeThis(DiskManagerFileInfo file, Shell shell) {
        ManagerUtils.findMoreLikeThis(file.getDownloadManager(), file, shell);
    }

    private static void findMoreLikeThis(final DownloadManager dm, DiskManagerFileInfo file, Shell shell) {
        String expression = file == null ? dm.getDisplayName() : file.getFile(true).getName();
        SimpleTextEntryWindow entryWindow = new SimpleTextEntryWindow("find.more.like.title", "find.more.like.msg");
        entryWindow.setPreenteredText(expression, false);
        entryWindow.selectPreenteredText(true);
        entryWindow.prompt(new UIInputReceiverListener(){

            @Override
            public void UIInputReceiverClosed(UIInputReceiver entryWindow) {
                if (!entryWindow.hasSubmittedInput()) {
                    return;
                }
                String expression = entryWindow.getSubmittedInput();
                if (expression != null && expression.trim().length() > 0) {
                    expression = expression.trim();
                    try {
                        PluginInterface pi = AzureusCoreFactory.getSingleton().getPluginManager().getPluginInterfaceByID("aercm");
                        if (pi != null && pi.getPluginState().isOperational() && pi.getIPC().canInvoke("lookupByExpression", new Object[]{"", new String[0], new HashMap()})) {
                            HashMap<String, Object> options = new HashMap<String, Object>();
                            options.put("Subscription", true);
                            options.put("Name", MessageText.getString("label.more") + ": " + expression);
                            pi.getIPC().invoke("lookupByExpression", new Object[]{expression, dm.getDownloadState().getNetworks(), options});
                        }
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                    }
                }
            }
        });
    }

    static /* synthetic */ void access$300(TextViewerWindow x0, String x1) {
        ManagerUtils.logLine(x0, x1);
    }

    static /* synthetic */ int access$400(TextViewerWindow x0, File x1, Map x2, long[] x3, boolean[] x4) {
        return ManagerUtils.buildFileMap(x0, x1, x2, x3, x4);
    }

    static /* synthetic */ void access$500(TextViewerWindow x0, String x1) {
        ManagerUtils.log(x0, x1);
    }

    static {
        browse_plugins = new IdentityHashMap<DownloadManager, WebPlugin>();
        async = new AsyncDispatcher(2000);
    }

    public static class ArchiveCallback {
        public void success(DownloadStub source, DownloadStub target) {
        }

        public void failed(DownloadStub original, Throwable error) {
        }

        public void completed() {
        }
    }

    public static interface RunDownloadManager {
        public void run(DownloadManager var1);
    }

    private static class UnloadableWebPlugin
    extends WebPlugin
    implements UnloadablePlugin {
        private UnloadableWebPlugin(Properties props) {
            super(props);
        }

        @Override
        public void unload() throws PluginException {
            super.unloadPlugin();
        }
    }
}

