/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.tableitems.tracker;

import com.aelitis.azureus.core.tracker.TrackerPeerSource;
import java.util.Locale;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.plugins.ui.tables.TableColumnInfo;
import org.gudy.azureus2.ui.swt.views.table.CoreTableColumnSWT;

public class StatusItem
extends CoreTableColumnSWT
implements TableCellRefreshListener {
    private static final String[] js_resource_keys = new String[]{"SpeedView.stats.unknown", "pairing.status.disabled", "ManagerItem.stopped", "ManagerItem.queued", "GeneralView.label.updatein.querying", "azbuddy.ui.table.online", "ManagerItem.error", "tps.status.available", "tps.status.unavailable", "ManagerItem.initializing"};
    private static String[] js_resources = new String[js_resource_keys.length];

    public StatusItem(String tableID) {
        super("status", 1, -2, 75, tableID);
        this.setRefreshInterval(-1);
        MessageText.addAndFireListener(new MessageText.MessageTextListener(){

            @Override
            public void localeChanged(Locale old_locale, Locale new_locale) {
                for (int i = 0; i < js_resources.length; ++i) {
                    js_resources[i] = MessageText.getString(js_resource_keys[i]);
                }
            }
        });
    }

    @Override
    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"essential"});
        info.setProficiency((byte)0);
    }

    @Override
    public void refresh(TableCell cell) {
        String extra;
        TrackerPeerSource ps = (TrackerPeerSource)cell.getDataSource();
        int status = ps == null ? 0 : (ps.isUpdating() ? 4 : ps.getStatus());
        String str = js_resources[status];
        String string = extra = ps == null ? "" : ps.getStatusString();
        if (status == 5) {
            int pos;
            if (extra != null && (pos = extra.indexOf(" (")) != -1) {
                str = str + extra.substring(pos);
            }
        } else if ((status == 6 || status == 2 || status == 3) && extra != null) {
            str = str + ": " + extra;
        }
        if (!cell.setSortValue((Comparable)((Object)str)) && cell.isValid()) {
            return;
        }
        cell.setText(str);
    }
}

