/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.tableitems.peers;

import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.peer.PEPeer;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.plugins.ui.tables.TableColumnInfo;
import org.gudy.azureus2.ui.swt.views.table.CoreTableColumnSWT;

public class UpSpeedLimitItem
extends CoreTableColumnSWT
implements TableCellRefreshListener {
    public static final String COLUMN_ID = "maxupspeed";

    @Override
    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"settings"});
    }

    public UpSpeedLimitItem(String table_id) {
        super(COLUMN_ID, 2, -1, 35, table_id);
        this.setRefreshInterval(-2);
    }

    @Override
    public void refresh(TableCell cell) {
        long value;
        PEPeer peer = (PEPeer)cell.getDataSource();
        long l = value = peer == null ? 0L : (long)peer.getUploadRateLimitBytesPerSecond();
        if (!cell.setSortValue(value) && cell.isValid()) {
            return;
        }
        if (value == -1L) {
            cell.setText(MessageText.getString("MyTorrents.items.UpSpeedLimit.disabled"));
        } else if (value == 0L) {
            cell.setText("\u221e");
        } else {
            cell.setText(DisplayFormatters.formatByteCountToKiBEtcPerSec(value));
        }
    }
}

