/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.tableitems.peers;

import org.gudy.azureus2.core3.peer.PEPeer;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.plugins.ui.tables.TableColumnInfo;
import org.gudy.azureus2.ui.swt.views.table.CoreTableColumnSWT;

public class UpRatioItem
extends CoreTableColumnSWT
implements TableCellRefreshListener {
    public UpRatioItem(String table_id) {
        super("UpRatio", 2, -1, 70, table_id);
        this.setRefreshInterval(-2);
    }

    @Override
    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"sharing"});
    }

    @Override
    public void refresh(TableCell cell) {
        PEPeer peer = (PEPeer)cell.getDataSource();
        float value = 0.0f;
        long lDivisor = 0L;
        long lDivident = 0L;
        if (peer != null) {
            lDivisor = peer.getStats().getTotalBytesDownloadedByPeer() - peer.getStats().getTotalDataBytesSent();
            lDivident = peer.getStats().getTotalDataBytesSent();
            if (lDivisor > 1024L) {
                value = (float)lDivident / (float)lDivisor;
                if (value == 0.0f) {
                    value = -1.0f;
                }
            } else if (lDivident > 0L) {
                value = Float.MAX_VALUE;
            }
        }
        if (!cell.setSortValue((long)((double)value * 1000.0)) && cell.isValid()) {
            return;
        }
        String s = lDivisor <= 0L ? "" : (value == Float.MAX_VALUE ? "\u221e:1" : (value == -1.0f ? "1:\u221e" : DisplayFormatters.formatDecimal(value, 2) + ":1"));
        cell.setText(s);
    }
}

