/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.tableitems.peers;

import org.gudy.azureus2.core3.peer.PEPeer;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.plugins.ui.tables.TableColumnInfo;
import org.gudy.azureus2.plugins.ui.tables.TableRow;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.mainwindow.Colors;
import org.gudy.azureus2.ui.swt.views.table.CoreTableColumnSWT;

public class SnubbedItem
extends CoreTableColumnSWT
implements TableCellRefreshListener {
    public SnubbedItem(String table_id) {
        super("S", 3, -1, 20, table_id);
        this.setRefreshInterval(-2);
    }

    @Override
    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"protocol"});
    }

    @Override
    public void refresh(TableCell cell) {
        PEPeer peer = (PEPeer)cell.getDataSource();
        boolean bSnubbed = peer == null ? false : peer.isSnubbed();
        if (!cell.setSortValue(bSnubbed ? 1L : 0L) && cell.isValid()) {
            return;
        }
        cell.setText(bSnubbed ? "*" : "");
        TableRow row = cell.getTableRow();
        if (row != null) {
            row.setForeground(Utils.colorToIntArray(bSnubbed ? Colors.grey : null));
        }
    }
}

