/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.tableitems.peers;

import org.gudy.azureus2.core3.peer.PEPeer;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.plugins.ui.tables.TableColumnInfo;
import org.gudy.azureus2.ui.swt.views.table.CoreTableColumnSWT;

public class OptimisticUnchokeItem
extends CoreTableColumnSWT
implements TableCellRefreshListener {
    public static final String COLUMN_ID = "optunchoke";

    @Override
    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"protocol"});
    }

    public OptimisticUnchokeItem(String table_id) {
        super(COLUMN_ID, 3, -1, 20, table_id);
        this.setRefreshInterval(-2);
    }

    @Override
    public void refresh(TableCell cell) {
        long value;
        PEPeer peer = (PEPeer)cell.getDataSource();
        long l = peer == null ? 0L : (value = (long)(peer.isOptimisticUnchoke() ? 1 : 0));
        if (!cell.setSortValue(value) && cell.isValid()) {
            return;
        }
        cell.setText(value == 1L ? "*" : "");
    }
}

