/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.tableitems.peers;

import org.gudy.azureus2.core3.peer.PEPeer;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.plugins.ui.tables.TableColumnInfo;
import org.gudy.azureus2.ui.swt.views.table.CoreTableColumnSWT;

public class HandshakeReservedBytesItem
extends CoreTableColumnSWT
implements TableCellRefreshListener {
    public static final String COLUMN_ID = "handshake_reserved";

    @Override
    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"protocol"});
    }

    public HandshakeReservedBytesItem(String table_id) {
        super(COLUMN_ID, -1, 80, table_id);
        this.setRefreshInterval(-2);
    }

    @Override
    public void refresh(TableCell cell) {
        PEPeer peer = (PEPeer)cell.getDataSource();
        byte[] handshake_reserved = null;
        if (peer != null) {
            handshake_reserved = peer.getHandshakeReservedBytes();
        }
        if (handshake_reserved == null) {
            cell.setText("");
            return;
        }
        cell.setText(ByteFormatter.nicePrint(handshake_reserved, false));
    }
}

