/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.tableitems.peers;

import com.aelitis.azureus.core.networkmanager.admin.NetworkAdmin;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminASN;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminASNListener;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminException;
import java.net.InetAddress;
import org.gudy.azureus2.core3.peer.PEPeer;
import org.gudy.azureus2.core3.util.AENetworkClassifier;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.plugins.ui.tables.TableColumnInfo;
import org.gudy.azureus2.ui.swt.views.table.CoreTableColumnSWT;

public class ASItem
extends CoreTableColumnSWT
implements TableCellRefreshListener {
    public static final String COLUMN_ID = "as";

    public ASItem(String table_id) {
        super(COLUMN_ID, 1, -1, 100, table_id);
        this.setRefreshInterval(-2);
    }

    @Override
    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"identification"});
    }

    @Override
    public void refresh(TableCell cell) {
        final PEPeer peer = (PEPeer)cell.getDataSource();
        String text = "";
        if (peer != null && (text = (String)peer.getUserData(ASItem.class)) == null) {
            text = "";
            peer.setUserData(ASItem.class, text);
            String peer_ip = peer.getIp();
            if (AENetworkClassifier.categoriseAddress(peer_ip) == "Public") {
                try {
                    NetworkAdmin.getSingleton().lookupASN(InetAddress.getByName(peer_ip), new NetworkAdminASNListener(){

                        @Override
                        public void success(NetworkAdminASN asn) {
                            peer.setUserData(ASItem.class, asn.getAS() + " - " + asn.getASName());
                        }

                        @Override
                        public void failed(NetworkAdminException error) {
                        }
                    });
                }
                catch (Throwable e) {
                    // empty catch block
                }
            }
        }
        if (!cell.setSortValue((Comparable)((Object)text)) && cell.isValid()) {
            return;
        }
        cell.setText(text);
    }
}

