/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.tableitems.mytorrents;

import java.util.HashMap;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.util.TimeFormatter;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellDisposeListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellToolTipListener;
import org.gudy.azureus2.plugins.ui.tables.TableColumnInfo;
import org.gudy.azureus2.ui.swt.views.table.CoreTableColumnSWT;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.TrackerCellUtils;

public class TrackerNextAccessItem
extends CoreTableColumnSWT
implements TableCellRefreshListener,
TableCellDisposeListener,
TableCellToolTipListener {
    public static final Class DATASOURCE_TYPE = Download.class;
    public static final String COLUMN_ID = "trackernextaccess";
    HashMap map = new HashMap();

    public TrackerNextAccessItem(String sTableID) {
        super(DATASOURCE_TYPE, COLUMN_ID, 2, 70, sTableID);
        this.setRefreshInterval(-2);
        this.setMinWidthAuto(true);
    }

    @Override
    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"tracker", "time"});
        info.setProficiency((byte)1);
    }

    @Override
    public void refresh(TableCell cell) {
        long value;
        DownloadManager dm = (DownloadManager)cell.getDataSource();
        if (cell.isValid() && this.map.containsKey(dm)) {
            long lNextUpdate = (Long)this.map.get(dm);
            if (System.currentTimeMillis() < lNextUpdate) {
                return;
            }
        }
        long l = value = dm == null ? 0L : (long)dm.getTrackerTime();
        if (value < -1L) {
            value = -1L;
        }
        long lNextUpdate = System.currentTimeMillis() + (value > 60L ? value % 60L : 1L) * 1000L;
        this.map.put(dm, new Long(lNextUpdate));
        if (!cell.setSortValue(value) && cell.isValid()) {
            return;
        }
        String sText = TimeFormatter.formatColon(value);
        if (value > 60L) {
            sText = "< " + sText;
        }
        TrackerCellUtils.updateColor(cell, dm, false);
        cell.setText(sText);
    }

    @Override
    public void cellHover(TableCell cell) {
        DownloadManager dm = (DownloadManager)cell.getDataSource();
        cell.setToolTip(TrackerCellUtils.getTooltipText(cell, dm, false));
    }

    @Override
    public void cellHoverComplete(TableCell cell) {
        cell.setToolTip(null);
    }

    @Override
    public void dispose(TableCell cell) {
        this.map.remove(cell.getDataSource());
    }
}

