/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.tableitems.mytorrents;

import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.peer.PEPeerManager;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.plugins.ui.tables.TableColumnInfo;
import org.gudy.azureus2.ui.swt.views.table.CoreTableColumnSWT;

public class SwarmAverageCompletion
extends CoreTableColumnSWT
implements TableCellRefreshListener {
    public static final Class DATASOURCE_TYPE = Download.class;
    public static final String COLUMN_ID = "swarm_average_completion";

    public SwarmAverageCompletion(String sTableID) {
        super(DATASOURCE_TYPE, COLUMN_ID, 2, 70, sTableID);
        this.setRefreshInterval(-1);
        this.setMinWidthAuto(true);
    }

    @Override
    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"swarm", "progress"});
        info.setProficiency((byte)1);
    }

    @Override
    public void refresh(TableCell cell) {
        PEPeerManager pm;
        int average = -1;
        DownloadManager dm = (DownloadManager)cell.getDataSource();
        if (dm != null && (pm = dm.getPeerManager()) != null) {
            average = pm.getAverageCompletionInThousandNotation();
        }
        if (!cell.setSortValue(average) && cell.isValid()) {
            return;
        }
        if (average < 0) {
            cell.setText("");
        } else {
            cell.setText(DisplayFormatters.formatPercentFromThousands(average));
        }
    }
}

