/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.tableitems.mytorrents;

import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.disk.DiskManager;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.download.DownloadManagerStats;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.ui.menus.MenuItem;
import org.gudy.azureus2.plugins.ui.menus.MenuItemListener;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableColumnInfo;
import org.gudy.azureus2.plugins.ui.tables.TableContextMenuItem;
import org.gudy.azureus2.ui.swt.SimpleTextEntryWindow;
import org.gudy.azureus2.ui.swt.views.table.utils.TableColumnCreator;
import org.gudy.azureus2.ui.swt.views.tableitems.ColumnDateSizer;

public class ShareRatioProgressItem
extends ColumnDateSizer {
    public static final Class DATASOURCE_TYPE = Download.class;
    public static final String COLUMN_ID = "sr_prog";
    private static int existing_sr;

    @Override
    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"time", "sharing", "swarm"});
        info.setProficiency((byte)1);
    }

    public ShareRatioProgressItem(String sTableID) {
        super(DATASOURCE_TYPE, COLUMN_ID, TableColumnCreator.DATE_COLUMN_WIDTH, sTableID);
        this.setRefreshInterval(-2);
        this.setMultiline(false);
        TableContextMenuItem menuSetInterval = this.addContextMenuItem("TableColumn.menu.sr_prog.interval", 1);
        menuSetInterval.setStyle(1);
        menuSetInterval.addListener(new MenuItemListener(){

            @Override
            public void selected(MenuItem menu, Object target) {
                SimpleTextEntryWindow entryWindow = new SimpleTextEntryWindow("sr_prog.window.title", "sr_prog.window.message");
                String sr_str = DisplayFormatters.formatDecimal((double)existing_sr / 1000.0, 3);
                entryWindow.setPreenteredText(sr_str, false);
                entryWindow.selectPreenteredText(true);
                entryWindow.setWidthHint(400);
                entryWindow.prompt();
                if (entryWindow.hasSubmittedInput()) {
                    try {
                        String text = entryWindow.getSubmittedInput().trim();
                        if (text.length() > 0) {
                            float f = Float.parseFloat(text);
                            int sr = (int)(f * 1000.0f);
                            COConfigurationManager.setParameter("Share Ratio Progress Interval", sr);
                        }
                    }
                    catch (Throwable e) {
                        // empty catch block
                    }
                }
            }
        });
    }

    public ShareRatioProgressItem(String tableID, boolean v) {
        this(tableID);
        this.setVisible(v);
    }

    @Override
    public void refresh(TableCell cell, long timestamp) {
        DownloadManager dm = (DownloadManager)cell.getDataSource();
        if (dm == null || existing_sr <= 0) {
            super.refresh(cell, 0L);
            return;
        }
        int dm_state = dm.getState();
        long next_eta = -1L;
        if (dm_state == 50 || dm_state == 60) {
            DownloadManagerStats stats2 = dm.getStats();
            long downloaded = stats2.getTotalGoodDataBytesReceived();
            long uploaded = stats2.getTotalDataBytesSent();
            if (downloaded <= 0L) {
                next_eta = -2L;
            } else {
                long up_speed;
                int current_sr = (int)(1000L * uploaded / downloaded);
                int mult = current_sr / existing_sr;
                int next_target_sr = (mult + 1) * existing_sr;
                long l = up_speed = stats2.getDataSendRate() == 0L ? 0L : stats2.getSmoothedDataSendRate();
                if (up_speed <= 0L) {
                    next_eta = -2L;
                } else if (dm_state == 60) {
                    long target_upload = (long)next_target_sr * downloaded / 1000L;
                    next_eta = (target_upload - uploaded) / up_speed;
                } else {
                    DiskManager disk_man = dm.getDiskManager();
                    if (disk_man != null) {
                        long down_speed;
                        long remaining = disk_man.getRemainingExcludingDND();
                        long l2 = down_speed = dm_state == 60 || stats2.getDataReceiveRate() == 0L ? 0L : stats2.getSmoothedDataReceiveRate();
                        if (down_speed <= 0L || remaining <= 0L) {
                            long target_upload = (long)next_target_sr * downloaded / 1000L;
                            next_eta = (target_upload - uploaded) / up_speed;
                        } else {
                            long time_to_sr = ((long)next_target_sr * downloaded / 1000L - uploaded) / (up_speed - down_speed * (long)next_target_sr / 1000L);
                            long time_to_completion = remaining / down_speed;
                            if (time_to_sr > 0L && time_to_sr <= time_to_completion) {
                                next_eta = time_to_sr;
                            } else {
                                long uploaded_at_completion = uploaded + up_speed * time_to_completion;
                                long downloaded_at_completion = downloaded + down_speed * time_to_completion;
                                long target_upload = (long)next_target_sr * downloaded_at_completion / 1000L;
                                next_eta = time_to_completion + (target_upload - uploaded_at_completion) / up_speed;
                            }
                        }
                    } else {
                        next_eta = -2L;
                    }
                }
            }
        }
        long data = dm.getDownloadState().getLongAttribute("sr.prog");
        long sr = (int)data;
        String sr_str = DisplayFormatters.formatDecimal((double)sr / 1000.0, 3);
        long sort_order = timestamp = (data >>> 32) * 1000L;
        sort_order += (sr & 0xFFL) << 8;
        String next_eta_str = next_eta == -1L ? "" : (next_eta == -2L ? "\u221e: " : DisplayFormatters.formatETA(next_eta) + ": ");
        String prefix = next_eta_str + sr_str + (timestamp > 0L ? ": " : "");
        super.refresh(cell, timestamp, sort_order += next_eta & 0xFFL, prefix);
    }

    static {
        COConfigurationManager.addAndFireParameterListener("Share Ratio Progress Interval", new ParameterListener(){

            @Override
            public void parameterChanged(String name) {
                existing_sr = COConfigurationManager.getIntParameter(name);
            }
        });
    }
}

