/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.tableitems.mytorrents;

import com.aelitis.azureus.ui.common.table.TableRowCore;
import org.eclipse.swt.graphics.Color;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.ui.menus.MenuItem;
import org.gudy.azureus2.plugins.ui.menus.MenuItemListener;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.plugins.ui.tables.TableColumnInfo;
import org.gudy.azureus2.plugins.ui.tables.TableContextMenuItem;
import org.gudy.azureus2.ui.swt.SimpleTextEntryWindow;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.mainwindow.Colors;
import org.gudy.azureus2.ui.swt.views.table.CoreTableColumnSWT;

public class ShareRatioItem
extends CoreTableColumnSWT
implements TableCellRefreshListener,
ParameterListener {
    public static final Class DATASOURCE_TYPE = Download.class;
    private static final String CONFIG_ID = "StartStopManager_iFirstPriority_ShareRatio";
    public static final String COLUMN_ID = "shareRatio";
    private int iMinShareRatio;
    private boolean changeFG = true;

    @Override
    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"sharing", "swarm"});
    }

    public ShareRatioItem(String sTableID) {
        super(DATASOURCE_TYPE, COLUMN_ID, 2, 73, sTableID);
        this.setType(1);
        this.setRefreshInterval(-2);
        this.setMinWidthAuto(true);
        this.setPosition(-2);
        this.iMinShareRatio = COConfigurationManager.getIntParameter(CONFIG_ID);
        COConfigurationManager.addParameterListener(CONFIG_ID, (ParameterListener)this);
        TableContextMenuItem menuItem = this.addContextMenuItem("label.set.share.ratio");
        menuItem.setStyle(1);
        menuItem.addMultiListener(new MenuItemListener(){

            @Override
            public void selected(MenuItem menu, Object target) {
                Object[] dms = (Object[])target;
                SimpleTextEntryWindow entryWindow = new SimpleTextEntryWindow("set.share.ratio.win.title", "set.share.ratio.win.msg");
                entryWindow.setPreenteredText("1.000", false);
                entryWindow.selectPreenteredText(true);
                entryWindow.prompt();
                if (entryWindow.hasSubmittedInput()) {
                    try {
                        String str = entryWindow.getSubmittedInput().trim();
                        int share_ratio = (int)(Float.parseFloat(str) * 1000.0f);
                        for (Object object : dms) {
                            if (object instanceof TableRowCore) {
                                object = ((TableRowCore)object).getDataSource(true);
                            }
                            DownloadManager dm = (DownloadManager)object;
                            dm.getStats().setShareRatio(share_ratio);
                        }
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                    }
                }
            }
        });
    }

    protected void finalize() throws Throwable {
        super.finalize();
        COConfigurationManager.removeParameterListener(CONFIG_ID, this);
    }

    @Override
    public void refresh(TableCell cell) {
        int sr;
        DownloadManager dm = (DownloadManager)cell.getDataSource();
        int n = sr = dm == null ? 0 : dm.getStats().getShareRatio();
        if (sr == Integer.MAX_VALUE) {
            sr = 0x7FFFFFFE;
        }
        if (sr == -1) {
            sr = Integer.MAX_VALUE;
        }
        if (!cell.setSortValue(sr) && cell.isValid()) {
            return;
        }
        String shareRatio = "";
        shareRatio = sr == Integer.MAX_VALUE ? "\u221e" : DisplayFormatters.formatDecimal((double)sr / 1000.0, 3);
        if (cell.setText(shareRatio) && this.changeFG) {
            Color color = sr < this.iMinShareRatio ? Colors.colorWarning : null;
            cell.setForeground(Utils.colorToIntArray(color));
        }
    }

    @Override
    public void parameterChanged(String parameterName) {
        this.iMinShareRatio = COConfigurationManager.getIntParameter(CONFIG_ID);
        this.invalidateCells();
    }

    public boolean isChangeFG() {
        return this.changeFG;
    }

    public void setChangeFG(boolean changeFG) {
        this.changeFG = changeFG;
    }
}

